/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.item.TieredShieldItem;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import org.jetbrains.annotations.NotNull;

public class CombatifyBlockEntityWithoutLevelRenderer
extends BlockEntityWithoutLevelRenderer {
    private ShieldModel shieldModel;
    private static final Material IRON_SHIELD_BASE = new Material(TextureAtlas.f_118259_, new ResourceLocation("combatify/iron_shield_base"));
    private static final Material IRON_SHIELD_BASE_NO_PATTERN = new Material(TextureAtlas.f_118259_, new ResourceLocation("combatify/iron_shield_base_nopattern"));
    private static final Material GOLDEN_SHIELD_BASE = new Material(TextureAtlas.f_118259_, new ResourceLocation("combatify/golden_shield_base"));
    private static final Material GOLDEN_SHIELD_BASE_NO_PATTERN = new Material(TextureAtlas.f_118259_, new ResourceLocation("combatify/golden_shield_base_nopattern"));
    private static final Material DIAMOND_SHIELD_BASE = new Material(TextureAtlas.f_118259_, new ResourceLocation("combatify/diamond_shield_base"));
    private static final Material DIAMOND_SHIELD_BASE_NO_PATTERN = new Material(TextureAtlas.f_118259_, new ResourceLocation("combatify/diamond_shield_base_nopattern"));
    private static final Material NETHERITE_SHIELD_BASE = new Material(TextureAtlas.f_118259_, new ResourceLocation("combatify/netherite_shield_base"));
    private static final Material NETHERITE_SHIELD_BASE_NO_PATTERN = new Material(TextureAtlas.f_118259_, new ResourceLocation("combatify/netherite_shield_base_nopattern"));
    private final EntityModelSet entityModelSet;

    public CombatifyBlockEntityWithoutLevelRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
        this.entityModelSet = p_172551_;
        this.shieldModel = new ShieldModel(this.entityModelSet.m_171103_(ModelLayers.f_171179_));
    }

    public void m_6213_(ResourceManager arg) {
        super.m_6213_(arg);
        this.shieldModel = new ShieldModel(this.entityModelSet.m_171103_(ModelLayers.f_171179_));
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        if (((Boolean)Combatify.CONFIG.tieredShields.get()).booleanValue() && stack.m_41720_() instanceof TieredShieldItem) {
            boolean hasBannerPatterns = stack.m_41737_("BlockEntityTag") != null;
            poseStack.m_85836_();
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            Material spriteIdentifier = CombatifyBlockEntityWithoutLevelRenderer.getMaterial(stack, hasBannerPatterns);
            VertexConsumer vertexConsumer = spriteIdentifier.m_119204_().m_118381_(ItemRenderer.m_115222_((MultiBufferSource)multiBufferSource, (RenderType)this.shieldModel.m_103119_(spriteIdentifier.m_119193_()), (boolean)true, (boolean)stack.m_41790_()));
            this.shieldModel.m_103711_().m_104306_(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
            if (hasBannerPatterns) {
                List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)stack), (ListTag)BannerBlockEntity.m_58487_((ItemStack)stack));
                BannerRenderer.m_112074_((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, (int)j, (ModelPart)this.shieldModel.m_103701_(), (Material)spriteIdentifier, (boolean)false, (List)list, (boolean)stack.m_41790_());
            } else {
                this.shieldModel.m_103701_().m_104306_(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            poseStack.m_85849_();
        }
        super.m_108829_(stack, displayContext, poseStack, multiBufferSource, i, j);
    }

    @NotNull
    private static Material getMaterial(ItemStack stack, boolean hasBanner) {
        Material spriteIdentifier;
        Material material = spriteIdentifier = hasBanner ? ModelBakery.f_119225_ : ModelBakery.f_119226_;
        if (stack.m_150930_((Item)TieredShieldItem.IRON_SHIELD.get())) {
            Material material2 = spriteIdentifier = hasBanner ? IRON_SHIELD_BASE : IRON_SHIELD_BASE_NO_PATTERN;
        }
        if (stack.m_150930_((Item)TieredShieldItem.GOLD_SHIELD.get())) {
            Material material3 = spriteIdentifier = hasBanner ? GOLDEN_SHIELD_BASE : GOLDEN_SHIELD_BASE_NO_PATTERN;
        }
        if (stack.m_150930_((Item)TieredShieldItem.DIAMOND_SHIELD.get())) {
            Material material4 = spriteIdentifier = hasBanner ? DIAMOND_SHIELD_BASE : DIAMOND_SHIELD_BASE_NO_PATTERN;
        }
        if (stack.m_150930_((Item)TieredShieldItem.NETHERITE_SHIELD.get())) {
            spriteIdentifier = hasBanner ? NETHERITE_SHIELD_BASE : NETHERITE_SHIELD_BASE_NO_PATTERN;
        }
        return spriteIdentifier;
    }
}

