/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ForgeConfig;
import net.atlas.combatify.config.SynchableOption;
import net.atlas.combatify.event.ClientForgeBusEventHandler;
import net.atlas.combatify.mixin.ServerGamePacketListenerAccessor;
import net.atlas.combatify.networking.C2SConfigPacket;
import net.atlas.combatify.networking.ClientPacketInfo;
import net.atlas.combatify.networking.PacketRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ConfigSynchronizer {
    private static final Map<Connection, BiMap<String, SynchableOption<?>>> CLIENT_OPTION_STORAGE = new WeakHashMap();

    public static void init() {
    }

    public static void write(FriendlyByteBuf packet, int ordinal) {
        FriendlyByteBuf configBuf = new FriendlyByteBuf(Unpooled.buffer());
        FriendlyByteBuf optionBuf = new FriendlyByteBuf(Unpooled.buffer());
        configBuf.m_130130_((int)Combatify.CONFIG.options.values().stream().filter(option -> 2 >= ordinal).count());
        Combatify.CONFIG.options.forEach((key, option) -> {
            if (2 < ordinal) {
                return;
            }
            configBuf.m_130070_(key);
            optionBuf.resetReaderIndex().resetWriterIndex();
            option.writeToBuf(optionBuf);
            configBuf.m_130130_(optionBuf.readableBytes());
            configBuf.writeBytes((ByteBuf)optionBuf);
        });
        packet.writeBytes((ByteBuf)configBuf);
    }

    public static void read(FriendlyByteBuf buf, BiConsumer<SynchableOption<?>, FriendlyByteBuf> optionConsumer) {
        ForgeConfig config = Combatify.CONFIG;
        int optionCount = buf.m_130242_();
        for (int j = 0; j < optionCount; ++j) {
            String name = buf.m_130277_();
            SynchableOption option = (SynchableOption)config.options.get((Object)name);
            if (option == null) {
                Combatify.LOGGER.error("Received override for unknown option '" + name + "' in config `combatify-config`, skipping");
                buf.skipBytes(buf.m_130242_());
                continue;
            }
            buf.m_130242_();
            optionConsumer.accept(option, buf);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void applyClient(FriendlyByteBuf buf) {
        Minecraft client = Minecraft.m_91087_();
        Combatify.LOGGER.info("Applying server overrides");
        HashMap<SynchableOption, Object> mismatchedOptions = new HashMap<SynchableOption, Object>();
        if (!client.m_91091_() || !client.m_91092_().m_129792_()) {
            ConfigSynchronizer.read(buf, (option, packetByteBuf) -> {
                Object mismatchedValue = option.findMismatch((FriendlyByteBuf)packetByteBuf);
                if (mismatchedValue != null) {
                    mismatchedOptions.put((SynchableOption)option, mismatchedValue);
                }
            });
            if (!mismatchedOptions.isEmpty()) {
                Combatify.LOGGER.error("Aborting connection, non-syncable config values were mismatched");
                mismatchedOptions.forEach((option, serverValue) -> LogUtils.getLogger().error("- Option {} in config 'combatify-config' has value '{}' but server requires '{}'", new Object[]{Combatify.CONFIG.options.inverse().get(option), option.get(), serverValue}));
                MutableComponent error = Component.m_237113_((String)"Aborting connection, non-syncable config values were mismatched.\n");
                mismatchedOptions.forEach((option, o) -> error.m_7220_((Component)Component.m_237113_((String)((String)Combatify.CONFIG.options.inverse().get(option) + " does not match the server's value of " + String.valueOf(o) + ".\n"))));
                if (client.f_91074_ != null) {
                    client.f_91074_.f_108617_.m_104910_().m_129507_((Component)error);
                }
                return;
            }
        }
        Combatify.LOGGER.info("Responding with client values");
        ClientForgeBusEventHandler.schedulePacket(new ClientPacketInfo<C2SConfigPacket>(PacketRegistration.MAIN, new C2SConfigPacket()));
    }

    public static void applyServer(ServerPlayer player, FriendlyByteBuf buf) {
        Combatify.LOGGER.info("Receiving client config");
        Connection connection = ((ServerGamePacketListenerAccessor)player.f_8906_).combatify$getConnection();
        ConfigSynchronizer.read(buf, (option, optionBuf) -> {
            BiMap config = CLIENT_OPTION_STORAGE.computeIfAbsent(connection, $ -> HashBiMap.create());
            config.put((Object)((String)config.inverse().get(option)), option.trySync((FriendlyByteBuf)optionBuf));
        });
    }
}

