/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import net.atlas.combatify.util.BlockingType;

public class ConfigurableWeaponData {
    public final Double damageOffset;
    public final Double speed;
    public final Double reach;
    public final Double chargedReach;
    public final Boolean tierable;
    public final BlockingType blockingType;
    public final Boolean hasSwordEnchants;
    public final Double piercingLevel;

    ConfigurableWeaponData(Double attackDamage, Double attackSpeed, Double attackReach, Double chargedReach, Boolean tiered, BlockingType blockingType, Boolean hasSwordEnchants, Double piercingLevel) {
        this.damageOffset = ConfigurableWeaponData.clamp(attackDamage, 0.0, 1000.0);
        this.speed = ConfigurableWeaponData.clamp(attackSpeed, -1.0, 7.5);
        this.reach = ConfigurableWeaponData.clamp(attackReach, 0.0, 1024.0);
        this.chargedReach = ConfigurableWeaponData.clamp(chargedReach, 0.0, 10.0);
        this.tierable = tiered;
        this.blockingType = blockingType;
        this.hasSwordEnchants = hasSwordEnchants;
        this.piercingLevel = piercingLevel;
    }

    public static Double clamp(Double value, double min, double max) {
        if (value == null) {
            return null;
        }
        return value < min ? min : Math.min(value, max);
    }
}

