/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import eu.midnightdust.lib.config.MidnightConfig;
import java.lang.reflect.Field;
import net.atlas.combatify.config.BooleanOption;
import net.atlas.combatify.config.DoubleOption;
import net.atlas.combatify.config.IntOption;
import net.atlas.combatify.config.SynchableOption;
import net.atlas.combatify.config.WrappableConfig;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;

public class ForgeConfig {
    public BooleanOption midairKB;
    public BooleanOption fishingHookKB;
    public BooleanOption fistDamage;
    public BooleanOption swordBlocking;
    public BooleanOption shieldOnlyWhenCharged;
    public BooleanOption sprintCritsEnabled;
    public BooleanOption saturationHealing;
    public BooleanOption fastHealing;
    public BooleanOption letVanillaConnect;
    public BooleanOption oldSprintFoodRequirement;
    public BooleanOption projectilesHaveIFrames;
    public BooleanOption magicHasIFrames;
    public BooleanOption autoAttackAllowed;
    public BooleanOption configOnlyWeapons;
    public BooleanOption tieredShields;
    public BooleanOption piercer;
    public BooleanOption defender;
    public BooleanOption attackReach;
    public BooleanOption attackSpeed;
    public BooleanOption instaAttack;
    public BooleanOption ctsAttackBalancing;
    public BooleanOption eatingInterruption;
    public BooleanOption improvedMiscEntityAttacks;
    public IntOption swordProtectionEfficacy;
    public IntOption instantHealthBonus;
    public IntOption shieldChargePercentage;
    public DoubleOption shieldDisableTime;
    public DoubleOption cleavingDisableTime;
    public DoubleOption defenderDisableReduction;
    public DoubleOption snowballDamage;
    public DoubleOption eggDamage;
    public DoubleOption bowUncertainty;
    public DoubleOption baseHandAttackSpeed;
    public DoubleOption minHitboxSize;
    public BiMap<String, SynchableOption<?>> options = HashBiMap.create();

    public ForgeConfig() {
        MidnightConfig.init((String)"combatify", WrappableConfig.class);
        this.midairKB = this.defineBoolean(WrappableConfig.class, "midairKB");
        this.fishingHookKB = this.defineBoolean(WrappableConfig.class, "fishingHookKB");
        this.fistDamage = this.defineBoolean(WrappableConfig.class, "fistDamage");
        this.swordBlocking = this.defineBoolean(WrappableConfig.class, "swordBlocking");
        this.shieldOnlyWhenCharged = this.defineBoolean(WrappableConfig.class, "shieldOnlyWhenCharged");
        this.sprintCritsEnabled = this.defineBoolean(WrappableConfig.class, "sprintCritsEnabled");
        this.saturationHealing = this.defineBoolean(WrappableConfig.class, "saturationHealing");
        this.fastHealing = this.defineBoolean(WrappableConfig.class, "fastHealing");
        this.letVanillaConnect = this.defineBoolean(WrappableConfig.class, "letVanillaConnect");
        this.oldSprintFoodRequirement = this.defineBoolean(WrappableConfig.class, "oldSprintFoodRequirement");
        this.projectilesHaveIFrames = this.defineBoolean(WrappableConfig.class, "projectilesHaveIFrames");
        this.magicHasIFrames = this.defineBoolean(WrappableConfig.class, "magicHasIFrames");
        this.autoAttackAllowed = this.defineBoolean(WrappableConfig.class, "autoAttackAllowed");
        this.configOnlyWeapons = this.defineBoolean(WrappableConfig.class, "configOnlyWeapons", true);
        this.tieredShields = this.defineBoolean(WrappableConfig.class, "tieredShields", true);
        this.piercer = this.defineBoolean(WrappableConfig.class, "piercer", true);
        this.defender = this.defineBoolean(WrappableConfig.class, "defender", true);
        this.attackReach = this.defineBoolean(WrappableConfig.class, "attackReach");
        this.attackSpeed = this.defineBoolean(WrappableConfig.class, "attackSpeed");
        this.instaAttack = this.defineBoolean(WrappableConfig.class, "instaAttack");
        this.ctsAttackBalancing = this.defineBoolean(WrappableConfig.class, "ctsAttackBalancing");
        this.eatingInterruption = this.defineBoolean(WrappableConfig.class, "eatingInterruption");
        this.improvedMiscEntityAttacks = this.defineBoolean(WrappableConfig.class, "improvedMiscEntityAttacks");
        this.swordProtectionEfficacy = this.defineIntRange(WrappableConfig.class, "swordProtectionEfficacy");
        this.instantHealthBonus = this.defineIntRange(WrappableConfig.class, "instantHealthBonus");
        this.shieldChargePercentage = this.defineIntRange(WrappableConfig.class, "shieldChargePercentage");
        this.shieldDisableTime = this.defineDoubleRange(WrappableConfig.class, "shieldDisableTime");
        this.cleavingDisableTime = this.defineDoubleRange(WrappableConfig.class, "cleavingDisableTime");
        this.defenderDisableReduction = this.defineDoubleRange(WrappableConfig.class, "defenderDisableReduction");
        this.snowballDamage = this.defineDoubleRange(WrappableConfig.class, "snowballDamage");
        this.eggDamage = this.defineDoubleRange(WrappableConfig.class, "eggDamage");
        this.bowUncertainty = this.defineDoubleRange(WrappableConfig.class, "bowUncertainty");
        this.baseHandAttackSpeed = this.defineDoubleRange(WrappableConfig.class, "baseHandAttackSpeed");
        this.minHitboxSize = this.defineDoubleRange(WrappableConfig.class, "minHitboxSize");
    }

    public BooleanOption defineBoolean(Class<? extends MidnightConfig> builder, String path) {
        return this.defineBoolean(builder, path, false);
    }

    public BooleanOption defineBoolean(Class<? extends MidnightConfig> builder, String path, boolean restartRequired) {
        try {
            Field booleanValue = builder.getField(path);
            if (!booleanValue.isAnnotationPresent(MidnightConfig.Entry.class) || booleanValue.getType() != Boolean.TYPE && booleanValue.getType() != Boolean.class) {
                throw new ReportedException(new CrashReport("Tried to access an invalid config option!", (Throwable)new NoSuchFieldException()));
            }
            BooleanOption option = new BooleanOption(booleanValue, restartRequired);
            this.options.put((Object)path, (Object)option);
            return option;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new ReportedException(new CrashReport("Tried to access an invalid config option!", (Throwable)e));
        }
    }

    public IntOption defineIntRange(Class<? extends MidnightConfig> builder, String path) {
        return this.defineIntRange(builder, path, false);
    }

    public IntOption defineIntRange(Class<? extends MidnightConfig> builder, String path, boolean restartRequired) {
        try {
            Field intValue = builder.getField(path);
            if (!intValue.isAnnotationPresent(MidnightConfig.Entry.class) || intValue.getType() != Integer.TYPE && intValue.getType() != Integer.class) {
                throw new ReportedException(new CrashReport("Tried to access an invalid config option!", (Throwable)new NoSuchFieldException()));
            }
            IntOption option = new IntOption(intValue, restartRequired);
            this.options.put((Object)path, (Object)option);
            return option;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new ReportedException(new CrashReport("Tried to access an invalid config option!", (Throwable)e));
        }
    }

    public DoubleOption defineDoubleRange(Class<? extends MidnightConfig> builder, String path) {
        return this.defineDoubleRange(builder, path, false);
    }

    public DoubleOption defineDoubleRange(Class<? extends MidnightConfig> builder, String path, boolean restartRequired) {
        try {
            Field doubleValue = builder.getField(path);
            if (!doubleValue.isAnnotationPresent(MidnightConfig.Entry.class) || doubleValue.getType() != Double.TYPE && doubleValue.getType() != Double.class) {
                throw new ReportedException(new CrashReport("Tried to access an invalid config option!", (Throwable)new NoSuchFieldException()));
            }
            DoubleOption option = new DoubleOption(doubleValue, restartRequired);
            this.options.put((Object)path, (Object)option);
            return option;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new ReportedException(new CrashReport("Tried to access an invalid config option!", (Throwable)e));
        }
    }
}

