/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import java.lang.reflect.Field;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.network.FriendlyByteBuf;

public abstract class SynchableOption<T> {
    private final Field value;
    private T overrideValue = null;
    protected final boolean restartRequired;

    public SynchableOption(Field configValue, boolean requiresRestart) {
        this.value = configValue;
        this.restartRequired = requiresRestart;
    }

    public final SynchableOption<T> trySync(FriendlyByteBuf buf) {
        this.overrideValue = this.readFromBuf(buf);
        return this;
    }

    public final T findMismatch(FriendlyByteBuf buf) {
        this.overrideValue = this.readFromBuf(buf);
        try {
            if (this.restartRequired && this.overrideValue != this.value.get(null)) {
                return this.overrideValue;
            }
        }
        catch (IllegalAccessException e) {
            throw new ReportedException(new CrashReport("Access to this option is not allowed! This should not happen!", (Throwable)e));
        }
        return null;
    }

    abstract T readFromBuf(FriendlyByteBuf var1);

    public final T get() {
        if (this.overrideValue != null) {
            return this.overrideValue;
        }
        try {
            return (T)this.value.get(null);
        }
        catch (IllegalAccessException e) {
            throw new ReportedException(new CrashReport("Access to this option is not allowed! This should not happen!", (Throwable)e));
        }
    }

    abstract void writeToBuf(FriendlyByteBuf var1);

    public final void restore() {
        this.overrideValue = null;
    }
}

