/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.ConfigurableWeaponData;
import net.atlas.combatify.extensions.DefaultedItemExtensions;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.WeaponWithType;
import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.util.BlockingType;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class LongSwordItem
extends TieredItem
implements Vanishable,
ItemExtensions,
WeaponWithType,
DefaultedItemExtensions {
    private Multimap<Attribute, AttributeModifier> defaultModifiers;

    public LongSwordItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
        ImmutableMultimap.Builder var3 = ImmutableMultimap.builder();
        this.getWeaponType().addCombatAttributes(this.m_43314_(), (ImmutableMultimap.Builder<Attribute, AttributeModifier>)var3);
        this.defaultModifiers = var3.build();
    }

    @Override
    public void modifyAttributeModifiers() {
        ImmutableMultimap.Builder var3 = ImmutableMultimap.builder();
        this.getWeaponType().addCombatAttributes(this.m_43314_(), (ImmutableMultimap.Builder<Attribute, AttributeModifier>)var3);
        ImmutableMultimap output = var3.build();
        this.setDefaultModifiers((ImmutableMultimap<Attribute, AttributeModifier>)output);
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player miner) {
        return !miner.m_7500_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return state.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            stack.m_41622_(2, miner, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState state) {
        return state.m_60713_(Blocks.f_50033_);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    @Override
    public void setStackSize(int stackSize) {
        this.f_41370_ = stackSize;
    }

    @Override
    public double getPiercingLevel() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.piercingLevel != null) {
                return configurableItemData.piercingLevel;
            }
        }
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this.getWeaponType())) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this.getWeaponType());
            if (configurableWeaponData.piercingLevel != null) {
                return configurableWeaponData.piercingLevel;
            }
        }
        return this.m_43314_() == Tiers.NETHERITE || this.m_43314_().m_6604_() >= 4 ? 0.2 : (this.m_43314_() == Tiers.GOLD || this.m_43314_() == Tiers.WOOD || this.m_43314_() == Tiers.STONE || this.m_43314_().m_6631_() <= 1.0f ? 0.0 : 0.1 * (double)(this.m_43314_().m_6604_() - 1));
    }

    @Override
    public WeaponType getWeaponType() {
        WeaponType type;
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this) && (type = Combatify.ITEMS.configuredItems.get((Object)this).type) != null) {
            return type;
        }
        return WeaponType.LONGSWORD;
    }

    @Override
    public double getChargedAttackBonus() {
        LongSwordItem item = this;
        double chargedBonus = this.getWeaponType().getChargedReach();
        if (Combatify.ITEMS.configuredItems.containsKey(item)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
            if (configurableItemData.chargedReach != null) {
                chargedBonus = configurableItemData.chargedReach;
            }
        }
        return chargedBonus;
    }

    @Override
    public BlockingType getBlockingType() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.blockingType != null) {
                return configurableItemData.blockingType;
            }
        }
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this.getWeaponType())) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this.getWeaponType());
            if (configurableWeaponData.blockingType != null) {
                return configurableWeaponData.blockingType;
            }
        }
        return Combatify.EMPTY;
    }

    @Override
    public void setDefaultModifiers(ImmutableMultimap<Attribute, AttributeModifier> modifiers) {
        this.defaultModifiers = modifiers;
    }
}

