/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.item;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.client.CombatifyBlockEntityWithoutLevelRenderer;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.ConfigurableWeaponData;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.Tierable;
import net.atlas.combatify.util.BlockingType;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class TieredShieldItem
extends ShieldItem
implements Tierable,
ItemExtensions {
    public final Tier tier;
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"combatify");
    public static final RegistryObject<Item> IRON_SHIELD = TieredShieldItem.registerItem(Combatify.id("iron_shield"), () -> new TieredShieldItem((Tier)Tiers.IRON, new Item.Properties().m_41503_(Tiers.IRON.m_6609_() * 3)));
    public static final RegistryObject<Item> GOLD_SHIELD = TieredShieldItem.registerItem(Combatify.id("golden_shield"), () -> new TieredShieldItem((Tier)Tiers.GOLD, new Item.Properties().m_41503_(Tiers.GOLD.m_6609_() * 6)));
    public static final RegistryObject<Item> DIAMOND_SHIELD = TieredShieldItem.registerItem(Combatify.id("diamond_shield"), () -> new TieredShieldItem((Tier)Tiers.DIAMOND, new Item.Properties().m_41503_(Tiers.DIAMOND.m_6609_() * 2)));
    public static final RegistryObject<Item> NETHERITE_SHIELD = TieredShieldItem.registerItem(Combatify.id("netherite_shield"), () -> new TieredShieldItem((Tier)Tiers.NETHERITE, new Item.Properties().m_41503_(Tiers.NETHERITE.m_6609_() * 2).m_41486_()));

    public TieredShieldItem(Tier tier, Item.Properties properties) {
        super(properties);
        this.tier = tier;
        Combatify.shields.add(this);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerModelPredicate);
    }

    private void registerModelPredicate() {
        ItemProperties.register((Item)this, (ResourceLocation)new ResourceLocation("blocking"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.m_21254_() && MethodHandler.getBlockingItem(livingEntity).stack() == itemStack ? 1.0f : 0.0f);
    }

    public int m_6473_() {
        return this.tier.m_6601_();
    }

    public boolean m_6832_(ItemStack itemStack, ItemStack itemStack2) {
        return this.tier.m_6282_().test(itemStack2);
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        if (((Boolean)Combatify.CONFIG.tieredShields.get()).booleanValue()) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new CombatifyBlockEntityWithoutLevelRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
                }
            });
        }
    }

    @Override
    public void setStackSize(int stackSize) {
        this.f_41370_ = stackSize;
    }

    @Override
    public double getChargedAttackBonus() {
        TieredShieldItem item = this;
        double chargedBonus = 1.0;
        if (Combatify.ITEMS.configuredItems.containsKey(item)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
            if (configurableItemData.type != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)configurableItemData.type) && Combatify.ITEMS.configuredWeapons.get((Object)((Object)configurableItemData.type)).chargedReach != null) {
                chargedBonus = Combatify.ITEMS.configuredWeapons.get((Object)((Object)configurableItemData.type)).chargedReach;
            }
            if (configurableItemData.chargedReach != null) {
                chargedBonus = configurableItemData.chargedReach;
            }
        }
        return chargedBonus;
    }

    @Override
    public BlockingType getBlockingType() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.blockingType != null) {
                return configurableItemData.blockingType;
            }
            if (configurableItemData.type != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)configurableItemData.type)) {
                ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)configurableItemData.type);
                if (configurableWeaponData.blockingType != null) {
                    return configurableWeaponData.blockingType;
                }
            }
        }
        return Combatify.registeredTypes.get("new_shield");
    }

    public static RegistryObject<Item> registerItem(ResourceLocation resourceLocation, Supplier<Item> item) {
        return ITEMS.register(resourceLocation.m_135815_(), item);
    }

    @Override
    public double getPiercingLevel() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.piercingLevel != null) {
                return configurableItemData.piercingLevel;
            }
            if (configurableItemData.type != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)configurableItemData.type)) {
                ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)configurableItemData.type);
                if (configurableWeaponData.piercingLevel != null) {
                    return configurableWeaponData.piercingLevel;
                }
            }
        }
        return 0.0;
    }
}

