/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import java.util.UUID;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableWeaponData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.IExtensibleEnum;

public enum WeaponType implements IExtensibleEnum
{
    EMPTY,
    SWORD,
    LONGSWORD,
    AXE,
    PICKAXE,
    HOE,
    SHOVEL,
    KNIFE,
    TRIDENT;

    public static final UUID BASE_ATTACK_SPEED_CTS_UUID;
    public static final UUID BASE_ATTACK_REACH_UUID;

    public void addCombatAttributes(Tier tier, ImmutableMultimap.Builder<Attribute, AttributeModifier> attributeModifiers) {
        if (this.isEmpty()) {
            return;
        }
        double speed = this.getSpeed(tier);
        double damage = this.getDamage(tier);
        double reach = this.getReach();
        attributeModifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(Item.f_41374_, "Weapon modifier", damage, AttributeModifier.Operation.ADDITION));
        if (!((Boolean)Combatify.CONFIG.instaAttack.get()).booleanValue()) {
            attributeModifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(BASE_ATTACK_SPEED_CTS_UUID, "Weapon modifier", speed, AttributeModifier.Operation.ADDITION));
        }
        if (reach != 0.0 && ((Boolean)Combatify.CONFIG.attackReach.get()).booleanValue()) {
            attributeModifiers.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ATTACK_REACH_UUID, "Weapon modifier", reach, AttributeModifier.Operation.ADDITION));
        }
    }

    public void addCombatAttributes(Tier tier, ArrayListMultimap<Attribute, AttributeModifier> attributeModifiers) {
        if (this.isEmpty()) {
            return;
        }
        double speed = this.getSpeed(tier);
        double damage = this.getDamage(tier);
        double reach = this.getReach();
        attributeModifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(Item.f_41374_, "Weapon modifier", damage, AttributeModifier.Operation.ADDITION));
        if (!((Boolean)Combatify.CONFIG.instaAttack.get()).booleanValue()) {
            attributeModifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(BASE_ATTACK_SPEED_CTS_UUID, "Weapon modifier", speed, AttributeModifier.Operation.ADDITION));
        }
        if (reach != 0.0 && ((Boolean)Combatify.CONFIG.attackReach.get()).booleanValue()) {
            attributeModifiers.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ATTACK_REACH_UUID, "Weapon modifier", reach, AttributeModifier.Operation.ADDITION));
        }
    }

    public double getDamage(Tier tier) {
        boolean isCTSNotT1;
        int modifier = (Boolean)Combatify.CONFIG.fistDamage.get() != false ? 1 : 0;
        double damageBonus = tier.m_6631_() + (float)modifier;
        boolean isNotTier1 = tier != Tiers.WOOD && tier != Tiers.GOLD && damageBonus != (double)((Boolean)Combatify.CONFIG.fistDamage.get() != false ? 1 : 0);
        boolean bl = isCTSNotT1 = isNotTier1 && (Boolean)Combatify.CONFIG.ctsAttackBalancing.get() != false;
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.damageOffset != null) {
                if (configurableWeaponData.tierable.booleanValue()) {
                    if (isCTSNotT1) {
                        return damageBonus + configurableWeaponData.damageOffset;
                    }
                    return damageBonus + configurableWeaponData.damageOffset + 1.0;
                }
                return (double)modifier + configurableWeaponData.damageOffset;
            }
        }
        switch (this.ordinal()) {
            case 4: 
            case 7: {
                if (isCTSNotT1) {
                    return damageBonus;
                }
                return damageBonus + 1.0;
            }
            case 1: {
                if (isCTSNotT1) {
                    return damageBonus + 1.0;
                }
                return damageBonus + 2.0;
            }
            case 3: {
                if (!((Boolean)Combatify.CONFIG.ctsAttackBalancing.get()).booleanValue()) {
                    return (isNotTier1 ? (tier == Tiers.NETHERITE ? 8 : 7) : 5) + modifier;
                }
                if (isCTSNotT1) {
                    return damageBonus + 2.0;
                }
                return damageBonus + 3.0;
            }
            case 2: 
            case 5: {
                if (tier != Tiers.IRON && tier != Tiers.DIAMOND) {
                    if (tier == Tiers.NETHERITE || tier.m_6604_() >= 4) {
                        return tier == Tiers.NETHERITE ? (double)(2 + modifier) : 2.0 + damageBonus - 4.0 + (double)modifier;
                    }
                    return modifier;
                }
                return 1 + modifier;
            }
            case 6: {
                return damageBonus;
            }
            case 8: {
                return 5 + modifier + ((Boolean)Combatify.CONFIG.ctsAttackBalancing.get() != false ? 0 : 2);
            }
        }
        return 0.0 + (double)modifier;
    }

    public double getSpeed(Tier tier) {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.speed != null) {
                return configurableWeaponData.speed - (Double)Combatify.CONFIG.baseHandAttackSpeed.get();
            }
        }
        switch (this.ordinal()) {
            case 7: {
                return 1.0;
            }
            case 1: 
            case 2: {
                return 0.5;
            }
            case 3: 
            case 6: 
            case 8: {
                return -0.5;
            }
            case 5: {
                if (tier == Tiers.WOOD) {
                    return -0.5;
                }
                if (tier == Tiers.IRON) {
                    return 0.5;
                }
                if (tier == Tiers.DIAMOND || tier == Tiers.GOLD) {
                    return 1.0;
                }
                if (tier == Tiers.NETHERITE || tier.m_6604_() >= 4) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    public double getReach() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.reach != null) {
                return configurableWeaponData.reach - 2.5;
            }
        }
        return switch (this.ordinal()) {
            case 1 -> 0.5;
            case 2, 5, 8 -> 1.0;
            default -> 0.0;
        };
    }

    public double getChargedReach() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.chargedReach != null) {
                return configurableWeaponData.chargedReach;
            }
        }
        return 1.0;
    }

    public boolean hasSwordEnchants() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.hasSwordEnchants != null) {
                return configurableWeaponData.hasSwordEnchants;
            }
        }
        return switch (this.ordinal()) {
            case 1, 2, 3, 7 -> true;
            default -> false;
        };
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static WeaponType fromID(String id) {
        return WeaponType.valueOf(id);
    }

    public static WeaponType create(String name) {
        throw new IllegalStateException("Enum not extended");
    }

    static {
        BASE_ATTACK_SPEED_CTS_UUID = UUID.fromString("FA233E1C-4110-4865-B01B-901007a318e1");
        BASE_ATTACK_REACH_UUID = UUID.fromString("26cb07a3-209d-4110-8e10-1010243614c8");
    }
}

