/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.extensions.IUpdateAttributesPacket;
import net.atlas.combatify.item.WeaponType;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ClientboundUpdateAttributesPacket.class})
public class ClientboundUpdateAttributesPacketMixin
implements IUpdateAttributesPacket {
    @Shadow
    @Final
    private List<ClientboundUpdateAttributesPacket.AttributeSnapshot> f_133577_;

    @Override
    public void changeAttributes(ServerPlayer reciever) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        HashMap<Integer, AttributeModifier> modifierMap = new HashMap<Integer, AttributeModifier>();
        for (ClientboundUpdateAttributesPacket.AttributeSnapshot attributeSnapshot : this.f_133577_) {
            if (attributeSnapshot.m_133601_() != Attributes.f_22283_ || !Combatify.unmoddedPlayers.contains(reciever.m_20148_())) continue;
            double speed = this.calculateValue(attributeSnapshot.m_133602_(), attributeSnapshot.m_133603_(), attributeSnapshot.m_133601_());
            boolean hasVanilla = Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA) || !attributeSnapshot.m_133603_().stream().filter(attributeModifier -> attributeModifier.m_22209_() == Item.f_41375_).toList().isEmpty() && !Combatify.getState().equals((Object)Combatify.CombatifyState.CTS_8C);
            for (double newSpeed = speed - 1.5; newSpeed > 0.0; newSpeed -= 0.001) {
                if (ClientboundUpdateAttributesPacketMixin.vanillaMath(newSpeed) != ClientboundUpdateAttributesPacketMixin.CTSMath(speed, hasVanilla) * 2) continue;
                if (newSpeed - 2.5 == 0.0) break;
                modifierMap.put(this.f_133577_.indexOf(attributeSnapshot), new AttributeModifier(WeaponType.BASE_ATTACK_SPEED_CTS_UUID, "Calculated client modifier", newSpeed - 2.5, AttributeModifier.Operation.ADDITION));
                break;
            }
            indexes.add(this.f_133577_.indexOf(attributeSnapshot));
        }
        if (!indexes.isEmpty()) {
            for (Integer index : indexes) {
                AttributeModifier modifierToSend = (AttributeModifier)modifierMap.get(index);
                List<AttributeModifier> newModifiers = Collections.singletonList(modifierToSend);
                ClientboundUpdateAttributesPacket.AttributeSnapshot attributeSnapshot = this.f_133577_.remove(index);
                this.f_133577_.add(index, new ClientboundUpdateAttributesPacket.AttributeSnapshot(attributeSnapshot.m_133601_(), attributeSnapshot.m_133602_() - 1.5, newModifiers));
            }
        }
    }

    public final double calculateValue(double baseValue, Collection<AttributeModifier> modifiers, Attribute attribute) {
        double attributeInstanceBaseValue = baseValue;
        List<AttributeModifier> additionList = modifiers.stream().filter(attributeModifier -> attributeModifier.m_22217_() == AttributeModifier.Operation.ADDITION).toList();
        List<AttributeModifier> multiplyBaseList = modifiers.stream().filter(attributeModifier -> attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE).toList();
        List<AttributeModifier> multiplyTotalList = modifiers.stream().filter(attributeModifier -> attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE).toList();
        for (AttributeModifier attributeModifier2 : additionList) {
            attributeInstanceBaseValue += attributeModifier2.m_22218_();
        }
        for (AttributeModifier attributeModifier2 : multiplyBaseList) {
            attributeInstanceBaseValue += attributeInstanceBaseValue * attributeModifier2.m_22218_();
        }
        for (AttributeModifier attributeModifier2 : multiplyTotalList) {
            attributeInstanceBaseValue *= 1.0 + attributeModifier2.m_22218_();
        }
        return attribute.m_6740_(attributeInstanceBaseValue);
    }

    private static int CTSMath(double attackSpeed, boolean hasVanilla) {
        double d = attackSpeed - 1.5;
        if (hasVanilla || d <= 0.0) {
            d += 1.5;
        }
        d = 1.0 / d * 20.0 + (hasVanilla ? 0.0 : 0.5);
        return (int)d;
    }

    private static int vanillaMath(double attackSpeed) {
        double d = attackSpeed;
        d = 1.0 / d * 20.0;
        return (int)d;
    }
}

