/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.ConfigurableWeaponData;
import net.atlas.combatify.extensions.DefaultedItemExtensions;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.WeaponWithType;
import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.util.BlockingType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Vanishable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={DiggerItem.class})
public abstract class DiggerItemMixin
extends TieredItem
implements Vanishable,
ItemExtensions,
DefaultedItemExtensions,
WeaponWithType {
    @Shadow
    private Multimap<Attribute, AttributeModifier> f_40982_;

    public DiggerItemMixin(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public void modifyAttributeModifiers() {
        if (this.getWeaponType().isEmpty()) {
            return;
        }
        ImmutableMultimap.Builder var3 = ImmutableMultimap.builder();
        this.getWeaponType().addCombatAttributes(this.m_43314_(), (ImmutableMultimap.Builder<Attribute, AttributeModifier>)var3);
        ImmutableMultimap output = var3.build();
        this.setDefaultModifiers((ImmutableMultimap<Attribute, AttributeModifier>)output);
    }

    @WrapOperation(method={"hurtEnemy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V")})
    public <T extends LivingEntity> void damage(ItemStack instance, int amount, T entity, Consumer<T> breakCallback, Operation<Void> original) {
        boolean bl = instance.m_41720_() instanceof AxeItem;
        if (bl) {
            --amount;
        }
        original.call(new Object[]{instance, amount, entity, breakCallback});
    }

    @Override
    public void setDefaultModifiers(ImmutableMultimap<Attribute, AttributeModifier> modifiers) {
        this.f_40982_ = modifiers;
    }

    @Override
    public void setStackSize(int stackSize) {
        this.f_41370_ = stackSize;
    }

    @Override
    public WeaponType getWeaponType() {
        WeaponType type;
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this) && (type = Combatify.ITEMS.configuredItems.get((Object)this).type) != null) {
            return type;
        }
        return WeaponType.EMPTY;
    }

    @Override
    public double getChargedAttackBonus() {
        DiggerItemMixin item = this;
        double chargedBonus = this.getWeaponType().getChargedReach();
        if (Combatify.ITEMS.configuredItems.containsKey(item)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
            if (configurableItemData.chargedReach != null) {
                chargedBonus = configurableItemData.chargedReach;
            }
        }
        return chargedBonus;
    }

    @Override
    public BlockingType getBlockingType() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.blockingType != null) {
                return configurableItemData.blockingType;
            }
        }
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this.getWeaponType())) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this.getWeaponType());
            if (configurableWeaponData.blockingType != null) {
                return configurableWeaponData.blockingType;
            }
        }
        return Combatify.EMPTY;
    }

    @Override
    public double getPiercingLevel() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.piercingLevel != null) {
                return configurableItemData.piercingLevel;
            }
        }
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this.getWeaponType())) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this.getWeaponType());
            if (configurableWeaponData.piercingLevel != null) {
                return configurableWeaponData.piercingLevel;
            }
        }
        return 0.0;
    }
}

