/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.Objects;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.LivingEntityExtensions;
import net.atlas.combatify.networking.PacketRegistration;
import net.atlas.combatify.networking.RemainingUseSyncPacket;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=1400)
public abstract class LivingEntityMixin
extends Entity
implements LivingEntityExtensions {
    @Unique
    private double combatify$piercingNegation;
    @Unique
    LivingEntity combatify$thisEntity = (LivingEntity)LivingEntity.class.cast(this);
    @Shadow
    protected int f_20936_;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract double m_21133_(Attribute var1);

    @Shadow
    protected abstract void m_6472_(DamageSource var1, float var2);

    @Shadow
    public abstract int m_21230_();

    @ModifyReturnValue(method={"isBlocking"}, at={@At(value="RETURN")})
    public boolean isBlocking(boolean original) {
        return !MethodHandler.getBlockingItem(this.combatify$thisEntity).stack().m_41619_();
    }

    @Inject(method={"blockedByShield"}, at={@At(value="HEAD")}, cancellable=true)
    public void blockedByShield(LivingEntity target, CallbackInfo ci) {
        MethodHandler.tryDisableShield(this.combatify$thisEntity, target);
        ci.cancel();
    }

    @Override
    public void setPiercingNegation(double negation) {
        this.combatify$piercingNegation = negation;
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    public void addPiercing(DamageSource source, float f, CallbackInfoReturnable<Float> cir) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.combatify$isSourceAnyOf(source, DamageTypes.f_268464_, DamageTypes.f_268511_, DamageTypes.f_268566_)) {
                Item item = livingEntity.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                double d = 0.0;
                d += ((ItemExtensions)item).getPiercingLevel();
                if (((Boolean)Combatify.CONFIG.piercer.get()).booleanValue()) {
                    d += (double)CustomEnchantmentHelper.getPierce(livingEntity) * 0.1;
                }
                d -= this.combatify$piercingNegation;
                d = Math.max(0.0, d);
                this.combatify$piercingNegation = 0.0;
                if (d > 0.0) {
                    cir.setReturnValue((Object)Float.valueOf(this.combatify$getNewDamageAfterArmorAbsorb(source, f, d)));
                }
            }
        }
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    public void addPiercing1(DamageSource source, float f, CallbackInfoReturnable<Float> cir) {
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.combatify$isSourceAnyOf(source, DamageTypes.f_268464_, DamageTypes.f_268511_, DamageTypes.f_268566_)) {
                Item item = livingEntity.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                double d = 0.0;
                d += ((ItemExtensions)item).getPiercingLevel();
                if (((Boolean)Combatify.CONFIG.piercer.get()).booleanValue()) {
                    d += (double)CustomEnchantmentHelper.getPierce(livingEntity) * 0.1;
                }
                d -= this.combatify$piercingNegation;
                d = Math.max(0.0, d);
                this.combatify$piercingNegation = 0.0;
                if (d > 0.0) {
                    cir.setReturnValue((Object)Float.valueOf(MethodHandler.getNewDamageAfterMagicAbsorb(this.combatify$thisEntity, source, f, d)));
                }
            }
        }
    }

    @Unique
    @SafeVarargs
    public final boolean combatify$isSourceAnyOf(DamageSource source, ResourceKey<DamageType> ... damageTypes) {
        boolean bl = false;
        for (ResourceKey<DamageType> damageType : damageTypes) {
            bl |= source.m_276093_(damageType);
        }
        return bl;
    }

    @ModifyExpressionValue(method={"handleDamageEvent"}, at={@At(value="CONSTANT", args={"intValue=20"}, ordinal=0)})
    private int syncInvulnerability(int x) {
        return 10;
    }

    @WrapOperation(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z")})
    public boolean shield(LivingEntity instance, DamageSource source, Operation<Boolean> original, @Local(ordinal=0) LocalFloatRef amount, @Local(ordinal=1) LocalFloatRef f, @Local(ordinal=2) LocalFloatRef g, @Local(ordinal=0) LocalBooleanRef bl) {
        Item item;
        if (amount.get() > 0.0f && ((Boolean)original.call(new Object[]{instance, source})).booleanValue() && (item = MethodHandler.getBlockingItem(this.combatify$thisEntity).getItem()) instanceof ItemExtensions) {
            ItemExtensions shieldItem = (ItemExtensions)item;
            shieldItem.getBlockingType().block(instance, null, MethodHandler.getBlockingItem(this.combatify$thisEntity).stack(), source, amount, f, g, bl);
        }
        return false;
    }

    @ModifyExpressionValue(method={"hurt"}, at={@At(value="CONSTANT", args={"intValue=20"}, ordinal=0)})
    public int changeIFrames(int original, @Local(ordinal=0, argsOnly=true) DamageSource source, @Local(ordinal=0, argsOnly=true) float amount) {
        Entity entity2 = source.m_7639_();
        int invulnerableTime = original - 10;
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            int base = (int)Math.min(player.m_36333_(), (float)invulnerableTime);
            int n = invulnerableTime = base >= 4 ? base - 2 : base;
            if (player.m_21133_(Attributes.f_22283_) - 1.5 >= 15.0 || ((Boolean)Combatify.CONFIG.instaAttack.get()).booleanValue()) {
                invulnerableTime = 5;
            }
        }
        if (source.m_269533_(DamageTypeTags.f_268524_) && !((Boolean)Combatify.CONFIG.projectilesHaveIFrames.get()).booleanValue()) {
            invulnerableTime = 0;
        }
        if (source.m_276093_(DamageTypes.f_268515_) && !((Boolean)Combatify.CONFIG.magicHasIFrames.get()).booleanValue()) {
            invulnerableTime = 0;
        }
        return invulnerableTime;
    }

    @Inject(method={"hurt"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;invulnerableTime:I", ordinal=0)})
    public void injectEatingInterruption(DamageSource source, float f, CallbackInfoReturnable<Boolean> cir) {
        if (this.combatify$thisEntity.m_6117_() && this.combatify$thisEntity.m_21211_().m_41614_() && !source.m_269533_(DamageTypeTags.f_268745_) && !source.m_269533_(DamageTypeTags.f_268731_) && !source.m_269533_(DamageTypeTags.f_268549_) && !source.m_276093_(DamageTypes.f_268441_) && ((Boolean)Combatify.CONFIG.eatingInterruption.get()).booleanValue()) {
            this.f_20936_ = this.combatify$thisEntity.m_21211_().m_41779_();
            PacketRegistration.MAIN.send(PacketDistributor.ALL.noArg(), (Object)new RemainingUseSyncPacket(this.m_19879_(), this.f_20936_));
        }
    }

    @ModifyExpressionValue(method={"hurt"}, at={@At(value="CONSTANT", args={"floatValue=10.0F"}, ordinal=0)})
    public float changeIFrames(float constant) {
        return constant - 10.0f;
    }

    @WrapOperation(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    public void modifyKB(LivingEntity instance, double d, double e, double f, Operation<Void> original, @Local(ordinal=0, argsOnly=true) DamageSource source) {
        if (((Boolean)Combatify.CONFIG.fishingHookKB.get()).booleanValue() && source.m_7640_() instanceof FishingHook || !source.m_269533_(DamageTypeTags.f_268524_) && ((Boolean)Combatify.CONFIG.midairKB.get()).booleanValue()) {
            MethodHandler.projectileKnockback(this.combatify$thisEntity, 0.4, e, f);
        } else {
            MethodHandler.knockback(this.combatify$thisEntity, 0.4, e, f);
        }
    }

    @Inject(method={"isDamageSourceBlocked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;")}, cancellable=true)
    public void isDamageSourceBlocked(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        Vec3 currentVector = this.m_20252_(1.0f);
        if (currentVector.f_82480_ > -0.99 && currentVector.f_82480_ < 0.99) {
            currentVector = new Vec3(currentVector.f_82479_, 0.0, currentVector.f_82481_).m_82541_();
            Vec3 sourceVector = Objects.requireNonNull(source.m_7270_()).m_82505_(this.m_20182_());
            sourceVector = new Vec3(sourceVector.f_82479_, 0.0, sourceVector.f_82481_).m_82541_();
            cir.setReturnValue((Object)(sourceVector.m_82526_(currentVector) * 3.1415927410125732 < -0.8726646304130554 ? 1 : 0));
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Unique
    public float combatify$getNewDamageAfterArmorAbsorb(DamageSource source, float amount, double piercingLevel) {
        if (!source.m_269533_(DamageTypeTags.f_268490_) && piercingLevel < 1.0) {
            this.m_6472_(source, (float)((double)amount * (1.0 + piercingLevel)));
            double armourStrength = this.m_21230_();
            double toughness = this.m_21133_(Attributes.f_22285_);
            amount = CombatRules.m_19272_((float)amount, (float)((float)(armourStrength - armourStrength * piercingLevel)), (float)((float)(toughness - toughness * piercingLevel)));
        }
        return amount;
    }

    @Override
    public boolean combatify$hasEnabledShieldOnCrouch() {
        return true;
    }

    @Override
    public void setUseItemRemaining(int ticks) {
        this.f_20936_ = ticks;
    }
}

