/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.Objects;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.LivingEntityExtensions;
import net.atlas.combatify.extensions.PlayerExtensions;
import net.atlas.combatify.item.TieredShieldItem;
import net.atlas.combatify.util.CustomEnchantmentHelper;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=1400)
public abstract class PlayerMixin
extends LivingEntity
implements PlayerExtensions,
LivingEntityExtensions {
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_USES_SHIELD_CROUCH = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    protected int attackStrengthMaxValue;
    @Unique
    public boolean missedAttackRecovery;
    @Unique
    @Final
    public float baseValue = 1.0f;
    @Unique
    boolean attacked;
    @Unique
    public final Player player = (Player)this;

    public PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract void m_6727_(@NotNull LivingEntity var1);

    @Shadow
    public abstract float m_36403_(float var1);

    @Shadow
    public abstract float m_36333_();

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    public void appendShieldOnCrouch(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_PLAYER_USES_SHIELD_CROUCH, (Object)true);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    public void injectSnowballKb(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir, @Share(value="originalDamage") LocalFloatRef original) {
        original.set(amount);
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true)
    public void changeReturn(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir, @Share(value="originalDamage") LocalFloatRef original) {
        boolean bl;
        boolean bl2 = bl = amount == 0.0f && original.get() <= 0.0f;
        if (bl) {
            cir.setReturnValue((Object)super.m_6469_(source, amount));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        Objects.requireNonNull(this.player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get())).m_22100_(2.5);
        Objects.requireNonNull(this.player.m_21051_(Attributes.f_22281_)).m_22100_((Boolean)Combatify.CONFIG.fistDamage.get() == false ? 2.0 : 1.0);
        Objects.requireNonNull(this.player.m_21051_(Attributes.f_22283_)).m_22100_((Double)Combatify.CONFIG.baseHandAttackSpeed.get() + 1.5);
    }

    @ModifyExpressionValue(method={"createAttributes"}, at={@At(value="CONSTANT", args={"doubleValue=1.0"})})
    private static double changeAttack(double constant) {
        return (Boolean)Combatify.CONFIG.fistDamage.get() == false ? 1.0 + constant : constant;
    }

    @ModifyReturnValue(method={"createAttributes"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder createAttributes(AttributeSupplier.Builder original) {
        return original.m_22266_((Attribute)ForgeMod.ENTITY_REACH.get()).m_22268_(Attributes.f_22283_, (Double)Combatify.CONFIG.baseHandAttackSpeed.get() + 1.5);
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")})
    public void addServerOnlyCheck(ItemStack itemStack, boolean bl, boolean bl2, CallbackInfoReturnable<ItemEntity> cir) {
        if (Combatify.unmoddedPlayers.contains(this.player.m_20148_())) {
            Combatify.isPlayerAttacking.put(this.player.m_20148_(), false);
        }
    }

    @ModifyExpressionValue(method={"hurtCurrentlyUsedShield"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;canPerformAction(Lnet/minecraftforge/common/ToolAction;)Z")})
    public boolean hurtCurrentlyUsedShield(boolean original) {
        return !((ItemExtensions)this.f_20935_.m_41720_()).getBlockingType().isEmpty() || original;
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isSameItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    public boolean redirectDurability(boolean original) {
        return true;
    }

    @Inject(method={"blockUsingShield"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;canDisableShield(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)Z")}, cancellable=true)
    public void blockUsingShield(@NotNull LivingEntity attacker, CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public boolean ctsShieldDisable(float damage, Item item) {
        this.player.m_36335_().m_41524_(item, (int)(damage * 20.0f));
        if (item instanceof TieredShieldItem) {
            for (TieredShieldItem tieredShieldItem : Combatify.shields) {
                if (item == tieredShieldItem) continue;
                this.player.m_36335_().m_41524_((Item)tieredShieldItem, (int)(damage * 20.0f));
            }
        }
        this.player.m_5810_();
        this.player.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        return true;
    }

    @Override
    public boolean combatify$hasEnabledShieldOnCrouch() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLAYER_USES_SHIELD_CROUCH);
    }

    @Override
    public void combatify$setShieldOnCrouch(boolean hasShieldOnCrouch) {
        this.f_19804_.m_135381_(DATA_PLAYER_USES_SHIELD_CROUCH, (Object)hasShieldOnCrouch);
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void attack(Entity target, CallbackInfo ci) {
        if (!this.combatify$isAttackAvailable(this.baseValue)) {
            ci.cancel();
        }
    }

    @Inject(method={"attack"}, at={@At(value="TAIL")})
    public void resetTicker(Entity target, CallbackInfo ci) {
        if (this.attacked) {
            boolean isMiscTarget = target.m_6095_().equals(EntityType.f_20564_) || target.m_6095_().equals(EntityType.f_20462_) || target.m_6095_().equals(EntityType.f_147033_) || target.m_6095_().equals(EntityType.f_20506_) || target instanceof ArmorStand || target instanceof Boat || target instanceof AbstractMinecart || target instanceof Interaction;
            this.combatify$resetAttackStrengthTicker((Boolean)Combatify.CONFIG.improvedMiscEntityAttacks.get() == false || !isMiscTarget);
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)})
    public void doThings(Entity target, CallbackInfo ci, @Local(ordinal=0) LocalFloatRef attackDamage, @Local(ordinal=1) LocalFloatRef attackDamageBonus) {
        boolean bl;
        this.attacked = true;
        LivingEntity livingEntity = target instanceof LivingEntity ? (LivingEntity)target : null;
        boolean bl2 = bl = livingEntity != null;
        if (this.player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof TridentItem && bl) {
            attackDamageBonus.set(CustomEnchantmentHelper.getDamageBonus(this.player.m_21205_(), livingEntity));
        }
        attackDamage.set((float)MethodHandler.calculateValue(this.player.m_21051_(Attributes.f_22281_), attackDamageBonus.get()));
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)})
    public float redirectStrengthCheck(float original) {
        return 1.0f;
    }

    @Inject(method={"resetAttackStrengthTicker"}, at={@At(value="HEAD")}, cancellable=true)
    public void reset(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"attack"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Player;walkDist:F")})
    public void injectCrit(Entity target, CallbackInfo ci, @Local(ordinal=0) LocalFloatRef attackDamage, @Local(ordinal=1) float attackDamageBonus, @Local(ordinal=2) LocalBooleanRef bl3) {
        boolean isCrit;
        attackDamage.set(attackDamage.get() - attackDamageBonus);
        if (bl3.get()) {
            attackDamage.set(attackDamage.get() / 1.5f);
        }
        boolean bl = isCrit = this.player.f_19789_ > 0.0f && !this.player.m_20096_() && !this.player.m_6147_() && !this.player.m_20069_() && !this.player.m_21023_(MobEffects.f_19610_) && !this.player.m_20159_() && target instanceof LivingEntity;
        if (!((Boolean)Combatify.CONFIG.sprintCritsEnabled.get()).booleanValue()) {
            isCrit &= !this.m_20142_();
        }
        bl3.set(isCrit);
        if (isCrit) {
            attackDamage.set(attackDamage.get() * 1.5f);
        }
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    public void knockback(LivingEntity instance, double d, double e, double f, Operation<Void> original) {
        MethodHandler.knockback(instance, d, e, f);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    public void createSweep(Entity target, CallbackInfo ci, @Local(ordinal=1) boolean bl2, @Local(ordinal=2) boolean bl3, @Local(ordinal=3) LocalBooleanRef bl4, @Local(ordinal=5) boolean bl6, @Local(ordinal=0) float attackDamage, @Local(ordinal=0) double d, @Share(value="wasSweep") LocalBooleanRef wasSweep) {
        if (!bl3 && !bl2 && this.m_20096_() && d < (double)this.m_6113_() && this.checkSweepAttack()) {
            if (bl6) {
                AABB box = target.m_20191_().m_82377_(1.0, 0.25, 1.0);
                MethodHandler.sweepAttack(this.player, box, (float)MethodHandler.getCurrentAttackReach(this.player, 1.0f), attackDamage, target);
            }
            wasSweep.set(true);
        }
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="flag2", local={@Local(type=boolean.class, ordinal=3)})
    @Expression(value={"flag2 != false"})
    public boolean resweep(boolean original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return false;
    }

    @Override
    public void combatify$attackAir() {
        if (this.combatify$isAttackAvailable(this.baseValue)) {
            this.combatify$customSwing(InteractionHand.MAIN_HAND);
            float attackDamage = (float)Objects.requireNonNull(this.player.m_21051_(Attributes.f_22281_)).m_22135_();
            if (attackDamage > 0.0f && this.checkSweepAttack()) {
                float reach = (float)MethodHandler.getCurrentAttackReach(this.player, 1.0f);
                double var5 = (double)(-Mth.m_14031_((float)(this.player.f_20883_ * ((float)Math.PI / 180)))) * 2.0;
                double var7 = (double)Mth.m_14089_((float)(this.player.f_20883_ * ((float)Math.PI / 180))) * 2.0;
                AABB box = this.player.m_20191_().m_82377_(1.0, 0.25, 1.0).m_82386_(var5, 0.0, var7);
                MethodHandler.sweepAttack(this.player, box, reach, attackDamage, null);
            }
            this.combatify$resetAttackStrengthTicker(false);
        }
    }

    @Override
    public void combatify$customSwing(InteractionHand interactionHand) {
        this.m_21011_(interactionHand, false);
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit) {
        this.resetAttackStrengthTicker(hit, false, Player::m_36334_);
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit, boolean force) {
        this.resetAttackStrengthTicker(hit, force, Player::m_36334_);
    }

    @Unique
    public void resetAttackStrengthTicker(boolean hit, boolean force, Consumer<Player> vanillaReset) {
        boolean bl = this.missedAttackRecovery = !hit;
        if ((Boolean)Combatify.CONFIG.attackSpeed.get() == false && this.m_21133_(Attributes.f_22283_) - 1.5 >= 20.0 || ((Boolean)Combatify.CONFIG.instaAttack.get()).booleanValue()) {
            return;
        }
        int chargeTicks = (int)this.m_36333_() * 2;
        if (force || chargeTicks > this.attackStrengthMaxValue - this.f_20922_) {
            Combatify.LOGGER.info("Ticks for charge: " + chargeTicks);
            this.attackStrengthMaxValue = chargeTicks;
            this.f_20922_ = 0;
        }
    }

    @ModifyExpressionValue(method={"getCurrentItemAttackStrengthDelay"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/world/entity/ai/attributes/Attribute;)D")})
    public double modifyAttackSpeed(double original, @Share(value="hasVanilla") LocalBooleanRef hasVanilla) {
        hasVanilla.set((this.m_21051_(Attributes.f_22283_).m_22111_(Item.f_41375_) != null || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) && !Combatify.getState().equals((Object)Combatify.CombatifyState.CTS_8C));
        double mod = 1.5;
        double speed = original - mod;
        if (hasVanilla.get() || speed <= 0.0) {
            speed += mod;
        }
        return Mth.m_14008_((double)speed, (double)0.1, (double)1024.0);
    }

    @ModifyReturnValue(method={"getCurrentItemAttackStrengthDelay"}, at={@At(value="RETURN")})
    public float modifyAttackTicks(float original, @Share(value="hasVanilla") LocalBooleanRef hasVanilla) {
        return hasVanilla.get() ? original : (float)Math.round(original);
    }

    @ModifyExpressionValue(method={"getAttackStrengthScale"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getCurrentItemAttackStrengthDelay()F")})
    public float modifyMaxCharge(float original) {
        return this.attackStrengthMaxValue;
    }

    @ModifyReturnValue(method={"getAttackStrengthScale"}, at={@At(value="RETURN")})
    public float modifyAttackStrengthScale(float original) {
        float charge = 2.0f;
        if (this.attackStrengthMaxValue == 0) {
            return charge;
        }
        return charge * original;
    }

    @Override
    public boolean combatify$isAttackAvailable(float baseTime) {
        if (this.m_36403_(baseTime) < 1.0f) {
            return this.missedAttackRecovery && (float)this.f_20922_ + baseTime > 4.0f;
        }
        return true;
    }

    protected boolean checkSweepAttack() {
        return this.m_36403_(this.baseValue) > 1.95f && EnchantmentHelper.m_44821_((LivingEntity)this.player) > 0.0f;
    }

    @Override
    public boolean combatify$getMissedAttackRecovery() {
        return this.missedAttackRecovery;
    }
}

