/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.extensions.PlayerExtensions;
import net.atlas.combatify.extensions.ServerPlayerExtensions;
import net.atlas.combatify.mixin.PlayerMixin;
import net.atlas.combatify.util.CombatUtil;
import net.atlas.combatify.util.HitResultRotationEntry;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPingPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends PlayerMixin
implements ServerPlayerExtensions {
    private boolean retainAttack;
    @Shadow
    public ServerGamePacketListenerImpl f_8906_;
    public CopyOnWriteArrayList<HitResultRotationEntry> oldHitResults = new CopyOnWriteArrayList();
    public IntList pastPings = new IntArrayList(5);
    public boolean awaitingResponse = false;
    public int responseTimer = 0;
    public int tickTimer = 4;
    public int currentAveragePing = 0;
    @Unique
    public final ServerPlayer player = (ServerPlayer)ServerPlayer.class.cast(this);
    @Unique
    public boolean shouldInit = true;

    @Shadow
    public abstract Entity m_8954_();

    @Shadow
    public abstract void m_6674_(InteractionHand var1);

    public ServerPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void hitreg(CallbackInfo ci) {
        CombatUtil.setPosition((ServerPlayer)this);
        if (this.shouldInit && Combatify.unmoddedPlayers.contains(this.m_20148_())) {
            Combatify.scheduleHitResult.get(this.m_20148_()).schedule(new TimerTask(){

                @Override
                public void run() {
                    Entity camera = ServerPlayerMixin.this.m_8954_();
                    if (camera != null) {
                        ServerPlayerMixin.this.adjustHitResults(MethodHandler.pickResult((Player)ServerPlayerMixin.this.player, camera));
                    }
                }
            }, 0L, 5L);
            this.shouldInit = false;
        }
        ++this.tickTimer;
        if (this.tickTimer >= 5 && Combatify.unmoddedPlayers.contains(this.m_20148_()) && !this.awaitingResponse) {
            this.tickTimer = 0;
            this.f_8906_.m_9829_((Packet)new ClientboundPingPacket(3492));
            this.awaitingResponse = true;
        }
        if (((PlayerExtensions)this.player).combatify$isAttackAvailable(-1.0f) && this.retainAttack && Combatify.unmoddedPlayers.contains(this.m_20148_())) {
            this.retainAttack = false;
            this.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    @Inject(method={"swing"}, at={@At(value="HEAD")}, cancellable=true)
    public void removeReset(InteractionHand hand, CallbackInfo ci) {
        super.m_6674_(hand);
        if (Combatify.unmoddedPlayers.contains(this.m_20148_())) {
            if (Combatify.isPlayerAttacking.get(this.m_20148_()).booleanValue()) {
                this.getPresentResult();
                float xRot = this.m_146909_();
                float yRot = this.m_6080_();
                HitResult hitResult = this.oldHitResults.stream().filter(hitResultRotEntry -> hitResultRotEntry.shouldAccept(xRot, yRot)).min((firstResultRotEntry, secondResultRotEntry) -> firstResultRotEntry.compareTo((HitResultRotationEntry)secondResultRotEntry, xRot, yRot)).map(HitResultRotationEntry::hitResult).orElse(null);
                if (hitResult != null) {
                    Combatify.finalizingAttack.put(this.m_20148_(), false);
                    switch (hitResult.m_6662_()) {
                        case ENTITY: {
                            if (hitResult instanceof EntityHitResult) {
                                Entity entity = ((EntityHitResult)hitResult).m_82443_();
                                this.handleInteract(entity, true);
                            }
                        }
                        case MISS: {
                            this.handleInteract((Entity)this.player, false);
                        }
                    }
                }
            }
            Combatify.finalizingAttack.put(this.m_20148_(), true);
            Combatify.isPlayerAttacking.put(this.m_20148_(), true);
        }
        ci.cancel();
    }

    @Unique
    public void handleInteract(Entity entity, boolean hit) {
        if (this.retainAttack) {
            if (hit) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12315_, this.m_5720_(), 1.0f, 1.0f);
            }
            return;
        }
        if (!this.combatify$isAttackAvailable(0.0f)) {
            float var1 = this.player.m_36403_(0.0f);
            if (var1 < 0.8f) {
                if (hit) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12315_, this.m_5720_(), 1.0f, 1.0f);
                }
                this.combatify$resetAttackStrengthTicker(!this.combatify$getMissedAttackRecovery());
                return;
            }
            if (var1 < 1.0f) {
                this.retainAttack = true;
                return;
            }
        }
        ServerLevel serverLevel = this.player.m_284548_();
        this.player.m_9243_();
        if (entity != null) {
            if (!serverLevel.m_6857_().m_61937_(entity.m_20183_())) {
                return;
            }
            double d = MethodHandler.getCurrentAttackReach((Player)this.player, 1.0f) + 1.0;
            d *= d;
            AABB aABB = entity.m_20191_();
            Vec3 eyePos = this.player.m_20299_(0.0f);
            double dist = eyePos.m_82557_(MethodHandler.getNearestPointTo(aABB, eyePos));
            if (entity instanceof ServerPlayer) {
                ServerPlayer target = (ServerPlayer)entity;
                dist = CombatUtil.allowReach(this.player, target) ? 0.0 : 2.147483647E9;
            }
            if (dist < d) {
                if (hit) {
                    if (!(entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof AbstractArrow || entity == this.player)) {
                        ItemStack itemStack = this.player.m_21120_(InteractionHand.MAIN_HAND);
                        if (itemStack.m_246617_(serverLevel.m_246046_())) {
                            this.player.m_5706_(entity);
                        }
                    } else {
                        this.player.f_8906_.m_9942_((Component)Component.m_237115_((String)"multiplayer.disconnect.invalid_entity_attacked"));
                        Combatify.LOGGER.warn("Player " + this.player.m_7755_().getString() + " tried to attack an invalid entity");
                    }
                } else {
                    this.combatify$attackAir();
                }
            }
        }
    }

    @Override
    public void adjustHitResults(HitResult newValue) {
        if (this.awaitingResponse) {
            ++this.responseTimer;
        }
        if (!this.awaitingResponse && this.responseTimer > 0) {
            int newPing = Mth.m_14165_((double)((double)this.responseTimer * 0.5));
            this.pastPings.add(0, newPing);
            int removed = this.pastPings.removeInt(this.pastPings.size() - 1);
            this.responseTimer = 0;
            this.currentAveragePing = this.currentAveragePing - removed / 5 + newPing / 5;
        }
        HitResultRotationEntry newEntry = new HitResultRotationEntry(newValue, this.m_146909_(), this.m_6080_());
        if (this.oldHitResults.size() > 1) {
            this.oldHitResults.add(1, newEntry);
        } else {
            this.oldHitResults.add(newEntry);
        }
        int currentPing = Mth.m_14045_((int)(this.currentAveragePing + 1), (int)25, (int)200) / 5;
        this.oldHitResults.removeIf(hitResult -> this.oldHitResults.indexOf(hitResult) >= currentPing);
    }

    @Override
    public void setAwaitingResponse(boolean awaitingResponse) {
        this.awaitingResponse = awaitingResponse;
    }

    @Override
    public boolean isAwaitingResponse() {
        return this.awaitingResponse;
    }

    @Override
    public CopyOnWriteArrayList<HitResultRotationEntry> getOldHitResults() {
        return this.oldHitResults;
    }

    @Override
    public boolean isRetainingAttack() {
        return this.retainAttack;
    }

    @Override
    public void setRetainAttack(boolean retain) {
        this.retainAttack = retain;
    }

    @Override
    public void getPresentResult() {
        Entity camera = this.m_8954_();
        if (camera != null) {
            this.oldHitResults.set(0, new HitResultRotationEntry(MethodHandler.pickResult((Player)this.player, camera), this.m_146909_(), this.m_6080_()));
        }
    }
}

