/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.ConfigurableWeaponData;
import net.atlas.combatify.extensions.DefaultedItemExtensions;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.WeaponWithType;
import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.util.BlockingType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SwordItem.class})
public class SwordItemMixin
extends TieredItem
implements ItemExtensions,
DefaultedItemExtensions,
WeaponWithType {
    @Shadow
    private Multimap<Attribute, AttributeModifier> f_43267_;

    public SwordItemMixin(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public void modifyAttributeModifiers() {
        ImmutableMultimap.Builder var3 = ImmutableMultimap.builder();
        this.getWeaponType().addCombatAttributes(this.m_43314_(), (ImmutableMultimap.Builder<Attribute, AttributeModifier>)var3);
        ImmutableMultimap output = var3.build();
        this.setDefaultModifiers((ImmutableMultimap<Attribute, AttributeModifier>)output);
    }

    @Inject(method={"getDamage"}, at={@At(value="RETURN")}, cancellable=true)
    public void getDamage(CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf((float)this.getWeaponType().getDamage(this.m_43314_())));
    }

    @Override
    public void setStackSize(int stackSize) {
        this.f_41370_ = stackSize;
    }

    @Override
    public BlockingType getBlockingType() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.blockingType != null) {
                return configurableItemData.blockingType;
            }
        }
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this.getWeaponType())) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this.getWeaponType());
            if (configurableWeaponData.blockingType != null) {
                return configurableWeaponData.blockingType;
            }
        }
        return Combatify.registeredTypes.get("sword");
    }

    @Override
    public void setDefaultModifiers(ImmutableMultimap<Attribute, AttributeModifier> modifiers) {
        this.f_43267_ = modifiers;
    }

    @Override
    public WeaponType getWeaponType() {
        WeaponType type;
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this) && (type = Combatify.ITEMS.configuredItems.get((Object)this).type) != null) {
            return type;
        }
        return WeaponType.SWORD;
    }

    @Override
    public double getChargedAttackBonus() {
        SwordItemMixin item = this;
        double chargedBonus = this.getWeaponType().getChargedReach();
        if (Combatify.ITEMS.configuredItems.containsKey(item)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
            if (configurableItemData.chargedReach != null) {
                chargedBonus = configurableItemData.chargedReach;
            }
        }
        return chargedBonus;
    }

    @Override
    public double getPiercingLevel() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.piercingLevel != null) {
                return configurableItemData.piercingLevel;
            }
        }
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this.getWeaponType())) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this.getWeaponType());
            if (configurableWeaponData.piercingLevel != null) {
                return configurableWeaponData.piercingLevel;
            }
        }
        return 0.0;
    }
}

