/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.ConfigurableWeaponData;
import net.atlas.combatify.extensions.DefaultedItemExtensions;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.WeaponWithType;
import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.util.BlockingType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.Vanishable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={TridentItem.class})
public class TridentItemMixin
extends Item
implements Vanishable,
ItemExtensions,
DefaultedItemExtensions,
WeaponWithType {
    @Mutable
    @Shadow
    @Final
    private Multimap<Attribute, AttributeModifier> f_43379_;

    public TridentItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void modifyAttributeModifiers() {
        ImmutableMultimap.Builder var3 = ImmutableMultimap.builder();
        this.getWeaponType().addCombatAttributes((Tier)Tiers.NETHERITE, (ImmutableMultimap.Builder<Attribute, AttributeModifier>)var3);
        ImmutableMultimap output = var3.build();
        this.setDefaultModifiers((ImmutableMultimap<Attribute, AttributeModifier>)output);
    }

    @Override
    public void setStackSize(int stackSize) {
        this.f_41370_ = stackSize;
    }

    @Override
    public void setDefaultModifiers(ImmutableMultimap<Attribute, AttributeModifier> modifiers) {
        this.f_43379_ = modifiers;
    }

    @Override
    public WeaponType getWeaponType() {
        WeaponType type;
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this) && (type = Combatify.ITEMS.configuredItems.get((Object)this).type) != null) {
            return type;
        }
        return WeaponType.TRIDENT;
    }

    @Override
    public double getChargedAttackBonus() {
        TridentItemMixin item = this;
        double chargedBonus = this.getWeaponType().getChargedReach();
        if (Combatify.ITEMS.configuredItems.containsKey(item)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
            if (configurableItemData.chargedReach != null) {
                chargedBonus = configurableItemData.chargedReach;
            }
        }
        return chargedBonus;
    }

    @Override
    public BlockingType getBlockingType() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.blockingType != null) {
                return configurableItemData.blockingType;
            }
        }
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this.getWeaponType())) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this.getWeaponType());
            if (configurableWeaponData.blockingType != null) {
                return configurableWeaponData.blockingType;
            }
        }
        return Combatify.EMPTY;
    }

    @Override
    public double getPiercingLevel() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(this)) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(this);
            if (configurableItemData.piercingLevel != null) {
                return configurableItemData.piercingLevel;
            }
        }
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this.getWeaponType())) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this.getWeaponType());
            if (configurableWeaponData.piercingLevel != null) {
                return configurableWeaponData.piercingLevel;
            }
        }
        return 0.0;
    }
}

