/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.networking;

import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.function.Supplier;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.AtlasConfig;
import net.atlas.combatify.config.ConfigSynchronizer;
import net.atlas.combatify.networking.AtlasConfigPacket;
import net.atlas.combatify.networking.PacketRegistration;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class C2SConfigPacket {
    public FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());

    public static C2SConfigPacket decode(FriendlyByteBuf buf) {
        C2SConfigPacket packet = new C2SConfigPacket();
        packet.buf = buf;
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        ConfigSynchronizer.write(buf, 1);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ConfigSynchronizer.applyServer(Objects.requireNonNull(ctx.get().getSender()), this.buf);
        for (AtlasConfig atlasConfig : AtlasConfig.configs.values()) {
            PacketRegistration.MAIN.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)ctx.get()).getSender()), (Object)new AtlasConfigPacket(atlasConfig));
        }
        Combatify.LOGGER.info("Config packet sent to client.");
    }
}

