/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util;

import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.Objects;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.enchantment.DefendingEnchantment;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockingType {
    private final String name;
    private boolean canBeDisabled = true;
    private boolean canCrouchBlock = true;
    private boolean isToolBlocker = false;
    private boolean canBlockHit = false;
    private boolean requiresSwordBlocking = false;
    private boolean requireFullCharge = true;
    private boolean defaultKbMechanics = true;

    public int getDefenderBonus(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DefendingEnchantment.DEFENDER.get()), (ItemStack)stack);
    }

    public Float getShieldBlockBaseConfig(ItemStack stack) {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(stack.m_41720_())) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(stack.m_41720_());
            if (configurableItemData.blockBase != null) {
                int extra = 0;
                if (((Boolean)Combatify.CONFIG.defender.get()).booleanValue()) {
                    extra += this.getDefenderBonus(stack);
                }
                return Float.valueOf(configurableItemData.blockBase.floatValue() + (float)extra);
            }
        }
        return null;
    }

    public Float getShieldBlockFactorConfig(ItemStack stack) {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(stack.m_41720_())) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(stack.m_41720_());
            if (configurableItemData.blockFactor != null) {
                return Float.valueOf(configurableItemData.blockFactor.floatValue() / 100.0f);
            }
        }
        return null;
    }

    public boolean canCrouchBlock() {
        return this.canCrouchBlock;
    }

    public BlockingType setCrouchable(boolean crouchable) {
        this.canCrouchBlock = crouchable;
        return this;
    }

    public boolean canBlockHit() {
        return this.canBlockHit;
    }

    public BlockingType setBlockHit(boolean blockHit) {
        this.canBlockHit = blockHit;
        return this;
    }

    public boolean isToolBlocker() {
        return this.isToolBlocker;
    }

    public BlockingType setToolBlocker(boolean isTool) {
        this.isToolBlocker = isTool;
        return this;
    }

    public boolean canBeDisabled() {
        return this.canBeDisabled;
    }

    public BlockingType setDisablement(boolean canDisable) {
        this.canBeDisabled = canDisable;
        return this;
    }

    public boolean requireFullCharge() {
        return this.requireFullCharge;
    }

    public BlockingType setRequireFullCharge(boolean needsFullCharge) {
        this.requireFullCharge = needsFullCharge;
        return this;
    }

    public boolean defaultKbMechanics() {
        return this.defaultKbMechanics;
    }

    public BlockingType setKbMechanics(boolean defaultKbMechanics) {
        this.defaultKbMechanics = defaultKbMechanics;
        return this;
    }

    public boolean requiresSwordBlocking() {
        return this.requiresSwordBlocking;
    }

    public BlockingType setSwordBlocking(boolean requiresSwordBlocking) {
        this.requiresSwordBlocking = requiresSwordBlocking;
        return this;
    }

    public BlockingType(String name) {
        this.name = name;
    }

    public boolean isEmpty() {
        return this == Combatify.EMPTY;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockingType)) {
            return false;
        }
        BlockingType that = (BlockingType)o;
        return this.canBeDisabled == that.canBeDisabled && this.canCrouchBlock == that.canCrouchBlock && this.isToolBlocker() == that.isToolBlocker() && this.canBlockHit == that.canBlockHit && this.requiresSwordBlocking == that.requiresSwordBlocking && this.requireFullCharge == that.requireFullCharge && this.defaultKbMechanics == that.defaultKbMechanics && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.canBeDisabled, this.canCrouchBlock, this.isToolBlocker(), this.canBlockHit, this.requiresSwordBlocking, this.requireFullCharge, this.defaultKbMechanics);
    }

    public abstract void block(LivingEntity var1, @Nullable Entity var2, ItemStack var3, DamageSource var4, LocalFloatRef var5, LocalFloatRef var6, LocalFloatRef var7, LocalBooleanRef var8);

    public abstract float getShieldBlockBase(ItemStack var1);

    public abstract float getShieldBlockFactor(ItemStack var1);

    public abstract double getShieldKnockbackResistanceValue(ItemStack var1);

    @NotNull
    public abstract InteractionResultHolder<ItemStack> use(Level var1, Player var2, InteractionHand var3);

    public abstract boolean canUse(Level var1, Player var2, InteractionHand var3);

    public void appendTooltips(ItemStack itemStack, Consumer<Component> appender) {
        float base = this.getShieldBlockBase(itemStack);
        float factor = this.getShieldBlockFactor(itemStack);
        double knockback = this.getShieldKnockbackResistanceValue(itemStack);
        if ((double)base > 0.0) {
            appender.accept((Component)Component.m_237113_((String)"").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + AttributeModifier.Operation.ADDITION.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(base), this.getProtectionComponent()})).m_130940_(ChatFormatting.DARK_GREEN));
        }
        if ((double)factor > 0.0) {
            appender.accept((Component)Component.m_237113_((String)"").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + AttributeModifier.Operation.MULTIPLY_TOTAL.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format((double)factor * 100.0), this.getReductionComponent()})).m_130940_(ChatFormatting.DARK_GREEN));
        }
        if (knockback > 0.0) {
            appender.accept((Component)Component.m_237113_((String)"").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + AttributeModifier.Operation.ADDITION.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(knockback * 10.0), Component.m_237115_((String)"attribute.name.generic.knockback_resistance")})).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    public Component getProtectionComponent() {
        return Component.m_237115_((String)"attribute.name.generic.shield_strength");
    }

    public Component getReductionComponent() {
        return Component.m_237115_((String)"attribute.name.generic.shield_reduction");
    }
}

