/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util;

import net.atlas.combatify.Combatify;
import net.atlas.combatify.util.MethodHandler;
import net.atlas.combatify.util.PlayerData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CombatUtil {
    public static int savedLocationTicks = 9;

    public static boolean allowReach(ServerPlayer attacker, ServerPlayer target) {
        Vec3 eyePosition = attacker.m_20299_(0.0f);
        double reach = MethodHandler.getCurrentAttackReach((Player)attacker, 1.0f);
        if (!Combatify.unmoddedPlayers.contains(attacker.m_20148_())) {
            reach += 0.25;
        }
        if (!attacker.m_142582_((Entity)target)) {
            reach = 2.5;
        }
        reach *= reach;
        if (CombatUtil.canReach(eyePosition, target.m_20191_(), reach)) {
            return true;
        }
        PlayerData victimData = PlayerData.get(target);
        for (AABB boundingBox : victimData.previousPositions) {
            if (boundingBox == null || !CombatUtil.canReach(eyePosition, boundingBox, reach)) continue;
            return true;
        }
        return false;
    }

    private static boolean canReach(Vec3 eyePosition, AABB boundingBox, double reach) {
        return eyePosition.m_82557_(MethodHandler.getNearestPointTo(boundingBox, eyePosition)) < reach;
    }

    public static void setPosition(ServerPlayer player) {
        PlayerData playerData = PlayerData.get(player);
        ++playerData.positionIndex;
        if (playerData.positionIndex >= playerData.previousPositions.length) {
            playerData.positionIndex = 0;
        }
        playerData.previousPositions[playerData.positionIndex] = player.m_20191_();
    }
}

