/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util;

import java.util.List;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.LivingEntityExtensions;
import net.atlas.combatify.item.TieredShieldItem;
import net.atlas.combatify.util.BlockingType;
import net.atlas.combatify.util.FakeUseItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import org.jetbrains.annotations.Nullable;

public class MethodHandler {
    public static Vec3 getNearestPointTo(AABB box, Vec3 vec3) {
        double x = Mth.m_14008_((double)vec3.f_82479_, (double)box.f_82288_, (double)box.f_82291_);
        double y = Mth.m_14008_((double)vec3.f_82480_, (double)box.f_82289_, (double)box.f_82292_);
        double z = Mth.m_14008_((double)vec3.f_82481_, (double)box.f_82290_, (double)box.f_82293_);
        return new Vec3(x, y, z);
    }

    public static double calculateValue(@Nullable AttributeInstance attributeInstance, float damageBonus) {
        if (attributeInstance == null) {
            return damageBonus;
        }
        double attributeInstanceBaseValue = attributeInstance.m_22115_();
        for (AttributeModifier attributeModifier : attributeInstance.m_22116_(AttributeModifier.Operation.ADDITION)) {
            attributeInstanceBaseValue += attributeModifier.m_22218_();
        }
        double withDamageBonus = attributeInstanceBaseValue + (double)damageBonus;
        for (AttributeModifier attributeModifier2 : attributeInstance.m_22116_(AttributeModifier.Operation.MULTIPLY_BASE)) {
            withDamageBonus += attributeInstanceBaseValue * attributeModifier2.m_22218_();
        }
        for (AttributeModifier attributeModifier2 : attributeInstance.m_22116_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            withDamageBonus *= 1.0 + attributeModifier2.m_22218_();
        }
        return attributeInstance.m_22099_().m_6740_(withDamageBonus);
    }

    public static void sweepAttack(Player player, AABB box, float reach, float damage, Entity entity) {
        float sweepingDamageRatio = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)player) * damage;
        List livingEntities = player.m_9236_().m_45976_(LivingEntity.class, box);
        DamageSource damageSource = player.m_269291_().m_269075_(player);
        for (LivingEntity livingEntity : livingEntities) {
            ArmorStand armorStand;
            if (livingEntity == player || livingEntity == entity || player.m_7307_((Entity)livingEntity) || livingEntity instanceof ArmorStand && (armorStand = (ArmorStand)livingEntity).m_31677_()) continue;
            float correctReach = reach + livingEntity.m_20205_() * 0.5f;
            livingEntity.m_6469_(damageSource, sweepingDamageRatio);
            if (!(player.m_20280_((Entity)livingEntity) < (double)(correctReach * correctReach))) continue;
            MethodHandler.knockback(livingEntity, 0.4, Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180))));
        }
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
        player.m_36346_();
    }

    public static void tryDisableShield(LivingEntity attacker, LivingEntity target) {
        double x = target.m_20185_() - attacker.m_20185_();
        double z = target.m_20189_() - attacker.m_20189_();
        double x2 = attacker.m_20185_() - target.m_20185_();
        double z2 = attacker.m_20189_() - target.m_20189_();
        ItemStack blockingStack = MethodHandler.getBlockingItem(target).stack();
        Item blockingItem = blockingStack.m_41720_();
        double piercingLevel = 0.0;
        Item item = attacker.m_21205_().m_41720_();
        piercingLevel += ((ItemExtensions)item).getPiercingLevel();
        if (((Boolean)Combatify.CONFIG.piercer.get()).booleanValue()) {
            piercingLevel += (double)CustomEnchantmentHelper.getPierce(attacker) * 0.1;
        }
        boolean bl = attacker.m_21205_().canDisableShield(blockingStack, target, attacker) || piercingLevel > 0.0;
        ItemExtensions shieldItem = (ItemExtensions)blockingItem;
        if (bl && shieldItem.getBlockingType().canBeDisabled()) {
            if (piercingLevel > 0.0) {
                ((LivingEntityExtensions)target).setPiercingNegation(piercingLevel);
            }
            float damage = ((Double)Combatify.CONFIG.shieldDisableTime.get()).floatValue() + (float)CustomEnchantmentHelper.getChopping(attacker) * ((Double)Combatify.CONFIG.cleavingDisableTime.get()).floatValue();
            if (((Boolean)Combatify.CONFIG.defender.get()).booleanValue()) {
                damage -= (float)((double)CustomEnchantmentHelper.getDefense(target) * (Double)Combatify.CONFIG.defenderDisableReduction.get());
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                MethodHandler.disableShield(player, damage, blockingItem);
            }
        }
        if (shieldItem.getBlockingType().isToolBlocker()) {
            return;
        }
        MethodHandler.knockback(target, 0.5, x2, z2);
        MethodHandler.knockback(attacker, 0.5, x, z);
    }

    public static void disableShield(Player player, float damage, Item item) {
        player.m_36335_().m_41524_(item, (int)(damage * 20.0f));
        if (item instanceof TieredShieldItem) {
            for (TieredShieldItem tieredShieldItem : Combatify.shields) {
                if (item == tieredShieldItem) continue;
                player.m_36335_().m_41524_((Item)tieredShieldItem, (int)(damage * 20.0f));
            }
        }
        player.m_5810_();
        player.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
    }

    public static float getFatigueForTime(int f) {
        if (f < 60) {
            return 0.5f;
        }
        return f >= 200 ? 10.5f : 0.5f + 10.0f * (float)(f - 60) / 140.0f;
    }

    public static void knockback(LivingEntity entity, double strength, double x, double z) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)entity, (float)((float)strength), (double)x, (double)z);
        if (!event.isCanceled()) {
            strength = event.getStrength();
            x = event.getRatioX();
            z = event.getRatioZ();
            double knockbackRes = entity.m_21133_(Attributes.f_22278_);
            ItemStack blockingItem = MethodHandler.getBlockingItem(entity).stack();
            if (!blockingItem.m_41619_()) {
                BlockingType blockingType = ((ItemExtensions)blockingItem.m_41720_()).getBlockingType();
                knockbackRes = !blockingType.defaultKbMechanics() ? Math.max(knockbackRes, blockingType.getShieldKnockbackResistanceValue(blockingItem)) : Math.min(1.0, knockbackRes + blockingType.getShieldKnockbackResistanceValue(blockingItem));
            }
            if (!((strength *= 1.0 - knockbackRes) <= 0.0)) {
                entity.f_19812_ = true;
                Vec3 delta = entity.m_20184_();
                Vec3 diff = new Vec3(x, 0.0, z).m_82541_().m_82490_(strength);
                entity.m_20334_(delta.f_82479_ / 2.0 - diff.f_82479_, entity.m_20096_() ? Math.min(0.4, strength * 0.75) : Math.min(0.4, delta.f_82480_ + strength * 0.5), delta.f_82481_ / 2.0 - diff.f_82481_);
            }
        }
    }

    public static void projectileKnockback(LivingEntity entity, double strength, double x, double z) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)entity, (float)((float)strength), (double)x, (double)z);
        if (!event.isCanceled()) {
            strength = event.getStrength();
            x = event.getRatioX();
            z = event.getRatioZ();
            double knockbackRes = entity.m_21133_(Attributes.f_22278_);
            ItemStack blockingItem = MethodHandler.getBlockingItem(entity).stack();
            if (!blockingItem.m_41619_()) {
                BlockingType blockingType = ((ItemExtensions)blockingItem.m_41720_()).getBlockingType();
                knockbackRes = !blockingType.defaultKbMechanics() ? Math.max(knockbackRes, blockingType.getShieldKnockbackResistanceValue(blockingItem)) : Math.min(1.0, knockbackRes + blockingType.getShieldKnockbackResistanceValue(blockingItem));
            }
            if (!((strength *= 1.0 - knockbackRes) <= 0.0)) {
                entity.f_19812_ = true;
                Vec3 delta = entity.m_20184_();
                Vec3 diff = new Vec3(x, 0.0, z).m_82541_().m_82490_(strength);
                entity.m_20334_(delta.f_82479_ / 2.0 - diff.f_82479_, Math.min(0.4, strength * 0.75), delta.f_82481_ / 2.0 - diff.f_82481_);
            }
        }
    }

    public static HitResult pickCollisions(Entity entity, double reach) {
        Vec3 viewVector = entity.m_20252_(1.0f);
        Vec3 pos = entity.m_20299_(1.0f);
        Vec3 endPos = pos.m_82549_(viewVector.m_82490_(reach));
        return entity.m_9236_().m_45547_(new ClipContext(pos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
    }

    public static EntityHitResult rayTraceEntity(Entity entity, float partialTicks, double blockReachDistance) {
        Vec3 from = entity.m_20299_(partialTicks);
        Vec3 look = entity.m_20252_(partialTicks);
        Vec3 to = from.m_82520_(look.f_82479_ * blockReachDistance, look.f_82480_ * blockReachDistance, look.f_82481_ * blockReachDistance);
        return ProjectileUtil.m_37304_((Level)entity.m_9236_(), (Entity)entity, (Vec3)from, (Vec3)to, (AABB)new AABB(from, to), EntitySelector.f_20406_.and(e -> e != null && e.m_6087_() && e instanceof LivingEntity));
    }

    public static HitResult redirectResult(Player player, HitResult instance) {
        if (instance.m_6662_() == HitResult.Type.BLOCK) {
            Entity entity;
            double reach = MethodHandler.getCurrentAttackReachWithoutChargedReach(player) + (!player.m_6047_() ? MethodHandler.getChargedReach(player.m_21120_(InteractionHand.MAIN_HAND)) + 0.25 : 0.25);
            EntityHitResult rayTraceResult = MethodHandler.rayTraceEntity((Entity)player, 1.0f, reach);
            Entity entity2 = entity = rayTraceResult != null ? rayTraceResult.m_82443_() : null;
            if (entity != null) {
                double dist = player.m_146892_().m_82557_(MethodHandler.getNearestPointTo(entity.m_20191_(), player.m_146892_()));
                if (dist > (reach *= reach)) {
                    return instance;
                }
                double distanceTo = player.m_20270_(rayTraceResult.m_82443_());
                HitResult newResult = MethodHandler.pickCollisions((Entity)player, distanceTo);
                if (newResult.m_6662_() != HitResult.Type.MISS) {
                    return instance;
                }
                return rayTraceResult;
            }
            return instance;
        }
        return instance;
    }

    /*
     * Unable to fully structure code
     */
    public static FakeUseItem getBlockingItem(LivingEntity entity) {
        block5: {
            block4: {
                if (!entity.m_6117_() || entity.m_21211_().m_41619_()) break block4;
                if (entity.m_21211_().m_41780_() == UseAnim.BLOCK) {
                    return new FakeUseItem(entity.m_21211_(), entity.m_7655_(), true);
                }
                break block5;
            }
            if ((!entity.m_20096_() || !entity.m_6047_()) && !entity.m_20159_() || !((LivingEntityExtensions)entity).combatify$hasEnabledShieldOnCrouch() || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) break block5;
            for (InteractionHand hand : InteractionHand.values()) {
                stack = entity.m_21120_(hand);
                v0 = stillRequiresCharge = (Boolean)Combatify.CONFIG.shieldOnlyWhenCharged.get() != false && entity instanceof Player != false && (player = (Player)entity).m_36403_(1.0f) < (float)((Integer)Combatify.CONFIG.shieldChargePercentage.get()).intValue() / 100.0f && ((ItemExtensions)stack.m_41720_()).getBlockingType().requireFullCharge() != false;
                if (!(entity instanceof Player)) ** GOTO lbl-1000
                player = (Player)entity;
                if (((ItemExtensions)stack.m_41720_()).getBlockingType().canUse(player.m_9236_(), player, hand)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = canUse = false;
                }
                if (!canUse || stillRequiresCharge || stack.m_41619_() || stack.m_41780_() != UseAnim.BLOCK || MethodHandler.isItemOnCooldown(entity, stack) || !((ItemExtensions)stack.m_41720_()).getBlockingType().canCrouchBlock()) continue;
                return new FakeUseItem(stack, hand, false);
            }
        }
        return new FakeUseItem(ItemStack.f_41583_, null, true);
    }

    public static boolean isItemOnCooldown(LivingEntity entity, ItemStack var1) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).m_36335_().m_41519_(var1.m_41720_());
    }

    public static double getChargedReach(ItemStack itemInHand) {
        return ((ItemExtensions)itemInHand.m_41720_()).getChargedAttackBonus();
    }

    public static double getCurrentAttackReach(Player player, float baseTime) {
        double chargedBonus = 0.0;
        float strengthScale = player.m_36403_(baseTime);
        if (strengthScale > 1.95f && !player.m_6047_()) {
            chargedBonus = MethodHandler.getChargedReach(player.m_21120_(InteractionHand.MAIN_HAND));
        }
        return MethodHandler.getCurrentAttackReachWithoutChargedReach(player) + chargedBonus;
    }

    public static double getCurrentAttackReachWithoutChargedReach(Player player) {
        AttributeInstance attackRange = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
        double baseAttackRange = (Boolean)Combatify.CONFIG.attackReach.get() != false ? 2.5 : 3.0;
        return attackRange != null ? attackRange.m_22135_() : baseAttackRange;
    }

    public static double getSquaredCurrentAttackReach(Player player, float baseTime) {
        double attackRange = MethodHandler.getCurrentAttackReach(player, baseTime);
        return attackRange * attackRange;
    }

    public static HitResult pickResult(Player player, Entity camera) {
        AABB aABB;
        Vec3 vec32;
        EntityHitResult entityHitResult;
        double d = MethodHandler.getCurrentAttackReach(player, 0.0f) + 2.0;
        HitResult hitResult = camera.m_19907_(d, 1.0f, false);
        Vec3 eyePosition = camera.m_20299_(1.0f);
        Vec3 viewVector = camera.m_20252_(1.0f);
        boolean bl = false;
        double e = d;
        if (d > MethodHandler.getCurrentAttackReach(player, 0.0f)) {
            bl = true;
        }
        e *= e;
        if (hitResult != null) {
            e = hitResult.m_82450_().m_82557_(eyePosition);
        }
        if ((entityHitResult = ProjectileUtil.m_37287_((Entity)camera, (Vec3)eyePosition, (Vec3)(vec32 = eyePosition.m_82520_(viewVector.f_82479_ * d, viewVector.f_82480_ * d, viewVector.f_82481_ * d)), (AABB)(aABB = camera.m_20191_().m_82369_(viewVector.m_82490_(d)).m_82377_(1.0, 1.0, 1.0)), entityx -> !entityx.m_5833_() && entityx.m_6087_(), (double)e)) != null) {
            Vec3 vec33 = entityHitResult.m_82450_();
            double h = eyePosition.m_82557_(vec33);
            if (bl && h > MethodHandler.getSquaredCurrentAttackReach(player, 0.0f)) {
                hitResult = BlockHitResult.m_82426_((Vec3)vec33, (Direction)Direction.m_122366_((double)viewVector.f_82479_, (double)viewVector.f_82480_, (double)viewVector.f_82481_), (BlockPos)BlockPos.m_274446_((Position)vec33));
            } else if (h < e || hitResult == null) {
                hitResult = entityHitResult;
            }
        }
        hitResult = MethodHandler.redirectResult(player, hitResult);
        return hitResult;
    }

    public static void voidReturnLogic(ThrownTrident trident, EntityDataAccessor<Byte> ID_LOYALTY) {
        byte j = (Byte)trident.m_20088_().m_135370_(ID_LOYALTY);
        if (trident.m_20186_() <= -65.0 && j > 0) {
            if (!trident.m_37594_()) {
                trident.m_146870_();
            } else {
                trident.m_36790_(true);
                Vec3 vec3 = trident.m_146892_().m_82546_(trident.m_20182_());
                trident.m_20343_(trident.m_20185_(), trident.m_20186_() + vec3.f_82480_ * 0.015 * (double)j, trident.m_20189_());
                if (trident.m_9236_().f_46443_) {
                    trident.f_19791_ = trident.m_20186_();
                }
                double d = 0.05 * (double)j;
                trident.m_20256_(trident.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d)));
                if (trident.f_37557_ == 0) {
                    trident.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++trident.f_37557_;
            }
        }
    }

    public static float getNewDamageAfterMagicAbsorb(LivingEntity entity, DamageSource source, float amount, double piercingLevel) {
        if (!source.m_269533_(DamageTypeTags.f_268437_) && piercingLevel < 1.0) {
            int i;
            int j;
            float f;
            float g;
            float h;
            if (entity.m_21023_(MobEffects.f_19606_) && !source.m_276093_(DamageTypes.f_268724_) && (h = (g = amount) - (amount = Math.max((f = (float)((double)(amount * (float)(j = 5 - (i = entity.m_21124_(MobEffects.f_19606_).m_19564_() + 1))) * (1.0 + piercingLevel))) / 5.0f, (float)((double)amount * piercingLevel)))) > 0.0f && h < 3.4028235E37f) {
                Entity entity2;
                ServerPlayer serverPlayer;
                if (entity instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)entity;
                    serverPlayer.m_36222_(Stats.f_12934_, Math.round(h * 10.0f));
                }
                if ((entity2 = source.m_7639_()) instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)entity2;
                    serverPlayer.m_36222_(Stats.f_12930_, Math.round(h * 10.0f));
                }
            }
            if (amount <= 0.0f) {
                return 0.0f;
            }
            if (!source.m_269533_(DamageTypeTags.f_268413_) && (i = EnchantmentHelper.m_44856_((Iterable)entity.m_6168_(), (DamageSource)source)) > 0) {
                amount = CombatRules.m_19269_((float)amount, (float)((long)i - Math.round((double)i * piercingLevel)));
            }
        }
        return amount;
    }
}

