/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util;

import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.extensions.Tierable;
import net.atlas.combatify.util.BlockingType;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewShieldBlockingType
extends BlockingType {
    public NewShieldBlockingType(String name) {
        super(name);
    }

    @Override
    public void block(LivingEntity instance, @Nullable Entity entity, ItemStack blockingItem, DamageSource source, LocalFloatRef amount, LocalFloatRef f, LocalFloatRef g, LocalBooleanRef bl) {
        Player player;
        if (instance instanceof Player && (player = (Player)instance).m_36335_().m_41519_(blockingItem.m_41720_())) {
            return;
        }
        boolean hurt = false;
        float factor = this.getShieldBlockFactor(blockingItem);
        float base = this.getShieldBlockBase(blockingItem);
        g.set(Math.min(base + amount.get() * factor, amount.get()));
        if (source.m_269533_(DamageTypeTags.f_268415_) || source.m_269533_(DamageTypeTags.f_268524_)) {
            g.set(amount.get());
        } else {
            entity = source.m_7640_();
            if (entity instanceof LivingEntity) {
                instance.m_7909_(g.get());
                hurt = true;
                instance.m_6728_((LivingEntity)entity);
            }
        }
        if (!hurt) {
            instance.m_7909_(g.get());
        }
        amount.set(amount.get() - g.get());
        bl.set(true);
    }

    @Override
    public float getShieldBlockBase(ItemStack stack) {
        int strengthIncrease;
        Tiers tiers;
        Float configBase = this.getShieldBlockBaseConfig(stack);
        if (configBase != null) {
            return configBase.floatValue();
        }
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            tiers = tieredItem.m_43314_();
        } else {
            tiers = Tiers.WOOD;
        }
        Tiers var2 = tiers;
        item = stack.m_41720_();
        if (item instanceof Tierable) {
            Tierable tierable = (Tierable)item;
            var2 = tierable.getTier();
        }
        int n = strengthIncrease = var2.m_6604_() >= 4 ? 1 : 0;
        if (((Boolean)Combatify.CONFIG.defender.get()).booleanValue()) {
            strengthIncrease += this.getDefenderBonus(stack);
        }
        return strengthIncrease;
    }

    @Override
    public float getShieldBlockFactor(ItemStack stack) {
        Tiers tiers;
        Float configFactor = this.getShieldBlockFactorConfig(stack);
        if (configFactor != null) {
            return configFactor.floatValue();
        }
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            tiers = tieredItem.m_43314_();
        } else {
            tiers = Tiers.WOOD;
        }
        Tiers var2 = tiers;
        item = stack.m_41720_();
        if (item instanceof Tierable) {
            Tierable tierable = (Tierable)item;
            var2 = tierable.getTier();
        }
        float strengthIncrease = var2.m_6631_() / 2.0f - 2.0f;
        strengthIncrease = Mth.m_14167_((float)strengthIncrease);
        return Math.min(0.5f + strengthIncrease * 0.1f, 1.0f);
    }

    @Override
    public double getShieldKnockbackResistanceValue(ItemStack stack) {
        Tiers tiers;
        Item item;
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(stack.m_41720_())) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(stack.m_41720_());
            if (configurableItemData.blockKbRes != null) {
                return configurableItemData.blockKbRes;
            }
        }
        if ((item = stack.m_41720_()) instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            tiers = tieredItem.m_43314_();
        } else {
            tiers = Tiers.WOOD;
        }
        Tiers var2 = tiers;
        item = stack.m_41720_();
        if (item instanceof Tierable) {
            Tierable tierable = (Tierable)item;
            var2 = tierable.getTier();
        }
        if (var2.m_6604_() >= 4) {
            return 0.5;
        }
        if (var2 != Tiers.WOOD) {
            return 0.4;
        }
        return 0.3;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @Override
    public boolean canUse(Level world, Player user, InteractionHand hand) {
        return true;
    }
}

