/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util;

import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.util.BlockingType;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShieldBlockingType
extends BlockingType {
    public ShieldBlockingType(String name) {
        super(name);
    }

    @Override
    public void block(LivingEntity instance, @Nullable Entity entity, ItemStack blockingItem, DamageSource source, LocalFloatRef amount, LocalFloatRef f, LocalFloatRef g, LocalBooleanRef bl) {
        Player player;
        if (instance instanceof Player && (player = (Player)instance).m_36335_().m_41519_(blockingItem.m_41720_())) {
            return;
        }
        boolean hurt = false;
        float factor = this.getShieldBlockFactor(blockingItem);
        float base = this.getShieldBlockBase(blockingItem);
        g.set(Math.min(base + amount.get() * factor, amount.get()));
        if (!source.m_269533_(DamageTypeTags.f_268524_) && !source.m_269533_(DamageTypeTags.f_268415_)) {
            entity = source.m_7640_();
            if (entity instanceof LivingEntity) {
                instance.m_7909_(g.get());
                hurt = true;
                instance.m_6728_((LivingEntity)entity);
            }
        } else {
            g.set(amount.get());
        }
        if (!hurt) {
            instance.m_7909_(g.get());
        }
        amount.set(amount.get() - g.get());
        bl.set(true);
    }

    @Override
    public float getShieldBlockBase(ItemStack stack) {
        float f;
        Float configBase = this.getShieldBlockBaseConfig(stack);
        if (configBase != null) {
            return configBase.floatValue();
        }
        float f2 = f = stack.m_41737_("BlockEntityTag") != null ? 10.0f : 5.0f;
        if (((Boolean)Combatify.CONFIG.defender.get()).booleanValue()) {
            f += (float)this.getDefenderBonus(stack);
        }
        return f;
    }

    @Override
    public float getShieldBlockFactor(ItemStack stack) {
        Float configFactor = this.getShieldBlockFactorConfig(stack);
        if (configFactor != null) {
            return configFactor.floatValue();
        }
        return 0.0f;
    }

    @Override
    public double getShieldKnockbackResistanceValue(ItemStack stack) {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(stack.m_41720_())) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(stack.m_41720_());
            if (configurableItemData.blockKbRes != null) {
                return configurableItemData.blockKbRes;
            }
        }
        return stack.m_41737_("BlockEntityTag") != null ? 0.8 : 0.5;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @Override
    public boolean canUse(Level world, Player user, InteractionHand hand) {
        return true;
    }
}

