/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util;

import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.extensions.Tierable;
import net.atlas.combatify.util.BlockingType;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwordBlockingType
extends BlockingType {
    public SwordBlockingType(String name) {
        super(name);
    }

    @Override
    public void block(LivingEntity instance, @Nullable Entity entity, ItemStack blockingItem, DamageSource source, LocalFloatRef amount, LocalFloatRef f, LocalFloatRef g, LocalBooleanRef bl) {
        if (instance.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
            boolean blocked = !source.m_269533_(DamageTypeTags.f_268415_) && !source.m_269533_(DamageTypeTags.f_268524_);
            float factor = this.getShieldBlockFactor(blockingItem);
            float base = this.getShieldBlockBase(blockingItem);
            g.set(Math.min(base + amount.get() * factor, amount.get()));
            entity = source.m_7640_();
            if (blocked && entity instanceof LivingEntity) {
                instance.m_6728_((LivingEntity)entity);
            }
            amount.set(amount.get() - g.get());
        }
    }

    @Override
    public float getShieldBlockBase(ItemStack stack) {
        Float configBase = this.getShieldBlockBaseConfig(stack);
        if (configBase != null) {
            return configBase.floatValue();
        }
        int strengthIncrease = 0;
        if (((Boolean)Combatify.CONFIG.defender.get()).booleanValue()) {
            strengthIncrease += this.getDefenderBonus(stack);
        }
        return strengthIncrease;
    }

    @Override
    public float getShieldBlockFactor(ItemStack stack) {
        Tiers tiers;
        Float configFactor = this.getShieldBlockFactorConfig(stack);
        if (configFactor != null) {
            return configFactor.floatValue();
        }
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            tiers = tieredItem.m_43314_();
        } else {
            tiers = Tiers.WOOD;
        }
        Tiers var2 = tiers;
        item = stack.m_41720_();
        if (item instanceof Tierable) {
            Tierable tierable = (Tierable)item;
            var2 = tierable.getTier();
        }
        float strengthIncrease = var2.m_6631_() / 2.0f - 2.0f;
        strengthIncrease += (float)((Integer)Combatify.CONFIG.swordProtectionEfficacy.get()).intValue();
        strengthIncrease = Math.max(strengthIncrease, -3.0f);
        return Math.min(0.3f + strengthIncrease * 0.1f, 1.0f);
    }

    @Override
    public double getShieldKnockbackResistanceValue(ItemStack stack) {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(stack.m_41720_())) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(stack.m_41720_());
            if (configurableItemData.blockKbRes != null) {
                return configurableItemData.blockKbRes;
            }
        }
        return 0.0;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (user.m_20142_()) {
            user.m_6858_(false);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @Override
    public boolean canUse(Level world, Player user, InteractionHand hand) {
        ItemStack oppositeStack = user.m_21120_(InteractionHand.OFF_HAND);
        return hand != InteractionHand.OFF_HAND && oppositeStack.m_41619_() && (Boolean)Combatify.CONFIG.swordBlocking.get() != false;
    }

    @Override
    public Component getProtectionComponent() {
        return Component.m_237115_((String)"attribute.name.generic.damage_protection");
    }

    @Override
    public Component getReductionComponent() {
        return Component.m_237115_((String)"attribute.name.generic.damage_reduction");
    }
}

