/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify;

import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.UUID;
import java.util.function.Supplier;
import net.atlas.combatify.config.CombatifyConfig;
import net.atlas.combatify.config.ItemConfig;
import net.atlas.combatify.enchantment.DefendingEnchantment;
import net.atlas.combatify.enchantment.PiercingEnchantment;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.item.ItemRegistry;
import net.atlas.combatify.item.TieredShieldItem;
import net.atlas.combatify.networking.NetworkingHandler;
import net.atlas.combatify.util.ArrayListExtensions;
import net.atlas.combatify.util.BlockingType;
import net.atlas.combatify.util.EmptyBlockingType;
import net.atlas.combatify.util.NewShieldBlockingType;
import net.atlas.combatify.util.PrefixLogger;
import net.atlas.combatify.util.ShieldBlockingType;
import net.atlas.combatify.util.SwordBlockingType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1322;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_3542;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class Combatify
implements ModInitializer {
    public static final String MOD_ID = "combatify";
    public static Supplier<CombatifyState> state = Suppliers.memoize(() -> CombatifyState.COMBATIFY);
    public static final CombatifyConfig CONFIG = CombatifyConfig.createAndLoad();
    public static ItemConfig ITEMS;
    public static class_2960 modDetectionNetworkChannel;
    public NetworkingHandler networkingHandler;
    public static final List<TieredShieldItem> shields;
    public static final List<UUID> unmoddedPlayers;
    public static final List<UUID> moddedPlayers;
    public static final Map<UUID, Boolean> isPlayerAttacking;
    public static final Map<UUID, Boolean> finalizingAttack;
    public static final Map<UUID, Timer> scheduleHitResult;
    public static Map<String, BlockingType> registeredTypes;
    public static final PrefixLogger LOGGER;
    public static final BlockingType SWORD;
    public static final BlockingType SHIELD;
    public static final BlockingType NEW_SHIELD;
    public static final BlockingType EMPTY;

    public static void markState(Supplier<CombatifyState> state) {
        Combatify.state = state;
    }

    public static CombatifyState getState() {
        return state.get();
    }

    public void onInitialize() {
        Event event;
        this.networkingHandler = new NetworkingHandler();
        LOGGER.info("Init started.");
        class_2315.method_10009((class_1935)class_1802.field_8547, (class_2357)new class_2965(){

            @NotNull
            protected class_1676 method_12844(class_1937 world, class_2374 position, class_1799 stack) {
                class_1685 trident = new class_1685(class_1299.field_6127, world);
                trident.field_7650 = stack.method_7972();
                trident.method_23327(position.method_10216(), position.method_10214(), position.method_10215());
                trident.field_7572 = class_1665.class_1666.field_7593;
                return trident;
            }
        });
        if (CONFIG.configOnlyWeapons()) {
            ItemRegistry.registerWeapons();
            event = ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202);
            event.register(entries -> entries.addAfter((class_1935)class_1802.field_22022, new class_1935[]{ItemRegistry.WOODEN_KNIFE, ItemRegistry.STONE_KNIFE, ItemRegistry.IRON_KNIFE, ItemRegistry.GOLD_KNIFE, ItemRegistry.DIAMOND_KNIFE, ItemRegistry.NETHERITE_KNIFE, ItemRegistry.WOODEN_LONGSWORD, ItemRegistry.STONE_LONGSWORD, ItemRegistry.IRON_LONGSWORD, ItemRegistry.GOLD_LONGSWORD, ItemRegistry.DIAMOND_LONGSWORD, ItemRegistry.NETHERITE_LONGSWORD}));
        }
        if (CONFIG.tieredShields()) {
            TieredShieldItem.init();
            event = ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202);
            event.register(entries -> entries.addAfter((class_1935)class_1802.field_8255, new class_1935[]{TieredShieldItem.IRON_SHIELD, TieredShieldItem.GOLD_SHIELD, TieredShieldItem.DIAMOND_SHIELD, TieredShieldItem.NETHERITE_SHIELD}));
        }
        if (CONFIG.piercer()) {
            PiercingEnchantment.registerEnchants();
        }
        if (CONFIG.defender()) {
            DefendingEnchantment.registerEnchants();
        }
        List items = class_7923.field_41178.method_10220().toList();
        for (class_1792 item : items) {
            ((ItemExtensions)item).modifyAttributeModifiers();
        }
        class_1294.field_5910.method_5566(class_5134.field_23721, "648D7064-6A60-4F59-8ABE-C2C23A6DD7A9", 0.2, class_1322.class_1323.field_6331);
        class_1294.field_5911.method_5566(class_5134.field_23721, "22653B89-116E-49DC-9B6B-9971489B5BE5", -0.2, class_1322.class_1323.field_6331);
    }

    public static <T extends BlockingType> T registerBlockingType(T blockingType) {
        registeredTypes.put(blockingType.getName(), blockingType);
        return blockingType;
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    static {
        modDetectionNetworkChannel = Combatify.id("networking");
        shields = new ArrayListExtensions<TieredShieldItem>();
        unmoddedPlayers = new ArrayListExtensions<UUID>();
        moddedPlayers = new ArrayListExtensions<UUID>();
        isPlayerAttacking = new HashMap<UUID, Boolean>();
        finalizingAttack = new HashMap<UUID, Boolean>();
        scheduleHitResult = new HashMap<UUID, Timer>();
        registeredTypes = new HashMap<String, BlockingType>();
        LOGGER = new PrefixLogger(LogManager.getLogger((String)"Combatify"));
        SWORD = Combatify.registerBlockingType(new SwordBlockingType("sword").setToolBlocker(true).setDisablement(false).setCrouchable(false).setBlockHit(true).setRequireFullCharge(false).setSwordBlocking(true));
        SHIELD = Combatify.registerBlockingType(new ShieldBlockingType("shield"));
        NEW_SHIELD = Combatify.registerBlockingType(new NewShieldBlockingType("new_shield").setKbMechanics(false));
        EMPTY = new EmptyBlockingType("empty").setDisablement(false).setCrouchable(false).setRequireFullCharge(false).setKbMechanics(false);
    }

    public static enum CombatifyState implements class_3542
    {
        VANILLA("Vanilla", "vanilla"),
        COMBATIFY("Combatify", "combatify"),
        CTS_8C("CTS 8C", "combat_test");

        public final String name;
        public final String key;

        private CombatifyState(String name, String key) {
            this.name = name;
            this.key = key;
        }

        @NotNull
        public String method_15434() {
            return this.key;
        }

        public class_2561 getComponent() {
            return class_2561.method_48321((String)("options.combatify_state." + this.key), (String)this.name);
        }

        public String toString() {
            return "CombatifyState{name='" + this.name + "'}";
        }
    }
}

