/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.atlas.combatify.networking.NetworkingHandler;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_746;

public abstract class AtlasConfig {
    public final class_2960 name;
    private final Map<String, ConfigHolder<?>> valueNameToConfigHolderMap = Maps.newHashMap();
    public static final Map<class_2960, AtlasConfig> configs = Maps.newHashMap();
    final Path configFolderPath;
    File configFile;
    JsonElement configJsonElement;
    JsonObject configJsonObject;
    List<EnumHolder<?>> enumValues = new ArrayList();
    List<StringHolder> stringValues = new ArrayList<StringHolder>();
    List<BooleanHolder> booleanValues = new ArrayList<BooleanHolder>();
    List<IntegerHolder> integerValues = new ArrayList<IntegerHolder>();
    List<DoubleHolder> doubleValues = new ArrayList<DoubleHolder>();

    public AtlasConfig(class_2960 name) {
        this.defineConfigHolders();
        this.name = name;
        this.configFolderPath = Path.of(String.valueOf(FabricLoader.getInstance().getConfigDir().getFileName().getFileName()) + "/" + name.method_12836(), new String[0]);
        if (!Files.exists(this.configFolderPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.configFolderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new class_148(new class_128("Failed to create config directory for config " + String.valueOf(name), (Throwable)e));
            }
        }
        this.load();
        configs.put(name, this);
    }

    public abstract void defineConfigHolders();

    public abstract <T> void alertChange(ConfigValue<T> var1, T var2);

    public static String getString(JsonObject element, String name) {
        return element.get(name).getAsString();
    }

    public static Integer getInt(JsonObject element, String name) {
        return element.get(name).getAsInt();
    }

    public static Double getDouble(JsonObject element, String name) {
        return element.get(name).getAsDouble();
    }

    public static Boolean getBoolean(JsonObject element, String name) {
        return element.get(name).getAsBoolean();
    }

    public final void load() {
        this.configFile = new File(String.valueOf(this.configFolderPath.toAbsolutePath()) + "/" + this.name.method_12832() + ".json");
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
                InputStream inputStream = this.getDefaultedConfig();
                Files.write(this.configFile.toPath(), inputStream.readAllBytes(), new OpenOption[0]);
                inputStream.close();
            }
            catch (IOException e) {
                throw new class_148(new class_128("Failed to create config file for config " + String.valueOf(this.name), (Throwable)e));
            }
        }
        try {
            this.configJsonElement = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new FileReader(this.configFile)));
            this.configJsonObject = this.configJsonElement.getAsJsonObject();
            for (EnumHolder<?> enumHolder : this.enumValues) {
                if (!this.configJsonObject.has(enumHolder.heldValue.name)) continue;
                enumHolder.setValue(AtlasConfig.getString(this.configJsonObject, enumHolder.heldValue.name));
            }
            for (StringHolder stringHolder : this.stringValues) {
                if (!this.configJsonObject.has(stringHolder.heldValue.name)) continue;
                stringHolder.setValue(AtlasConfig.getString(this.configJsonObject, stringHolder.heldValue.name));
            }
            for (BooleanHolder booleanHolder : this.booleanValues) {
                if (!this.configJsonObject.has(booleanHolder.heldValue.name)) continue;
                booleanHolder.setValue(AtlasConfig.getBoolean(this.configJsonObject, booleanHolder.heldValue.name));
            }
            for (IntegerHolder integerHolder : this.integerValues) {
                if (!this.configJsonObject.has(integerHolder.heldValue.name)) continue;
                integerHolder.setValue(AtlasConfig.getInt(this.configJsonObject, integerHolder.heldValue.name));
            }
            for (DoubleHolder doubleHolder : this.doubleValues) {
                if (!this.configJsonObject.has(doubleHolder.heldValue.name)) continue;
                doubleHolder.setValue(AtlasConfig.getDouble(this.configJsonObject, doubleHolder.heldValue.name));
            }
            this.loadExtra(this.configJsonObject);
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
        }
    }

    protected abstract void loadExtra(JsonObject var1);

    protected abstract InputStream getDefaultedConfig();

    public AtlasConfig loadFromNetwork(class_2540 buf) {
        this.enumValues.forEach(enumHolder -> enumHolder.readFromBuf(buf));
        this.stringValues.forEach(stringHolder -> stringHolder.readFromBuf(buf));
        this.booleanValues.forEach(booleanHolder -> booleanHolder.readFromBuf(buf));
        this.integerValues.forEach(integerHolder -> integerHolder.readFromBuf(buf));
        this.doubleValues.forEach(doubleHolder -> doubleHolder.readFromBuf(buf));
        return this;
    }

    public static AtlasConfig staticLoadFromNetwork(class_2540 buf) {
        return configs.get(buf.method_10810()).loadFromNetwork(buf);
    }

    public void saveToNetwork(class_2540 buf) {
        this.enumValues.forEach(enumHolder -> enumHolder.writeToBuf(buf));
        this.stringValues.forEach(stringHolder -> stringHolder.writeToBuf(buf));
        this.booleanValues.forEach(booleanHolder -> booleanHolder.writeToBuf(buf));
        this.integerValues.forEach(integerHolder -> integerHolder.writeToBuf(buf));
        this.doubleValues.forEach(doubleHolder -> doubleHolder.writeToBuf(buf));
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public ConfigHolder<?> fromValue(ConfigValue<?> value) {
        return this.valueNameToConfigHolderMap.get(value.name);
    }

    @SafeVarargs
    public final <E extends Enum<E>> EnumHolder<E> createEnum(String name, Enum<E> defaultVal, Class<E> clazz, Enum<E> ... values) {
        EnumHolder<E> enumHolder = new EnumHolder<E>(new ConfigValue<Enum<E>>(defaultVal, values, false, name, this), clazz);
        this.enumValues.add(enumHolder);
        return enumHolder;
    }

    public StringHolder createString(String name, String defaultVal, String ... values) {
        StringHolder stringHolder = new StringHolder(new ConfigValue<String>(defaultVal, values, false, name, this));
        this.stringValues.add(stringHolder);
        return stringHolder;
    }

    public BooleanHolder createBoolean(String name, boolean defaultVal) {
        BooleanHolder booleanHolder = new BooleanHolder(new ConfigValue<Boolean>(defaultVal, new Boolean[]{false, true}, false, name, this));
        this.booleanValues.add(booleanHolder);
        return booleanHolder;
    }

    public IntegerHolder createInRestrictedValues(String name, Integer defaultVal, Integer ... values) {
        IntegerHolder integerHolder = new IntegerHolder(new ConfigValue<Integer>(defaultVal, values, false, name, this));
        this.integerValues.add(integerHolder);
        return integerHolder;
    }

    public IntegerHolder createInRange(String name, int defaultVal, int min, int max) {
        Integer[] range = new Integer[]{min, max};
        IntegerHolder integerHolder = new IntegerHolder(new ConfigValue<Integer>(defaultVal, range, true, name, this));
        this.integerValues.add(integerHolder);
        return integerHolder;
    }

    public DoubleHolder createInRestrictedValues(String name, Double defaultVal, Double ... values) {
        DoubleHolder doubleHolder = new DoubleHolder(new ConfigValue<Double>(defaultVal, values, false, name, this));
        this.doubleValues.add(doubleHolder);
        return doubleHolder;
    }

    public DoubleHolder createInRange(String name, double defaultVal, double min, double max) {
        Double[] range = new Double[]{min, max};
        DoubleHolder doubleHolder = new DoubleHolder(new ConfigValue<Double>(defaultVal, range, true, name, this));
        this.doubleValues.add(doubleHolder);
        return doubleHolder;
    }

    public void reloadFromDefault() {
        JsonElement configJsonElement = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(this.getDefaultedConfig())));
        JsonObject configJsonObject = configJsonElement.getAsJsonObject();
        for (EnumHolder<?> enumHolder : this.enumValues) {
            if (!configJsonObject.has(enumHolder.heldValue.name)) continue;
            enumHolder.setValue(AtlasConfig.getString(configJsonObject, enumHolder.heldValue.name));
        }
        for (StringHolder stringHolder : this.stringValues) {
            if (!configJsonObject.has(stringHolder.heldValue.name)) continue;
            stringHolder.setValue(AtlasConfig.getString(configJsonObject, stringHolder.heldValue.name));
        }
        for (BooleanHolder booleanHolder : this.booleanValues) {
            if (!configJsonObject.has(booleanHolder.heldValue.name)) continue;
            booleanHolder.setValue(AtlasConfig.getBoolean(configJsonObject, booleanHolder.heldValue.name));
        }
        for (IntegerHolder integerHolder : this.integerValues) {
            if (!configJsonObject.has(integerHolder.heldValue.name)) continue;
            integerHolder.setValue(AtlasConfig.getInt(configJsonObject, integerHolder.heldValue.name));
        }
        for (DoubleHolder doubleHolder : this.doubleValues) {
            if (!configJsonObject.has(doubleHolder.heldValue.name)) continue;
            doubleHolder.setValue(AtlasConfig.getDouble(configJsonObject, doubleHolder.heldValue.name));
        }
        this.loadExtra(configJsonObject);
    }

    public abstract void handleExtraSync(NetworkingHandler.AtlasConfigPacket var1, class_746 var2, PacketSender var3);

    public static class EnumHolder<E extends Enum<E>>
    extends ConfigHolder<Enum<E>> {
        public final Class<E> clazz;

        private EnumHolder(ConfigValue<Enum<E>> value, Class<E> clazz) {
            super(value, buf -> buf.method_10818(clazz), class_2540::method_10817);
            this.clazz = clazz;
        }

        @Override
        public void setValue(String name) {
            Enum newValue = null;
            for (Enum e : (Enum[])this.clazz.getEnumConstants()) {
                if (!e.toString().equals(name)) continue;
                newValue = e;
            }
            if (newValue == null) {
                return;
            }
            this.setValue(newValue);
        }
    }

    public record ConfigValue<T>(T defaultValue, T[] possibleValues, boolean isRange, String name, AtlasConfig owner) {
        public void emitChanged(T newValue) {
            this.owner.alertChange(this, newValue);
        }

        public boolean isValid(T newValue) {
            return Arrays.stream(this.possibleValues).toList().contains(newValue);
        }

        public void addAssociation(ConfigHolder<T> configHolder) {
            if (this.owner.valueNameToConfigHolderMap.containsKey(this.name)) {
                throw new class_148(new class_128("Tried to associate a ConfigHolder to a ConfigValue which already has one!", (Throwable)new RuntimeException()));
            }
            this.owner.valueNameToConfigHolderMap.put(this.name, configHolder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConfigValue)) {
                return false;
            }
            ConfigValue that = (ConfigValue)o;
            return this.isRange() == that.isRange() && Objects.equals(this.defaultValue, that.defaultValue) && Arrays.equals(this.possibleValues, that.possibleValues) && Objects.equals(this.name, that.name) && Objects.equals(this.owner, that.owner);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.defaultValue, this.isRange(), this.name, this.owner);
            result = 31 * result + Arrays.hashCode(this.possibleValues);
            return result;
        }
    }

    public static class StringHolder
    extends ConfigHolder<String> {
        private StringHolder(ConfigValue<String> value) {
            super(value, class_2540::method_19772, class_2540::method_10814);
        }
    }

    public static class BooleanHolder
    extends ConfigHolder<Boolean> {
        private BooleanHolder(ConfigValue<Boolean> value) {
            super(value, class_2540::readBoolean, class_2540::writeBoolean);
        }
    }

    public static class IntegerHolder
    extends ConfigHolder<Integer> {
        private IntegerHolder(ConfigValue<Integer> value) {
            super(value, class_2540::readInt, class_2540::writeInt);
        }

        @Override
        public boolean isNotValid(Integer newValue) {
            boolean inRange = this.heldValue.isRange && newValue >= ((Integer[])this.heldValue.possibleValues)[0] && newValue <= ((Integer[])this.heldValue.possibleValues)[1];
            return super.isNotValid(newValue) && !inRange;
        }
    }

    public static class DoubleHolder
    extends ConfigHolder<Double> {
        private DoubleHolder(ConfigValue<Double> value) {
            super(value, class_2540::readDouble, class_2540::writeDouble);
        }

        @Override
        public boolean isNotValid(Double newValue) {
            boolean inRange = this.heldValue.isRange && newValue >= ((Double[])this.heldValue.possibleValues)[0] && newValue <= ((Double[])this.heldValue.possibleValues)[1];
            return super.isNotValid(newValue) && !inRange;
        }
    }

    public static abstract class ConfigHolder<T> {
        private T value;
        public final ConfigValue<T> heldValue;
        public final class_2540.class_7461<T> reader;
        public final class_2540.class_7462<T> writer;

        public ConfigHolder(ConfigValue<T> value, class_2540.class_7461<T> reader, class_2540.class_7462<T> writer) {
            this.value = value.defaultValue;
            this.heldValue = value;
            this.reader = reader;
            this.writer = writer;
            value.addAssociation(this);
        }

        public T get() {
            return this.value;
        }

        public void writeToBuf(class_2540 buf) {
            this.writer.accept((Object)buf, this.value);
        }

        public void readFromBuf(class_2540 buf) {
            Object newValue = this.reader.apply((Object)buf);
            if (this.isNotValid(newValue)) {
                return;
            }
            this.heldValue.emitChanged(newValue);
            this.value = newValue;
        }

        public boolean isNotValid(T newValue) {
            return !this.heldValue.isValid(newValue);
        }

        public void setValue(T newValue) {
            if (this.isNotValid(newValue)) {
                return;
            }
            this.heldValue.emitChanged(newValue);
            this.value = newValue;
        }
    }
}

