/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.util.BlockingType;

public class ConfigurableItemData {
    public final Double damage;
    public final Double speed;
    public final Double reach;
    public final Double chargedReach;
    public final Integer stackSize;
    public final Integer cooldown;
    public final Boolean cooldownAfter;
    public final WeaponType type;
    public final BlockingType blockingType;
    public final Double blockBase;
    public final Double blockFactor;
    public final Double blockKbRes;
    public final Integer enchantability;
    public final Boolean isEnchantable;
    public final Boolean hasSwordEnchants;
    public final Integer useDuration;
    public final Double piercingLevel;

    ConfigurableItemData(Double attackDamage, Double attackSpeed, Double attackReach, Double chargedReach, Integer stackSize, Integer cooldown, Boolean cooldownAfter, WeaponType weaponType, BlockingType blockingType, Double blockBase, Double blockFactor, Double blockKbRes, Integer enchantability, Boolean isEnchantable, Boolean hasSwordEnchants, Integer useDuration, Double piercingLevel) {
        this.damage = ConfigurableItemData.clamp(attackDamage, -10.0, 1000.0);
        this.speed = ConfigurableItemData.clamp(attackSpeed, -1.0, 7.5);
        this.reach = ConfigurableItemData.clamp(attackReach, 0.0, 1024.0);
        this.chargedReach = ConfigurableItemData.clamp(chargedReach, 0.0, 10.0);
        this.stackSize = ConfigurableItemData.clamp(stackSize, 1, 64);
        this.cooldown = ConfigurableItemData.clamp(cooldown, 1, 1000);
        this.cooldownAfter = cooldownAfter;
        this.type = weaponType;
        this.blockingType = blockingType;
        this.blockBase = ConfigurableItemData.clamp(blockBase, 0.0, 1000.0);
        this.blockFactor = ConfigurableItemData.clamp(blockFactor, 0.0, 100.0);
        this.blockKbRes = ConfigurableItemData.clamp(blockKbRes, 0.0, 1.0);
        this.enchantability = ConfigurableItemData.clamp(enchantability, 0, 1000);
        this.isEnchantable = isEnchantable;
        this.hasSwordEnchants = hasSwordEnchants;
        this.useDuration = ConfigurableItemData.clamp(useDuration, 1, 1000);
        this.piercingLevel = ConfigurableItemData.clamp(piercingLevel, 0.0, 1.0);
    }

    public static Integer clamp(Integer value, int min, int max) {
        if (value == null) {
            return null;
        }
        return Math.min(Math.max(value, min), max);
    }

    public static Double clamp(Double value, double min, double max) {
        if (value == null) {
            return null;
        }
        return value < min ? min : Math.min(value, max);
    }
}

