/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.AtlasConfig;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.ConfigurableWeaponData;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.networking.NetworkingHandler;
import net.atlas.combatify.util.BlockingType;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class ItemConfig
extends AtlasConfig {
    public Map<class_1792, ConfigurableItemData> configuredItems;
    public Map<WeaponType, ConfigurableWeaponData> configuredWeapons;

    public ItemConfig() {
        super(Combatify.id("combatify-items"));
    }

    @Override
    protected void loadExtra(JsonObject object) {
        JsonArray typeArray;
        JsonElement defenders;
        if (!object.has("items")) {
            object.add("items", (JsonElement)new JsonArray());
        }
        JsonElement items = object.get("items");
        if (!object.has("weapon_types")) {
            object.add("weapon_types", (JsonElement)new JsonArray());
        }
        JsonElement weapons = object.get("weapon_types");
        if (!object.has("blocking_types")) {
            object.add("blocking_types", (JsonElement)new JsonArray());
        }
        if ((defenders = object.get("blocking_types")) instanceof JsonArray) {
            typeArray = (JsonArray)defenders;
            typeArray.asList().forEach(jsonElement -> {
                if (!(jsonElement instanceof JsonObject)) {
                    throw new class_148(class_128.method_560((Throwable)new IllegalStateException("Not a JSON Object: " + String.valueOf(jsonElement) + " this may be due to an incorrectly written config file."), (String)"Configuring Blocking Types"));
                }
                JsonObject jsonObject = (JsonObject)jsonElement;
                ItemConfig.parseBlockingType(jsonObject);
            });
        }
        if (items instanceof JsonArray) {
            JsonArray itemArray = (JsonArray)items;
            itemArray.asList().forEach(jsonElement -> {
                if (jsonElement instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    JsonElement patt0$temp = jsonObject.get("name");
                    if (patt0$temp instanceof JsonArray) {
                        JsonArray itemsWithConfig = (JsonArray)patt0$temp;
                        itemsWithConfig.asList().forEach(itemName -> {
                            class_1792 item = ItemConfig.itemFromName(itemName.getAsString());
                            this.parseItemConfig(item, jsonObject);
                        });
                    } else {
                        class_1792 item = ItemConfig.itemFromJson(jsonObject);
                        this.parseItemConfig(item, jsonObject);
                    }
                } else {
                    throw new class_148(class_128.method_560((Throwable)new IllegalStateException("Not a JSON Object: " + String.valueOf(jsonElement) + " this may be due to an incorrectly written config file."), (String)"Configuring Items"));
                }
            });
        }
        if (weapons instanceof JsonArray) {
            typeArray = (JsonArray)weapons;
            typeArray.asList().forEach(jsonElement -> {
                Boolean tierable;
                Double piercingLevel;
                Boolean hasSwordEnchants;
                BlockingType blockingType;
                Double chargedReach;
                Double reach;
                Double speed;
                Double damageOffset;
                WeaponType type;
                if (jsonElement instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    type = ItemConfig.typeFromJson(jsonObject);
                    damageOffset = null;
                    speed = null;
                    reach = null;
                    chargedReach = null;
                    blockingType = null;
                    hasSwordEnchants = null;
                    piercingLevel = null;
                    if (!jsonObject.has("tierable")) {
                        throw new class_148(class_128.method_560((Throwable)new JsonSyntaxException("The JSON must contain the boolean `tierable` if a weapon type is defined!"), (String)"Configuring Weapon Types"));
                    }
                    tierable = ItemConfig.getBoolean(jsonObject, "tierable");
                    if (jsonObject.has("damage_offset")) {
                        damageOffset = ItemConfig.getDouble(jsonObject, "damage_offset");
                    }
                    if (jsonObject.has("speed")) {
                        speed = ItemConfig.getDouble(jsonObject, "speed");
                    }
                    if (jsonObject.has("reach")) {
                        reach = ItemConfig.getDouble(jsonObject, "reach");
                    }
                    if (jsonObject.has("charged_reach")) {
                        chargedReach = ItemConfig.getDouble(jsonObject, "charged_reach");
                    }
                    if (jsonObject.has("blocking_type")) {
                        String blocking_type = ItemConfig.getString(jsonObject, "blocking_type");
                        if (!Combatify.registeredTypes.containsKey(blocking_type = blocking_type.toLowerCase(Locale.ROOT))) {
                            class_128 report = class_128.method_560((Throwable)new JsonSyntaxException("The specified blocking type does not exist!"), (String)"Applying Item Blocking Type");
                            class_129 crashReportCategory = report.method_562("Weapon Type being parsed");
                            crashReportCategory.method_578("Type name", (Object)blocking_type);
                            crashReportCategory.method_578("Json Object", (Object)jsonObject);
                            throw new class_148(report);
                        }
                        blockingType = Combatify.registeredTypes.get(blocking_type);
                    }
                    if (jsonObject.has("has_sword_enchants")) {
                        hasSwordEnchants = ItemConfig.getBoolean(jsonObject, "has_sword_enchants");
                    }
                    if (jsonObject.has("armor_piercing")) {
                        piercingLevel = ItemConfig.getDouble(jsonObject, "armor_piercing");
                    }
                } else {
                    throw new class_148(class_128.method_560((Throwable)new IllegalStateException("Not a JSON Object: " + String.valueOf(jsonElement) + " this may be due to an incorrectly written config file."), (String)"Configuring Weapon Types"));
                }
                ConfigurableWeaponData configurableWeaponData = new ConfigurableWeaponData(damageOffset, speed, reach, chargedReach, tierable, blockingType, hasSwordEnchants, piercingLevel);
                this.configuredWeapons.put(type, configurableWeaponData);
            });
        }
    }

    @Override
    protected InputStream getDefaultedConfig() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("combatify-items.json");
    }

    @Override
    public void defineConfigHolders() {
        this.configuredItems = new HashMap<class_1792, ConfigurableItemData>();
        this.configuredWeapons = new HashMap<WeaponType, ConfigurableWeaponData>();
    }

    @Override
    public <T> void alertChange(AtlasConfig.ConfigValue<T> tConfigValue, T newValue) {
    }

    public static String getString(JsonObject element, String name) {
        return element.get(name).getAsString();
    }

    public static Integer getInt(JsonObject element, String name) {
        return element.get(name).getAsInt();
    }

    public static Double getDouble(JsonObject element, String name) {
        return element.get(name).getAsDouble();
    }

    public static Boolean getBoolean(JsonObject element, String name) {
        return element.get(name).getAsBoolean();
    }

    public static class_1792 itemFromJson(JsonObject jsonObject) {
        String string = class_3518.method_15265((JsonObject)jsonObject, (String)"name");
        return ItemConfig.itemFromName(string);
    }

    public static class_1792 itemFromName(String string) {
        class_1792 item = class_7923.field_41178.method_17966(class_2960.method_12829((String)string)).orElse(null);
        if (item == class_1802.field_8162) {
            throw new class_148(class_128.method_560((Throwable)new JsonSyntaxException("You can't configure an empty item!"), (String)"Configuring Items"));
        }
        return item;
    }

    public static WeaponType typeFromJson(JsonObject jsonObject) {
        String weapon_type = class_3518.method_15265((JsonObject)jsonObject, (String)"name");
        switch (weapon_type = weapon_type.toUpperCase(Locale.ROOT)) {
            case "SWORD": 
            case "LONGSWORD": 
            case "AXE": 
            case "PICKAXE": 
            case "HOE": 
            case "SHOVEL": 
            case "KNIFE": 
            case "TRIDENT": {
                break;
            }
            default: {
                class_128 report = class_128.method_560((Throwable)new JsonSyntaxException("The specified weapon type does not exist!"), (String)"Getting Weapon Type");
                class_129 crashReportCategory = report.method_562("Weapon Type being parsed");
                crashReportCategory.method_578("Type name", (Object)weapon_type);
                crashReportCategory.method_578("Json Object", (Object)jsonObject);
                throw new class_148(report);
            }
        }
        return WeaponType.fromID(weapon_type);
    }

    public static void parseBlockingType(JsonObject jsonObject) {
        String blocking_type = class_3518.method_15265((JsonObject)jsonObject, (String)"name");
        if ((blocking_type = blocking_type.toLowerCase(Locale.ROOT)).equals("empty") || blocking_type.equals("blank")) {
            return;
        }
        if (!Combatify.registeredTypes.containsKey(blocking_type) || jsonObject.has("class")) {
            JsonPrimitive jsonPrimitive;
            JsonElement jsonElement;
            if (jsonObject.has("class") && (jsonElement = jsonObject.get("class")) instanceof JsonPrimitive && (jsonPrimitive = (JsonPrimitive)jsonElement).isString()) {
                try {
                    Class<?> clazz = BlockingType.class.getClassLoader().loadClass(jsonPrimitive.getAsString());
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    Object object = constructor.newInstance(blocking_type);
                    if (object instanceof BlockingType) {
                        BlockingType blockingType = (BlockingType)object;
                        if (jsonObject.has("require_full_charge")) {
                            blockingType.setRequireFullCharge(ItemConfig.getBoolean(jsonObject, "require_full_charge"));
                        }
                        if (jsonObject.has("is_tool")) {
                            blockingType.setToolBlocker(ItemConfig.getBoolean(jsonObject, "is_tool"));
                        }
                        if (jsonObject.has("can_block_hit")) {
                            blockingType.setBlockHit(ItemConfig.getBoolean(jsonObject, "can_block_hit"));
                        }
                        if (jsonObject.has("can_crouch_block")) {
                            blockingType.setCrouchable(ItemConfig.getBoolean(jsonObject, "can_crouch_block"));
                        }
                        if (jsonObject.has("can_be_disabled")) {
                            blockingType.setDisablement(ItemConfig.getBoolean(jsonObject, "can_be_disabled"));
                        }
                        if (jsonObject.has("default_kb_mechanics")) {
                            blockingType.setKbMechanics(ItemConfig.getBoolean(jsonObject, "default_kb_mechanics"));
                        }
                        if (jsonObject.has("requires_sword_blocking")) {
                            blockingType.setSwordBlocking(ItemConfig.getBoolean(jsonObject, "requires_sword_blocking"));
                        }
                        Combatify.registerBlockingType(blockingType);
                        return;
                    }
                    class_128 report = class_128.method_560((Throwable)new JsonSyntaxException("The specified class is not an instance of BlockingType!"), (String)"Creating Blocking Type");
                    class_129 crashReportCategory = report.method_562("Blocking Type being parsed");
                    crashReportCategory.method_578("Class", (Object)clazz.getName());
                    crashReportCategory.method_578("Type Name", (Object)blocking_type);
                    crashReportCategory.method_578("Json Object", (Object)jsonObject);
                    throw new class_148(report);
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    class_128 report = class_128.method_560((Throwable)new JsonSyntaxException("The specified class does not exist, or otherwise lacks a constructor with a String parameter", (Throwable)e), (String)"Creating Blocking Type");
                    class_129 crashReportCategory = report.method_562("Blocking Type being parsed");
                    crashReportCategory.method_578("Class", (Object)ItemConfig.getString(jsonObject, "class"));
                    crashReportCategory.method_578("Type Name", (Object)blocking_type);
                    crashReportCategory.method_578("Json Object", (Object)jsonObject);
                    throw new class_148(report);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    class_128 report = class_128.method_560((Throwable)new RuntimeException(e), (String)"Creating Blocking Type");
                    class_129 crashReportCategory = report.method_562("Blocking Type being parsed");
                    crashReportCategory.method_578("Class", (Object)ItemConfig.getString(jsonObject, "class"));
                    crashReportCategory.method_578("Type Name", (Object)blocking_type);
                    crashReportCategory.method_578("Json Object", (Object)jsonObject);
                    throw new class_148(report);
                }
            }
            class_128 report = class_128.method_560((Throwable)new JsonSyntaxException("You cannot create a blocking type without a class!"), (String)"Creating Blocking Type");
            class_129 crashReportCategory = report.method_562("Blocking Type being parsed");
            crashReportCategory.method_578("Type Name", (Object)blocking_type);
            crashReportCategory.method_578("Json Object", (Object)jsonObject);
            throw new class_148(report);
        }
        BlockingType blockingType = Combatify.registeredTypes.get(blocking_type);
        if (jsonObject.has("require_full_charge")) {
            blockingType.setRequireFullCharge(ItemConfig.getBoolean(jsonObject, "require_full_charge"));
        }
        if (jsonObject.has("is_tool")) {
            blockingType.setToolBlocker(ItemConfig.getBoolean(jsonObject, "is_tool"));
        }
        if (jsonObject.has("can_block_hit")) {
            blockingType.setBlockHit(ItemConfig.getBoolean(jsonObject, "can_block_hit"));
        }
        if (jsonObject.has("can_crouch_block")) {
            blockingType.setCrouchable(ItemConfig.getBoolean(jsonObject, "can_crouch_block"));
        }
        if (jsonObject.has("can_be_disabled")) {
            blockingType.setDisablement(ItemConfig.getBoolean(jsonObject, "can_be_disabled"));
        }
        if (jsonObject.has("default_kb_mechanics")) {
            blockingType.setKbMechanics(ItemConfig.getBoolean(jsonObject, "default_kb_mechanics"));
        }
        if (jsonObject.has("requires_sword_blocking")) {
            blockingType.setSwordBlocking(ItemConfig.getBoolean(jsonObject, "requires_sword_blocking"));
        }
    }

    @Override
    public ItemConfig loadFromNetwork(class_2540 buf) {
        super.loadFromNetwork(buf);
        Combatify.registeredTypes = buf.method_34067(class_2540::method_19772, buf1 -> {
            try {
                Class<?> clazz = BlockingType.class.getClassLoader().loadClass(buf1.method_19772());
                Constructor<?> constructor = clazz.getConstructor(String.class);
                String name = buf1.method_19772();
                Object object = constructor.newInstance(name);
                if (object instanceof BlockingType) {
                    BlockingType blockingType = (BlockingType)object;
                    blockingType.setDisablement(buf1.readBoolean());
                    blockingType.setBlockHit(buf1.readBoolean());
                    blockingType.setCrouchable(buf1.readBoolean());
                    blockingType.setKbMechanics(buf1.readBoolean());
                    blockingType.setToolBlocker(buf1.readBoolean());
                    blockingType.setRequireFullCharge(buf1.readBoolean());
                    blockingType.setSwordBlocking(buf1.readBoolean());
                    Combatify.registerBlockingType(blockingType);
                    return blockingType;
                }
                class_128 report = class_128.method_560((Throwable)new IllegalStateException("The specified class is not an instance of BlockingType!"), (String)"Syncing Blocking Types");
                class_129 crashReportCategory = report.method_562("Blocking Type being synced");
                crashReportCategory.method_578("Class", (Object)clazz.getName());
                crashReportCategory.method_578("Type Name", (Object)name);
                throw new class_148(report);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new class_148(class_128.method_560((Throwable)new RuntimeException(e), (String)"Syncing Blocking Types"));
            }
        });
        this.configuredItems = buf.method_34067(buf12 -> (class_1792)buf12.method_42064((class_2359)class_7923.field_41178), buf1 -> {
            Double damage = buf1.readDouble();
            Double speed = buf1.readDouble();
            Double reach = buf1.readDouble();
            Double chargedReach = buf1.readDouble();
            Integer stackSize = buf1.readInt();
            Integer cooldown = buf1.readInt();
            Boolean cooldownAfter = null;
            if (cooldown != -10) {
                cooldownAfter = buf1.readBoolean();
            }
            String weaponType = buf1.method_19772();
            WeaponType type = null;
            String blockingType = buf1.method_19772();
            BlockingType bType = Combatify.registeredTypes.get(blockingType);
            Double blockBase = buf1.readDouble();
            Double blockFactor = buf1.readDouble();
            Double blockKbRes = buf1.readDouble();
            Integer enchantlevel = buf1.readInt();
            int isEnchantableAsInt = buf1.readInt();
            int hasSwordEnchantsAsInt = buf1.readInt();
            Boolean isEnchantable = null;
            Boolean hasSwordEnchants = null;
            Integer useDuration = buf1.readInt();
            Double piercingLevel = buf1.readDouble();
            if (damage == -10.0) {
                damage = null;
            }
            if (speed == -10.0) {
                speed = null;
            }
            if (reach == -10.0) {
                reach = null;
            }
            if (chargedReach == -10.0) {
                chargedReach = null;
            }
            if (stackSize == -10) {
                stackSize = null;
            }
            if (cooldown == -10) {
                cooldown = null;
            }
            if (blockBase == -10.0) {
                blockBase = null;
            }
            if (blockFactor == -10.0) {
                blockFactor = null;
            }
            if (blockKbRes == -10.0) {
                blockKbRes = null;
            }
            if (enchantlevel == -10) {
                enchantlevel = null;
            }
            if (isEnchantableAsInt != -10) {
                isEnchantable = isEnchantableAsInt == 1;
            }
            if (hasSwordEnchantsAsInt != -10) {
                hasSwordEnchants = hasSwordEnchantsAsInt == 1;
            }
            if (useDuration == -10) {
                useDuration = null;
            }
            if (piercingLevel == -10.0) {
                piercingLevel = null;
            }
            switch (weaponType) {
                case "SWORD": 
                case "LONGSWORD": 
                case "AXE": 
                case "PICKAXE": 
                case "HOE": 
                case "SHOVEL": 
                case "KNIFE": 
                case "TRIDENT": {
                    type = WeaponType.fromID(weaponType);
                }
            }
            return new ConfigurableItemData(damage, speed, reach, chargedReach, stackSize, cooldown, cooldownAfter, type, bType, blockBase, blockFactor, blockKbRes, enchantlevel, isEnchantable, hasSwordEnchants, useDuration, piercingLevel);
        });
        this.configuredWeapons = buf.method_34067(buf1 -> WeaponType.fromID(buf1.method_19772()), buf1 -> {
            Double damageOffset = buf1.readDouble();
            Double speed = buf1.readDouble();
            Double reach = buf1.readDouble();
            Double chargedReach = buf1.readDouble();
            Boolean tierable = buf1.readBoolean();
            String blockingType = buf1.method_19772();
            BlockingType bType = Combatify.registeredTypes.get(blockingType);
            int hasSwordEnchantsAsInt = buf1.readInt();
            Boolean hasSwordEnchants = null;
            Double piercingLevel = buf1.readDouble();
            if (damageOffset == -10.0) {
                damageOffset = null;
            }
            if (speed == -10.0) {
                speed = null;
            }
            if (reach == -10.0) {
                reach = null;
            }
            if (chargedReach == -10.0) {
                chargedReach = null;
            }
            if (hasSwordEnchantsAsInt != -10) {
                hasSwordEnchants = hasSwordEnchantsAsInt == 1;
            }
            if (piercingLevel == -10.0) {
                piercingLevel = null;
            }
            return new ConfigurableWeaponData(damageOffset, speed, reach, chargedReach, tierable, bType, hasSwordEnchants, piercingLevel);
        });
        return this;
    }

    @Override
    public void saveToNetwork(class_2540 buf) {
        super.saveToNetwork(buf);
        buf.method_34063(Combatify.registeredTypes, class_2540::method_10814, (buf1, blockingType) -> {
            buf1.method_10814(blockingType.getClass().getName());
            buf1.method_10814(blockingType.getName());
            buf1.writeBoolean(blockingType.canBeDisabled());
            buf1.writeBoolean(blockingType.canBlockHit());
            buf1.writeBoolean(blockingType.canCrouchBlock());
            buf1.writeBoolean(blockingType.defaultKbMechanics());
            buf1.writeBoolean(blockingType.isToolBlocker());
            buf1.writeBoolean(blockingType.requireFullCharge());
            buf1.writeBoolean(blockingType.requiresSwordBlocking());
        });
        buf.method_34063(this.configuredItems, (buf1, item) -> buf1.method_42065((class_2359)class_7923.field_41178, item), (buf12, configurableItemData) -> {
            buf12.writeDouble(configurableItemData.damage == null ? -10.0 : configurableItemData.damage);
            buf12.writeDouble(configurableItemData.speed == null ? -10.0 : configurableItemData.speed);
            buf12.writeDouble(configurableItemData.reach == null ? -10.0 : configurableItemData.reach);
            buf12.writeDouble(configurableItemData.chargedReach == null ? -10.0 : configurableItemData.chargedReach);
            buf12.writeInt(configurableItemData.stackSize == null ? -10 : configurableItemData.stackSize);
            buf12.writeInt(configurableItemData.cooldown == null ? -10 : configurableItemData.cooldown);
            if (configurableItemData.cooldown != null) {
                buf12.writeBoolean(configurableItemData.cooldownAfter.booleanValue());
            }
            buf12.method_10814(configurableItemData.type == null ? "empty" : configurableItemData.type.name());
            buf12.method_10814(configurableItemData.blockingType == null ? "blank" : configurableItemData.blockingType.getName());
            buf12.writeDouble(configurableItemData.blockBase == null ? -10.0 : configurableItemData.blockBase);
            buf12.writeDouble(configurableItemData.blockFactor == null ? -10.0 : configurableItemData.blockFactor);
            buf12.writeDouble(configurableItemData.blockKbRes == null ? -10.0 : configurableItemData.blockKbRes);
            buf12.writeInt(configurableItemData.enchantability == null ? -10 : configurableItemData.enchantability);
            buf12.writeInt(configurableItemData.isEnchantable == null ? -10 : (configurableItemData.isEnchantable != false ? 1 : 0));
            buf12.writeInt(configurableItemData.hasSwordEnchants == null ? -10 : (configurableItemData.hasSwordEnchants != false ? 1 : 0));
            buf12.writeInt(configurableItemData.useDuration == null ? -10 : configurableItemData.useDuration);
            buf12.writeDouble(configurableItemData.piercingLevel == null ? -10.0 : configurableItemData.piercingLevel);
        });
        buf.method_34063(this.configuredWeapons, (buf1, type) -> buf1.method_10814(type.name()), (buf12, configurableWeaponData) -> {
            buf12.writeDouble(configurableWeaponData.damageOffset == null ? -10.0 : configurableWeaponData.damageOffset);
            buf12.writeDouble(configurableWeaponData.speed == null ? -10.0 : configurableWeaponData.speed);
            buf12.writeDouble(configurableWeaponData.reach == null ? -10.0 : configurableWeaponData.reach);
            buf12.writeDouble(configurableWeaponData.chargedReach == null ? -10.0 : configurableWeaponData.chargedReach);
            buf12.writeBoolean(configurableWeaponData.tierable.booleanValue());
            buf12.method_10814(configurableWeaponData.blockingType == null ? "blank" : configurableWeaponData.blockingType.getName());
            buf12.writeInt(configurableWeaponData.hasSwordEnchants == null ? -10 : (configurableWeaponData.hasSwordEnchants != false ? 1 : 0));
            buf12.writeDouble(configurableWeaponData.piercingLevel == null ? -10.0 : configurableWeaponData.piercingLevel);
        });
    }

    @Override
    public void handleExtraSync(NetworkingHandler.AtlasConfigPacket packet, class_746 player, PacketSender sender) {
        Combatify.LOGGER.info("Loading config details from buffer.");
        List items = class_7923.field_41178.method_10220().toList();
        for (class_1792 item : items) {
            ((ItemExtensions)item).modifyAttributeModifiers();
        }
        for (class_1792 item : Combatify.ITEMS.configuredItems.keySet()) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
            if (configurableItemData.stackSize == null) continue;
            ((ItemExtensions)item).setStackSize(configurableItemData.stackSize);
        }
    }

    public void parseItemConfig(class_1792 item, JsonObject jsonObject) {
        if (item == null) {
            return;
        }
        Double damage = null;
        Double speed = null;
        Double reach = null;
        Double chargedReach = null;
        Integer stack_size = null;
        Integer cooldown = null;
        Boolean cooldownAfterUse = null;
        WeaponType type = null;
        BlockingType blockingType = null;
        Double blockBase = null;
        Double blockFactor = null;
        Double blockKbRes = null;
        Integer enchantment_level = null;
        Boolean isEnchantable = null;
        Boolean hasSwordEnchants = null;
        Integer useDuration = null;
        Double piercingLevel = null;
        if (this.configuredItems.containsKey(item)) {
            ConfigurableItemData oldData = this.configuredItems.get(item);
            damage = oldData.damage;
            speed = oldData.speed;
            reach = oldData.reach;
            chargedReach = oldData.chargedReach;
            stack_size = oldData.stackSize;
            cooldown = oldData.cooldown;
            cooldownAfterUse = oldData.cooldownAfter;
            type = oldData.type;
            blockingType = oldData.blockingType;
            blockBase = oldData.blockBase;
            blockFactor = oldData.blockFactor;
            blockKbRes = oldData.blockKbRes;
            enchantment_level = oldData.enchantability;
            isEnchantable = oldData.isEnchantable;
            hasSwordEnchants = oldData.hasSwordEnchants;
            useDuration = oldData.useDuration;
            piercingLevel = oldData.piercingLevel;
        }
        if (jsonObject.has("damage")) {
            damage = ItemConfig.getDouble(jsonObject, "damage");
        }
        if (jsonObject.has("speed")) {
            speed = ItemConfig.getDouble(jsonObject, "speed");
        }
        if (jsonObject.has("reach")) {
            reach = ItemConfig.getDouble(jsonObject, "reach");
        }
        if (jsonObject.has("charged_reach")) {
            chargedReach = ItemConfig.getDouble(jsonObject, "charged_reach");
        }
        if (jsonObject.has("stack_size")) {
            stack_size = ItemConfig.getInt(jsonObject, "stack_size");
        }
        if (jsonObject.has("cooldown")) {
            cooldown = ItemConfig.getInt(jsonObject, "cooldown");
        }
        if (jsonObject.has("weapon_type")) {
            String weapon_type = ItemConfig.getString(jsonObject, "weapon_type");
            switch (weapon_type = weapon_type.toUpperCase(Locale.ROOT)) {
                case "SWORD": 
                case "LONGSWORD": 
                case "AXE": 
                case "PICKAXE": 
                case "HOE": 
                case "SHOVEL": 
                case "KNIFE": 
                case "TRIDENT": {
                    type = WeaponType.fromID(weapon_type);
                    break;
                }
                default: {
                    class_128 report = class_128.method_560((Throwable)new JsonSyntaxException("The specified weapon type does not exist!"), (String)"Applying Item Weapon Type");
                    class_129 crashReportCategory = report.method_562("Weapon Type being parsed");
                    crashReportCategory.method_578("Type name", (Object)weapon_type);
                    crashReportCategory.method_578("Json Object", (Object)jsonObject);
                    throw new class_148(report);
                }
            }
        }
        if (jsonObject.has("blocking_type")) {
            String blocking_type = ItemConfig.getString(jsonObject, "blocking_type");
            if (!Combatify.registeredTypes.containsKey(blocking_type = blocking_type.toLowerCase(Locale.ROOT))) {
                class_128 report = class_128.method_560((Throwable)new JsonSyntaxException("The specified blocking type does not exist!"), (String)"Applying Item Blocking Type");
                class_129 crashReportCategory = report.method_562("Blocking Type being parsed");
                crashReportCategory.method_578("Type name", (Object)blocking_type);
                crashReportCategory.method_578("Json Object", (Object)jsonObject);
                throw new class_148(report);
            }
            blockingType = Combatify.registeredTypes.get(blocking_type);
        }
        if (cooldown != null && cooldownAfterUse == null) {
            if (!jsonObject.has("cooldown_after")) {
                throw new class_148(class_128.method_560((Throwable)new JsonSyntaxException("The JSON must contain the boolean 'cooldown_after' if a cooldown is defined!"), (String)"Applying Item Cooldown"));
            }
            cooldownAfterUse = ItemConfig.getBoolean(jsonObject, "cooldown_after");
        }
        if (jsonObject.has("base_protection")) {
            blockBase = ItemConfig.getDouble(jsonObject, "base_protection");
        }
        if (jsonObject.has("protection_factor")) {
            blockFactor = ItemConfig.getDouble(jsonObject, "protection_factor");
        }
        if (jsonObject.has("block_knockback_resistance")) {
            blockKbRes = ItemConfig.getDouble(jsonObject, "block_knockback_resistance");
        }
        if (jsonObject.has("enchantment_level")) {
            enchantment_level = ItemConfig.getInt(jsonObject, "enchantment_level");
        }
        if (jsonObject.has("is_enchantable")) {
            isEnchantable = ItemConfig.getBoolean(jsonObject, "is_enchantable");
        }
        if (jsonObject.has("has_sword_enchants")) {
            hasSwordEnchants = ItemConfig.getBoolean(jsonObject, "has_sword_enchants");
        }
        if (jsonObject.has("use_duration")) {
            useDuration = ItemConfig.getInt(jsonObject, "use_duration");
        }
        if (jsonObject.has("armor_piercing")) {
            piercingLevel = ItemConfig.getDouble(jsonObject, "armor_piercing");
        }
        ConfigurableItemData configurableItemData = new ConfigurableItemData(damage, speed, reach, chargedReach, stack_size, cooldown, cooldownAfterUse, type, blockingType, blockBase, blockFactor, blockKbRes, enchantment_level, isEnchantable, hasSwordEnchants, useDuration, piercingLevel);
        this.configuredItems.put(item, configurableItemData);
    }
}

