/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import java.util.UUID;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableWeaponData;
import net.atlas.combatify.item.NewAttributes;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_5134;

public enum WeaponType {
    EMPTY,
    SWORD,
    LONGSWORD,
    AXE,
    PICKAXE,
    HOE,
    SHOVEL,
    KNIFE,
    TRIDENT;

    public static final UUID BASE_ATTACK_SPEED_CTS_UUID;
    public static final UUID BASE_ATTACK_REACH_UUID;

    public void addCombatAttributes(class_1832 tier, ImmutableMultimap.Builder<class_1320, class_1322> attributeModifiers) {
        if (this.isEmpty()) {
            return;
        }
        double speed = this.getSpeed(tier);
        double damage = this.getDamage(tier);
        double reach = this.getReach();
        attributeModifiers.put((Object)class_5134.field_23721, (Object)new class_1322(class_1792.field_8006, "Weapon modifier", damage, class_1322.class_1323.field_6328));
        if (!Combatify.CONFIG.instaAttack()) {
            attributeModifiers.put((Object)class_5134.field_23723, (Object)new class_1322(BASE_ATTACK_SPEED_CTS_UUID, "Weapon modifier", speed, class_1322.class_1323.field_6328));
        }
        if (reach != 0.0 && Combatify.CONFIG.attackReach()) {
            attributeModifiers.put((Object)NewAttributes.ATTACK_REACH, (Object)new class_1322(BASE_ATTACK_REACH_UUID, "Weapon modifier", reach, class_1322.class_1323.field_6328));
        }
    }

    public void addCombatAttributes(class_1832 tier, ArrayListMultimap<class_1320, class_1322> attributeModifiers) {
        if (this.isEmpty()) {
            return;
        }
        double speed = this.getSpeed(tier);
        double damage = this.getDamage(tier);
        double reach = this.getReach();
        attributeModifiers.put((Object)class_5134.field_23721, (Object)new class_1322(class_1792.field_8006, "Weapon modifier", damage, class_1322.class_1323.field_6328));
        if (!Combatify.CONFIG.instaAttack()) {
            attributeModifiers.put((Object)class_5134.field_23723, (Object)new class_1322(BASE_ATTACK_SPEED_CTS_UUID, "Weapon modifier", speed, class_1322.class_1323.field_6328));
        }
        if (reach != 0.0 && Combatify.CONFIG.attackReach()) {
            attributeModifiers.put((Object)NewAttributes.ATTACK_REACH, (Object)new class_1322(BASE_ATTACK_REACH_UUID, "Weapon modifier", reach, class_1322.class_1323.field_6328));
        }
    }

    public double getDamage(class_1832 tier) {
        boolean isCTSNotT1;
        int modifier = Combatify.CONFIG.fistDamage() ? 1 : 0;
        double damageBonus = tier.method_8028() + (float)modifier;
        boolean isNotTier1 = tier != class_1834.field_8922 && tier != class_1834.field_8929 && damageBonus != (double)(Combatify.CONFIG.fistDamage() ? 1 : 0);
        boolean bl = isCTSNotT1 = isNotTier1 && Combatify.CONFIG.ctsAttackBalancing();
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.damageOffset != null) {
                if (configurableWeaponData.tierable.booleanValue()) {
                    if (isCTSNotT1) {
                        return damageBonus + configurableWeaponData.damageOffset;
                    }
                    return damageBonus + configurableWeaponData.damageOffset + 1.0;
                }
                return (double)modifier + configurableWeaponData.damageOffset;
            }
        }
        switch (this.ordinal()) {
            case 4: 
            case 7: {
                if (isCTSNotT1) {
                    return damageBonus;
                }
                return damageBonus + 1.0;
            }
            case 1: {
                if (isCTSNotT1) {
                    return damageBonus + 1.0;
                }
                return damageBonus + 2.0;
            }
            case 3: {
                if (!Combatify.CONFIG.ctsAttackBalancing()) {
                    return (isNotTier1 ? (tier == class_1834.field_22033 ? 8 : 7) : 5) + modifier;
                }
                if (isCTSNotT1) {
                    return damageBonus + 2.0;
                }
                return damageBonus + 3.0;
            }
            case 2: 
            case 5: {
                if (tier != class_1834.field_8923 && tier != class_1834.field_8930) {
                    if (tier == class_1834.field_22033 || tier.method_8024() >= 4) {
                        return tier == class_1834.field_22033 ? (double)(2 + modifier) : 2.0 + damageBonus - 4.0 + (double)modifier;
                    }
                    return modifier;
                }
                return 1 + modifier;
            }
            case 6: {
                return damageBonus;
            }
            case 8: {
                return 5 + modifier + (Combatify.CONFIG.ctsAttackBalancing() ? 0 : 2);
            }
        }
        return 0.0 + (double)modifier;
    }

    public double getSpeed(class_1832 tier) {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.speed != null) {
                return configurableWeaponData.speed - (double)Combatify.CONFIG.baseHandAttackSpeed();
            }
        }
        switch (this.ordinal()) {
            case 7: {
                return 1.0;
            }
            case 1: 
            case 2: {
                return 0.5;
            }
            case 3: 
            case 6: 
            case 8: {
                return -0.5;
            }
            case 5: {
                if (tier == class_1834.field_8922) {
                    return -0.5;
                }
                if (tier == class_1834.field_8923) {
                    return 0.5;
                }
                if (tier == class_1834.field_8930 || tier == class_1834.field_8929) {
                    return 1.0;
                }
                if (tier == class_1834.field_22033 || tier.method_8024() >= 4) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    public double getReach() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.reach != null) {
                return configurableWeaponData.reach - 2.5;
            }
        }
        return switch (this.ordinal()) {
            case 1 -> 0.5;
            case 2, 5, 8 -> 1.0;
            default -> 0.0;
        };
    }

    public double getChargedReach() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.chargedReach != null) {
                return configurableWeaponData.chargedReach;
            }
        }
        return 1.0;
    }

    public boolean hasSwordEnchants() {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredWeapons.containsKey((Object)this)) {
            ConfigurableWeaponData configurableWeaponData = Combatify.ITEMS.configuredWeapons.get((Object)this);
            if (configurableWeaponData.hasSwordEnchants != null) {
                return configurableWeaponData.hasSwordEnchants;
            }
        }
        return switch (this.ordinal()) {
            case 1, 2, 3, 7 -> true;
            default -> false;
        };
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static WeaponType fromID(String id) {
        return WeaponType.valueOf(id);
    }

    static {
        BASE_ATTACK_SPEED_CTS_UUID = UUID.fromString("FA233E1C-4110-4865-B01B-901007a318e1");
        BASE_ATTACK_REACH_UUID = UUID.fromString("26cb07a3-209d-4110-8e10-1010243614c8");
    }
}

