/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.Objects;
import java.util.UUID;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.enchantment.CustomEnchantmentHelper;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.LivingEntityExtensions;
import net.atlas.combatify.networking.NetworkingHandler;
import net.atlas.combatify.util.MethodHandler;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_8103;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class}, priority=1400)
public abstract class LivingEntityMixin
extends class_1297
implements LivingEntityExtensions {
    @Unique
    private double piercingNegation;
    @Unique
    class_1309 thisEntity = (class_1309)class_1309.class.cast(this);
    @Shadow
    protected int field_6222;

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    public abstract double method_26825(class_1320 var1);

    @Shadow
    public abstract void method_6105(class_1282 var1, float var2);

    @Shadow
    public abstract int method_6096();

    @ModifyReturnValue(method={"isBlocking"}, at={@At(value="RETURN")})
    public boolean isBlocking(boolean original) {
        return !MethodHandler.getBlockingItem(this.thisEntity).stack().method_7960();
    }

    @Inject(method={"blockedByShield"}, at={@At(value="HEAD")}, cancellable=true)
    public void blockedByShield(class_1309 target, CallbackInfo ci) {
        MethodHandler.tryDisableShield(this.thisEntity, target);
        ci.cancel();
    }

    @Override
    public void setPiercingNegation(double negation) {
        this.piercingNegation = negation;
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    public void addPiercing(class_1282 source, float f, CallbackInfoReturnable<Float> cir) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            if (this.isSourceAnyOf(source, class_8111.field_42320, class_8111.field_42319, class_8111.field_42360)) {
                class_1792 item = livingEntity.method_5998(class_1268.field_5808).method_7909();
                double d = 0.0;
                d += ((ItemExtensions)item).getPiercingLevel();
                if (Combatify.CONFIG.piercer()) {
                    d += (double)CustomEnchantmentHelper.getPierce(livingEntity) * 0.1;
                }
                d -= this.piercingNegation;
                d = Math.max(0.0, d);
                this.piercingNegation = 0.0;
                if (d > 0.0) {
                    cir.setReturnValue((Object)Float.valueOf(this.combatify$getNewDamageAfterArmorAbsorb(source, f, d)));
                }
            }
        }
    }

    @Inject(method={"getDamageAfterMagicAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    public void addPiercing1(class_1282 source, float f, CallbackInfoReturnable<Float> cir) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            if (this.isSourceAnyOf(source, class_8111.field_42320, class_8111.field_42319, class_8111.field_42360)) {
                class_1792 item = livingEntity.method_5998(class_1268.field_5808).method_7909();
                double d = 0.0;
                d += ((ItemExtensions)item).getPiercingLevel();
                if (Combatify.CONFIG.piercer()) {
                    d += (double)CustomEnchantmentHelper.getPierce(livingEntity) * 0.1;
                }
                d -= this.piercingNegation;
                d = Math.max(0.0, d);
                this.piercingNegation = 0.0;
                if (d > 0.0) {
                    cir.setReturnValue((Object)Float.valueOf(MethodHandler.getNewDamageAfterMagicAbsorb(this.thisEntity, source, f, d)));
                }
            }
        }
    }

    @Unique
    @SafeVarargs
    public final boolean isSourceAnyOf(class_1282 source, class_5321<class_8110> ... damageTypes) {
        boolean bl = false;
        for (class_5321<class_8110> damageType : damageTypes) {
            bl |= source.method_49708(damageType);
        }
        return bl;
    }

    @ModifyExpressionValue(method={"handleDamageEvent"}, at={@At(value="CONSTANT", args={"intValue=20"}, ordinal=0)})
    private int syncInvulnerability(int x) {
        return 10;
    }

    @WrapOperation(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z")})
    public boolean shield(class_1309 instance, class_1282 source, Operation<Boolean> original, @Local(ordinal=0) LocalFloatRef amount, @Local(ordinal=1) LocalFloatRef f, @Local(ordinal=2) LocalFloatRef g, @Local(ordinal=0) LocalBooleanRef bl) {
        class_1792 class_17922;
        if (amount.get() > 0.0f && ((Boolean)original.call(new Object[]{instance, source})).booleanValue() && (class_17922 = MethodHandler.getBlockingItem(this.thisEntity).getItem()) instanceof ItemExtensions) {
            ItemExtensions shieldItem = (ItemExtensions)class_17922;
            shieldItem.getBlockingType().block(instance, null, MethodHandler.getBlockingItem(this.thisEntity).stack(), source, amount, f, g, bl);
        }
        return false;
    }

    @ModifyExpressionValue(method={"hurt"}, at={@At(value="CONSTANT", args={"intValue=20"}, ordinal=0)})
    public int changeIFrames(int original, @Local(ordinal=0, argsOnly=true) class_1282 source, @Local(ordinal=0, argsOnly=true) float amount) {
        class_1297 entity2 = source.method_5529();
        int invulnerableTime = original - 10;
        if (entity2 instanceof class_1657) {
            class_1657 player = (class_1657)entity2;
            int base = (int)Math.min(player.method_7279(), (float)invulnerableTime);
            int n = invulnerableTime = base >= 4 ? base - 2 : base;
            if (player.method_26825(class_5134.field_23723) - 1.5 >= 15.0 || Combatify.CONFIG.instaAttack()) {
                invulnerableTime = 5;
            }
        }
        if (source.method_48789(class_8103.field_42247) && !Combatify.CONFIG.projectilesHaveIFrames()) {
            invulnerableTime = 0;
        }
        if (source.method_49708(class_8111.field_42349) && !Combatify.CONFIG.magicHasIFrames()) {
            invulnerableTime = 0;
        }
        return invulnerableTime;
    }

    @Inject(method={"hurt"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;invulnerableTime:I", ordinal=0)})
    public void injectEatingInterruption(class_1282 source, float f, CallbackInfoReturnable<Boolean> cir) {
        if (this.thisEntity.method_6115() && this.thisEntity.method_6030().method_19267() && !source.method_48789(class_8103.field_42246) && !source.method_48789(class_8103.field_42248) && !source.method_48789(class_8103.field_42250) && !source.method_49708(class_8111.field_42343) && Combatify.CONFIG.eatingInterruption()) {
            this.field_6222 = this.thisEntity.method_6030().method_7935();
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                for (UUID playerUUID : Combatify.moddedPlayers) {
                    class_1657 class_16572 = serverLevel.method_18470(playerUUID);
                    if (!(class_16572 instanceof class_3222)) continue;
                    class_3222 serverPlayer = (class_3222)class_16572;
                    ServerPlayNetworking.send((class_3222)serverPlayer, (FabricPacket)new NetworkingHandler.RemainingUseSyncPacket(this.method_5628(), this.field_6222));
                }
            }
        }
    }

    @ModifyExpressionValue(method={"hurt"}, at={@At(value="CONSTANT", args={"floatValue=10.0F"}, ordinal=0)})
    public float changeIFrames(float constant) {
        return constant - 10.0f;
    }

    @WrapOperation(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    public void modifyKB(class_1309 instance, double d, double e, double f, Operation<Void> original, @Local(ordinal=0, argsOnly=true) class_1282 source) {
        if (Combatify.CONFIG.fishingHookKB() && source.method_5526() instanceof class_1536 || !source.method_48789(class_8103.field_42247) && Combatify.CONFIG.midairKB()) {
            MethodHandler.projectileKnockback(this.thisEntity, 0.4, e, f);
        } else {
            MethodHandler.knockback(this.thisEntity, 0.4, e, f);
        }
    }

    @Inject(method={"isDamageSourceBlocked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;")}, cancellable=true)
    public void isDamageSourceBlocked(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        class_243 currentVector = this.method_5828(1.0f);
        if (currentVector.field_1351 > -0.99 && currentVector.field_1351 < 0.99) {
            currentVector = new class_243(currentVector.field_1352, 0.0, currentVector.field_1350).method_1029();
            class_243 sourceVector = Objects.requireNonNull(source.method_5510()).method_1035(this.method_19538());
            sourceVector = new class_243(sourceVector.field_1352, 0.0, sourceVector.field_1350).method_1029();
            cir.setReturnValue((Object)(sourceVector.method_1026(currentVector) * 3.1415927410125732 < -0.8726646304130554 ? 1 : 0));
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Unique
    public float combatify$getNewDamageAfterArmorAbsorb(class_1282 source, float amount, double piercingLevel) {
        if (!source.method_48789(class_8103.field_42241) && piercingLevel < 1.0) {
            this.method_6105(source, (float)((double)amount * (1.0 + piercingLevel)));
            double armourStrength = this.method_6096();
            double toughness = this.method_26825(class_5134.field_23725);
            amount = class_1280.method_5496((float)amount, (float)((float)(armourStrength - armourStrength * piercingLevel)), (float)((float)(toughness - toughness * piercingLevel)));
        }
        return amount;
    }

    @Override
    public boolean combatify$hasEnabledShieldOnCrouch() {
        return true;
    }

    @Override
    public void setUseItemRemaining(int ticks) {
        this.field_6222 = ticks;
    }
}

