/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.Objects;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.extensions.CustomEnchantmentHelper;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.LivingEntityExtensions;
import net.atlas.combatify.extensions.PlayerExtensions;
import net.atlas.combatify.item.NewAttributes;
import net.atlas.combatify.item.TieredShieldItem;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1835;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8150;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class}, priority=1400)
public abstract class PlayerMixin
extends class_1309
implements PlayerExtensions,
LivingEntityExtensions {
    @Unique
    private static final class_2940<Boolean> DATA_PLAYER_USES_SHIELD_CROUCH = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);
    @Unique
    protected int attackStrengthMaxValue;
    @Unique
    public boolean missedAttackRecovery;
    @Unique
    @Final
    public float baseValue = 1.0f;
    @Unique
    float oldDamage;
    @Unique
    float currentAttackReach;
    @Unique
    boolean attacked;
    @Unique
    public final class_1657 player = (class_1657)this;

    public PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract void method_5997(@NotNull class_1309 var1);

    @Shadow
    public abstract float method_7261(float var1);

    @Shadow
    public abstract float method_7279();

    @Shadow
    public abstract void method_7324(class_1297 var1);

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    public void appendShieldOnCrouch(CallbackInfo ci) {
        this.field_6011.method_12784(DATA_PLAYER_USES_SHIELD_CROUCH, (Object)true);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    public void injectSnowballKb(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.oldDamage = amount;
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true)
    public void changeReturn(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        boolean bl;
        boolean bl2 = bl = amount == 0.0f && this.oldDamage <= 0.0f;
        if (bl) {
            cir.setReturnValue((Object)super.method_5643(source, amount));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(class_2487 nbt, CallbackInfo ci) {
        Objects.requireNonNull(this.player.method_5996(NewAttributes.ATTACK_REACH)).method_6192(2.5);
        Objects.requireNonNull(this.player.method_5996(class_5134.field_23721)).method_6192(!Combatify.CONFIG.fistDamage() ? 2.0 : 1.0);
        Objects.requireNonNull(this.player.method_5996(class_5134.field_23723)).method_6192((double)Combatify.CONFIG.baseHandAttackSpeed() + 1.5);
    }

    @ModifyExpressionValue(method={"createAttributes"}, at={@At(value="CONSTANT", args={"doubleValue=1.0"})})
    private static double changeAttack(double constant) {
        return !Combatify.CONFIG.fistDamage() ? 1.0 + constant : constant;
    }

    @ModifyReturnValue(method={"createAttributes"}, at={@At(value="RETURN")})
    private static class_5132.class_5133 createAttributes(class_5132.class_5133 original) {
        return original.method_26867(NewAttributes.ATTACK_REACH).method_26868(class_5134.field_23723, (double)Combatify.CONFIG.baseHandAttackSpeed() + 1.5);
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")})
    public void addServerOnlyCheck(class_1799 itemStack, boolean bl, boolean bl2, CallbackInfoReturnable<class_1542> cir) {
        if (Combatify.unmoddedPlayers.contains(this.player.method_5667())) {
            Combatify.isPlayerAttacking.put(this.player.method_5667(), false);
        }
    }

    @ModifyExpressionValue(method={"hurtCurrentlyUsedShield"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z")})
    public boolean hurtCurrentlyUsedShield(boolean original) {
        return !((ItemExtensions)this.field_6277.method_7909()).getBlockingType().isEmpty() || original;
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isSameItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    public boolean redirectDurability(boolean original) {
        return true;
    }

    @Inject(method={"blockUsingShield"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;canDisableShield()Z")}, cancellable=true)
    public void blockUsingShield(@NotNull class_1309 attacker, CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public boolean ctsShieldDisable(float damage, class_1792 item) {
        this.player.method_7357().method_7906(item, (int)(damage * 20.0f));
        if (item instanceof TieredShieldItem) {
            for (TieredShieldItem tieredShieldItem : Combatify.shields) {
                if (item == tieredShieldItem) continue;
                this.player.method_7357().method_7906((class_1792)tieredShieldItem, (int)(damage * 20.0f));
            }
        }
        this.player.method_6021();
        this.player.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
        return true;
    }

    @Override
    public boolean combatify$hasEnabledShieldOnCrouch() {
        return (Boolean)this.field_6011.method_12789(DATA_PLAYER_USES_SHIELD_CROUCH);
    }

    @Override
    public void combatify$setShieldOnCrouch(boolean hasShieldOnCrouch) {
        this.field_6011.method_12778(DATA_PLAYER_USES_SHIELD_CROUCH, (Object)hasShieldOnCrouch);
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void attack(class_1297 target, CallbackInfo ci) {
        if (!this.combatify$isAttackAvailable(this.baseValue)) {
            ci.cancel();
        }
    }

    @Inject(method={"attack"}, at={@At(value="TAIL")})
    public void resetTicker(class_1297 target, CallbackInfo ci) {
        if (this.attacked) {
            boolean isMiscTarget = target.method_5864().equals(class_1299.field_6110) || target.method_5864().equals(class_1299.field_6043) || target.method_5864().equals(class_1299.field_28401) || target.method_5864().equals(class_1299.field_6120) || target instanceof class_1531 || target instanceof class_1690 || target instanceof class_1688 || target instanceof class_8150;
            this.combatify$resetAttackStrengthTicker(!Combatify.CONFIG.improvedMiscEntityAttacks() || !isMiscTarget);
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)})
    public void doThings(class_1297 target, CallbackInfo ci, @Local(ordinal=0) LocalFloatRef attackDamage, @Local(ordinal=1) LocalFloatRef attackDamageBonus) {
        boolean bl;
        this.attacked = true;
        class_1309 livingEntity = target instanceof class_1309 ? (class_1309)target : null;
        boolean bl2 = bl = livingEntity != null;
        if (this.player.method_5998(class_1268.field_5808).method_7909() instanceof class_1835 && bl) {
            attackDamageBonus.set(CustomEnchantmentHelper.getDamageBonus(this.player.method_6047(), livingEntity));
        }
        attackDamage.set((float)MethodHandler.calculateValue(this.player.method_5996(class_5134.field_23721), attackDamageBonus.get()));
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F", ordinal=0)})
    public float redirectStrengthCheck(float original) {
        this.currentAttackReach = (float)MethodHandler.getCurrentAttackReach(this.player, 1.0f);
        return 1.0f;
    }

    @Inject(method={"resetAttackStrengthTicker"}, at={@At(value="HEAD")}, cancellable=true)
    public void reset(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"attack"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Player;walkDist:F")})
    public void injectCrit(class_1297 target, CallbackInfo ci, @Local(ordinal=0) LocalFloatRef attackDamage, @Local(ordinal=1) float attackDamageBonus, @Local(ordinal=2) LocalBooleanRef bl3) {
        boolean isCrit;
        attackDamage.set(attackDamage.get() - attackDamageBonus);
        if (bl3.get()) {
            attackDamage.set(attackDamage.get() / 1.5f);
        }
        boolean bl = isCrit = this.player.field_6017 > 0.0f && !this.player.method_24828() && !this.player.method_6101() && !this.player.method_5799() && !this.player.method_6059(class_1294.field_5919) && !this.player.method_5765() && target instanceof class_1309;
        if (!Combatify.CONFIG.sprintCritsEnabled()) {
            isCrit &= !this.method_5624();
        }
        bl3.set(isCrit);
        if (isCrit) {
            attackDamage.set(attackDamage.get() * 1.5f);
        }
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    public void knockback(class_1309 instance, double d, double e, double f, Operation<Void> original) {
        MethodHandler.knockback(instance, d, e, f);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    public void createSweep(class_1297 target, CallbackInfo ci, @Local(ordinal=1) boolean bl2, @Local(ordinal=2) boolean bl3, @Local(ordinal=3) LocalBooleanRef bl4, @Local(ordinal=5) boolean bl6, @Local(ordinal=0) float attackDamage, @Local(ordinal=0) double d, @Share(value="wasSweep") LocalBooleanRef wasSweep) {
        if (!bl3 && !bl2 && this.method_24828() && d < (double)this.method_6029() && this.checkSweepAttack()) {
            if (bl6) {
                class_238 box = target.method_5829().method_1009(1.0, 0.25, 1.0);
                MethodHandler.sweepAttack(this.player, box, (float)MethodHandler.getCurrentAttackReach(this.player, 1.0f), attackDamage, target);
            }
            wasSweep.set(true);
        }
    }

    @ModifyExpressionValue(method={"attack"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="bl4", local={@Local(type=boolean.class, ordinal=3)})
    @Expression(value={"bl4 != false"})
    public boolean resweep(boolean original) {
        if (Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) {
            return original;
        }
        return false;
    }

    @Override
    public void combatify$attackAir() {
        if (this.combatify$isAttackAvailable(this.baseValue)) {
            this.combatify$customSwing(class_1268.field_5808);
            float attackDamage = (float)Objects.requireNonNull(this.player.method_5996(class_5134.field_23721)).method_6194();
            if (attackDamage > 0.0f && this.checkSweepAttack()) {
                float reach = (float)MethodHandler.getCurrentAttackReach(this.player, 1.0f);
                double var5 = (double)(-class_3532.method_15374((float)(this.player.field_6283 * ((float)Math.PI / 180)))) * 2.0;
                double var7 = (double)class_3532.method_15362((float)(this.player.field_6283 * ((float)Math.PI / 180))) * 2.0;
                class_238 box = this.player.method_5829().method_1009(1.0, 0.25, 1.0).method_989(var5, 0.0, var7);
                MethodHandler.sweepAttack(this.player, box, reach, attackDamage, null);
            }
            this.combatify$resetAttackStrengthTicker(false);
        }
    }

    @Override
    public void combatify$customSwing(class_1268 interactionHand) {
        this.method_23667(interactionHand, false);
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit) {
        this.resetAttackStrengthTicker(hit, false, class_1657::method_7350);
    }

    @Override
    public void combatify$resetAttackStrengthTicker(boolean hit, boolean force) {
        this.resetAttackStrengthTicker(hit, force, class_1657::method_7350);
    }

    @Unique
    public void resetAttackStrengthTicker(boolean hit, boolean force, Consumer<class_1657> vanillaReset) {
        boolean bl = this.missedAttackRecovery = !hit;
        if (!Combatify.CONFIG.attackSpeed() && this.method_26825(class_5134.field_23723) - 1.5 >= 20.0 || Combatify.CONFIG.instaAttack()) {
            return;
        }
        int chargeTicks = (int)this.method_7279() * 2;
        if (force || chargeTicks > this.attackStrengthMaxValue - this.field_6273) {
            Combatify.LOGGER.info("Ticks for charge: " + chargeTicks);
            this.attackStrengthMaxValue = chargeTicks;
            this.field_6273 = 0;
        }
    }

    @ModifyExpressionValue(method={"getCurrentItemAttackStrengthDelay"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/world/entity/ai/attributes/Attribute;)D")})
    public double modifyAttackSpeed(double original, @Share(value="hasVanilla") LocalBooleanRef hasVanilla) {
        hasVanilla.set((this.method_5996(class_5134.field_23723).method_6199(class_1792.field_8001) != null || Combatify.getState().equals((Object)Combatify.CombatifyState.VANILLA)) && !Combatify.getState().equals((Object)Combatify.CombatifyState.CTS_8C));
        double mod = 1.5;
        double speed = original - mod;
        if (hasVanilla.get() || speed <= 0.0) {
            speed += mod;
        }
        return class_3532.method_15350((double)speed, (double)0.1, (double)1024.0);
    }

    @ModifyReturnValue(method={"getCurrentItemAttackStrengthDelay"}, at={@At(value="RETURN")})
    public float modifyAttackTicks(float original, @Share(value="hasVanilla") LocalBooleanRef hasVanilla) {
        return hasVanilla.get() ? original : (float)Math.round(original);
    }

    @ModifyExpressionValue(method={"getAttackStrengthScale"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getCurrentItemAttackStrengthDelay()F")})
    public float modifyMaxCharge(float original) {
        return this.attackStrengthMaxValue;
    }

    @ModifyReturnValue(method={"getAttackStrengthScale"}, at={@At(value="RETURN")})
    public float modifyAttackStrengthScale(float original) {
        float charge = 2.0f;
        if (this.attackStrengthMaxValue == 0) {
            return charge;
        }
        return charge * original;
    }

    @Override
    public boolean combatify$isAttackAvailable(float baseTime) {
        if (this.method_7261(baseTime) < 1.0f) {
            return this.missedAttackRecovery && (float)this.field_6273 + baseTime > 4.0f;
        }
        return true;
    }

    @Unique
    protected boolean checkSweepAttack() {
        return this.method_7261(this.baseValue) > 1.95f && class_1890.method_8217((class_1309)this.player) > 0.0f;
    }

    @Override
    public boolean combatify$getMissedAttackRecovery() {
        return this.missedAttackRecovery;
    }
}

