/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.mixin;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.extensions.PlayerExtensions;
import net.atlas.combatify.extensions.ServerPlayerExtensions;
import net.atlas.combatify.mixin.PlayerMixin;
import net.atlas.combatify.util.CombatUtil;
import net.atlas.combatify.util.HitResultRotationEntry;
import net.atlas.combatify.util.MethodHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_6373;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends PlayerMixin
implements ServerPlayerExtensions {
    @Unique
    private boolean retainAttack;
    @Shadow
    public class_3244 field_13987;
    @Unique
    public CopyOnWriteArrayList<HitResultRotationEntry> oldHitResults = new CopyOnWriteArrayList();
    @Unique
    public IntList pastPings = new IntArrayList(5);
    @Unique
    public boolean awaitingResponse = false;
    @Unique
    public int responseTimer = 0;
    @Unique
    public int tickTimer = 4;
    @Unique
    public int currentAveragePing = 0;
    @Unique
    public final class_3222 player = (class_3222)class_3222.class.cast(this);
    @Unique
    public boolean shouldInit = true;

    @Shadow
    public abstract class_1297 method_14242();

    @Shadow
    public abstract void method_6104(class_1268 var1);

    public ServerPlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void hitreg(CallbackInfo ci) {
        CombatUtil.setPosition((class_3222)this);
        if (this.shouldInit && Combatify.unmoddedPlayers.contains(this.method_5667())) {
            Combatify.scheduleHitResult.get(this.method_5667()).schedule(new TimerTask(){

                @Override
                public void run() {
                    class_1297 camera = ServerPlayerMixin.this.method_14242();
                    if (camera != null) {
                        ServerPlayerMixin.this.adjustHitResults(MethodHandler.pickResult((class_1657)ServerPlayerMixin.this.player, camera));
                    }
                }
            }, 0L, 5L);
            this.shouldInit = false;
        }
        ++this.tickTimer;
        if (this.tickTimer >= 5 && Combatify.unmoddedPlayers.contains(this.method_5667()) && !this.awaitingResponse) {
            this.tickTimer = 0;
            this.field_13987.method_14364((class_2596)new class_6373(3492));
            this.awaitingResponse = true;
        }
        if (((PlayerExtensions)this.player).combatify$isAttackAvailable(-1.0f) && this.retainAttack && Combatify.unmoddedPlayers.contains(this.method_5667())) {
            this.retainAttack = false;
            this.method_6104(class_1268.field_5808);
        }
    }

    @Inject(method={"swing"}, at={@At(value="HEAD")}, cancellable=true)
    public void removeReset(class_1268 hand, CallbackInfo ci) {
        super.method_6104(hand);
        if (Combatify.unmoddedPlayers.contains(this.method_5667())) {
            if (Combatify.isPlayerAttacking.get(this.method_5667()).booleanValue()) {
                this.getPresentResult();
                float xRot = this.method_36455();
                float yRot = this.method_5791();
                class_239 hitResult = this.oldHitResults.stream().filter(hitResultRotEntry -> hitResultRotEntry.shouldAccept(xRot, yRot)).min((firstResultRotEntry, secondResultRotEntry) -> firstResultRotEntry.compareTo((HitResultRotationEntry)secondResultRotEntry, xRot, yRot)).map(HitResultRotationEntry::hitResult).orElse(null);
                if (hitResult != null) {
                    Combatify.finalizingAttack.put(this.method_5667(), false);
                    switch (hitResult.method_17783()) {
                        case field_1331: {
                            if (hitResult instanceof class_3966) {
                                class_1297 entity = ((class_3966)hitResult).method_17782();
                                this.handleInteract(entity, true);
                            }
                        }
                        case field_1333: {
                            this.handleInteract((class_1297)this.player, false);
                        }
                    }
                }
            }
            Combatify.finalizingAttack.put(this.method_5667(), true);
            Combatify.isPlayerAttacking.put(this.method_5667(), true);
        }
        ci.cancel();
    }

    @Unique
    public void handleInteract(class_1297 entity, boolean hit) {
        if (this.retainAttack) {
            if (hit) {
                this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14914, this.method_5634(), 1.0f, 1.0f);
            }
            return;
        }
        if (!this.combatify$isAttackAvailable(0.0f)) {
            float var1 = this.player.method_7261(0.0f);
            if (var1 < 0.8f) {
                if (hit) {
                    this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14914, this.method_5634(), 1.0f, 1.0f);
                }
                this.combatify$resetAttackStrengthTicker(!this.combatify$getMissedAttackRecovery());
                return;
            }
            if (var1 < 1.0f) {
                this.retainAttack = true;
                return;
            }
        }
        class_3218 serverLevel = this.player.method_51469();
        this.player.method_14234();
        if (entity != null) {
            if (!serverLevel.method_8621().method_11952(entity.method_24515())) {
                return;
            }
            double d = MethodHandler.getCurrentAttackReach((class_1657)this.player, 1.0f) + 1.0;
            d *= d;
            class_238 aABB = entity.method_5829();
            class_243 eyePos = this.player.method_5836(0.0f);
            double dist = eyePos.method_1025(MethodHandler.getNearestPointTo(aABB, eyePos));
            if (entity instanceof class_3222) {
                class_3222 target = (class_3222)entity;
                dist = CombatUtil.allowReach(this.player, target) ? 0.0 : 2.147483647E9;
            }
            if (dist < d) {
                if (hit) {
                    if (!(entity instanceof class_1542 || entity instanceof class_1303 || entity instanceof class_1665 || entity == this.player)) {
                        class_1799 itemStack = this.player.method_5998(class_1268.field_5808);
                        if (itemStack.method_45435(serverLevel.method_45162())) {
                            this.player.method_7324(entity);
                        }
                    } else {
                        this.player.field_13987.method_14367((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.invalid_entity_attacked"));
                        class_3244.field_14121.warn("Player {} tried to attack an invalid entity", (Object)this.player.method_5477().getString());
                    }
                } else {
                    this.combatify$attackAir();
                }
            }
        }
    }

    @Override
    public void adjustHitResults(class_239 newValue) {
        if (this.awaitingResponse) {
            ++this.responseTimer;
        }
        if (!this.awaitingResponse && this.responseTimer > 0) {
            int newPing = class_3532.method_15384((double)((double)this.responseTimer * 0.5));
            this.pastPings.add(0, newPing);
            int removed = this.pastPings.removeInt(this.pastPings.size() - 1);
            this.responseTimer = 0;
            this.currentAveragePing = this.currentAveragePing - removed / 5 + newPing / 5;
        }
        HitResultRotationEntry newEntry = new HitResultRotationEntry(newValue, this.method_36455(), this.method_5791());
        if (this.oldHitResults.size() > 1) {
            this.oldHitResults.add(1, newEntry);
        } else {
            this.oldHitResults.add(newEntry);
        }
        int currentPing = class_3532.method_15340((int)(this.currentAveragePing + 1), (int)25, (int)200) / 5;
        this.oldHitResults.removeIf(hitResult -> this.oldHitResults.indexOf(hitResult) >= currentPing);
    }

    @Override
    public void setAwaitingResponse(boolean awaitingResponse) {
        this.awaitingResponse = awaitingResponse;
    }

    @Override
    public boolean isAwaitingResponse() {
        return this.awaitingResponse;
    }

    @Override
    public CopyOnWriteArrayList<HitResultRotationEntry> getOldHitResults() {
        return this.oldHitResults;
    }

    @Override
    public boolean isRetainingAttack() {
        return this.retainAttack;
    }

    @Override
    public void setRetainAttack(boolean retain) {
        this.retainAttack = retain;
    }

    @Override
    public void getPresentResult() {
        class_1297 camera = this.method_14242();
        if (camera != null) {
            this.oldHitResults.set(0, new HitResultRotationEntry(MethodHandler.pickResult((class_1657)this.player, camera), this.method_36455(), this.method_5791()));
        }
    }
}

