/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.networking;

import io.wispforest.owo.config.ConfigSynchronizer;
import java.util.List;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.AtlasConfig;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.ItemConfig;
import net.atlas.combatify.extensions.ConfigSyncBase;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.LivingEntityExtensions;
import net.atlas.combatify.networking.NetworkingHandler;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public class ClientNetworkingHandler {
    private ClientNetworkingHandler() {
    }

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(NetworkingHandler.AtlasConfigPacket.TYPE, (packet, player, responseSender) -> packet.config().handleExtraSync((NetworkingHandler.AtlasConfigPacket)packet, player, responseSender));
        ClientPlayNetworking.registerGlobalReceiver(NetworkingHandler.RemainingUseSyncPacket.TYPE, (packet, player, responseSender) -> {
            class_1297 entity = class_310.method_1551().field_1687.method_8469(packet.id());
            if (entity instanceof LivingEntityExtensions) {
                LivingEntityExtensions livingEntity = (LivingEntityExtensions)entity;
                livingEntity.setUseItemRemaining(packet.ticks());
            }
        });
        ClientPlayConnectionEvents.JOIN.register(Combatify.modDetectionNetworkChannel, (handler, sender, client) -> {
            if (!ClientPlayNetworking.canSend((class_2960)Combatify.modDetectionNetworkChannel)) {
                Combatify.ITEMS.reloadFromDefault();
                ConfigSynchronizer configSynchronizer = new ConfigSynchronizer();
                ((ConfigSyncBase)configSynchronizer).applyDefault();
            }
        });
        ClientLifecycleEvents.CLIENT_STARTED.register(Combatify.modDetectionNetworkChannel, client -> {
            Combatify.ITEMS = new ItemConfig();
            List items = class_7923.field_41178.method_10220().toList();
            for (class_1792 item : items) {
                ((ItemExtensions)item).modifyAttributeModifiers();
            }
            for (class_1792 item : Combatify.ITEMS.configuredItems.keySet()) {
                ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
                if (configurableItemData.stackSize == null) continue;
                ((ItemExtensions)item).setStackSize(configurableItemData.stackSize);
            }
            Combatify.LOGGER.info("Loaded items config.");
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> AtlasConfig.configs.forEach((resourceLocation, atlasConfig) -> atlasConfig.load()));
    }
}

