/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.networking;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.AtlasConfig;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.config.ItemConfig;
import net.atlas.combatify.extensions.ClientInformationHolder;
import net.atlas.combatify.extensions.ItemExtensions;
import net.atlas.combatify.extensions.PlayerExtensions;
import net.atlas.combatify.extensions.ServerPlayerExtensions;
import net.atlas.combatify.extensions.Tierable;
import net.atlas.combatify.item.NewAttributes;
import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.util.HitResultRotationEntry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_239;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class NetworkingHandler {
    public NetworkingHandler() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Combatify.modDetectionNetworkChannel, (server, player, handler, buf, responseSender) -> {});
        ServerPlayConnectionEvents.DISCONNECT.register(Combatify.modDetectionNetworkChannel, (handler, server) -> {
            if (Combatify.unmoddedPlayers.contains(handler.field_14140.method_5667())) {
                Timer timer = Combatify.scheduleHitResult.get(handler.method_32311().method_5667());
                timer.cancel();
                timer.purge();
                Combatify.unmoddedPlayers.remove(handler.field_14140.method_5667());
                Combatify.isPlayerAttacking.remove(handler.field_14140.method_5667());
                Combatify.finalizingAttack.remove(handler.field_14140.method_5667());
            }
            Combatify.moddedPlayers.remove(handler.field_14140.method_5667());
        });
        ServerPlayNetworking.registerGlobalReceiver(ServerboundMissPacket.TYPE, (packet, player, responseSender) -> {
            class_3218 serverLevel = player.method_51469();
            player.method_14234();
            if (!serverLevel.method_8621().method_11952(player.method_24515())) {
                return;
            }
            ((PlayerExtensions)player).combatify$attackAir();
        });
        ServerPlayNetworking.registerGlobalReceiver(ServerboundClientInformationExtensionPacket.TYPE, (payload, player, responseSender) -> ((ClientInformationHolder)player).combatify$setShieldOnCrouch(payload.useShieldOnCrouch));
        ServerPlayConnectionEvents.JOIN.register(Combatify.modDetectionNetworkChannel, (handler, sender, server) -> {
            boolean bl;
            boolean bl2 = bl = Combatify.CONFIG.configOnlyWeapons() || Combatify.CONFIG.defender() || Combatify.CONFIG.piercer() || !Combatify.CONFIG.letVanillaConnect();
            if (!ServerPlayNetworking.canSend((class_3222)handler.field_14140, AtlasConfigPacket.TYPE)) {
                if (bl) {
                    handler.field_14140.field_13987.method_14367((class_2561)class_2561.method_43470((String)"Combatify needs to be installed on the client to join this server!"));
                    return;
                }
                Combatify.unmoddedPlayers.add(handler.field_14140.method_5667());
                Combatify.isPlayerAttacking.put(handler.field_14140.method_5667(), true);
                Combatify.finalizingAttack.put(handler.field_14140.method_5667(), true);
                Combatify.scheduleHitResult.put(handler.field_14140.method_5667(), new Timer());
                Combatify.LOGGER.info("Unmodded player joined: " + String.valueOf(handler.field_14140.method_5667()));
                return;
            }
            Combatify.moddedPlayers.add(handler.field_14140.method_5667());
            for (AtlasConfig atlasConfig : AtlasConfig.configs.values()) {
                ServerPlayNetworking.send((class_3222)handler.field_14140, (FabricPacket)new AtlasConfigPacket(atlasConfig));
            }
            Combatify.LOGGER.info("Config packet sent to client.");
        });
        ModifyItemAttributeModifiersCallback.EVENT.register(Combatify.modDetectionNetworkChannel, (stack, slot, attributeModifiers) -> {
            class_1792 item = stack.method_7909();
            if (Combatify.ITEMS.configuredItems.containsKey(item) && slot == class_1304.field_6173) {
                List modifiers;
                ArrayList<Integer> indexes;
                ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
                if (configurableItemData.type != null) {
                    class_1834 class_18342;
                    if (attributeModifiers.containsKey((Object)class_5134.field_23721)) {
                        indexes = new ArrayList<Integer>();
                        modifiers = attributeModifiers.get((Object)class_5134.field_23721).stream().toList();
                        for (class_1322 modifier : modifiers) {
                            if (modifier.method_6189() != class_1792.field_8006) continue;
                            indexes.add(modifiers.indexOf(modifier));
                        }
                        if (!indexes.isEmpty()) {
                            for (Integer index : indexes) {
                                attributeModifiers.remove((Object)class_5134.field_23721, modifiers.get(index));
                            }
                        }
                    }
                    if (attributeModifiers.containsKey((Object)class_5134.field_23723)) {
                        indexes = new ArrayList();
                        modifiers = attributeModifiers.get((Object)class_5134.field_23723).stream().toList();
                        for (class_1322 modifier : modifiers) {
                            if (modifier.method_6189() != class_1792.field_8001 && modifier.method_6189() != WeaponType.BASE_ATTACK_SPEED_CTS_UUID) continue;
                            indexes.add(modifiers.indexOf(modifier));
                        }
                        if (!indexes.isEmpty()) {
                            for (Integer index : indexes) {
                                attributeModifiers.remove((Object)class_5134.field_23723, modifiers.get(index));
                            }
                        }
                    }
                    if (attributeModifiers.containsKey((Object)NewAttributes.ATTACK_REACH)) {
                        indexes = new ArrayList();
                        modifiers = attributeModifiers.get((Object)NewAttributes.ATTACK_REACH).stream().toList();
                        for (class_1322 modifier : modifiers) {
                            if (modifier.method_6189() != WeaponType.BASE_ATTACK_REACH_UUID) continue;
                            indexes.add(modifiers.indexOf(modifier));
                        }
                        if (!indexes.isEmpty()) {
                            for (Integer index : indexes) {
                                attributeModifiers.remove((Object)NewAttributes.ATTACK_REACH, modifiers.get(index));
                            }
                        }
                    }
                    ArrayListMultimap modMap = ArrayListMultimap.create();
                    WeaponType weaponType = configurableItemData.type;
                    if (item instanceof class_1831) {
                        class_1831 tieredItem = (class_1831)item;
                        class_18342 = tieredItem.method_8022();
                    } else if (item instanceof Tierable) {
                        Tierable tierable = (Tierable)item;
                        class_18342 = tierable.getTier();
                    } else {
                        class_18342 = class_1834.field_22033;
                    }
                    weaponType.addCombatAttributes((class_1832)class_18342, (ArrayListMultimap<class_1320, class_1322>)modMap);
                    attributeModifiers.putAll((Multimap)modMap);
                }
                if (configurableItemData.damage != null) {
                    if (attributeModifiers.containsKey((Object)class_5134.field_23721)) {
                        indexes = new ArrayList();
                        modifiers = attributeModifiers.get((Object)class_5134.field_23721).stream().toList();
                        for (class_1322 modifier : modifiers) {
                            if (modifier.method_6189() != class_1792.field_8006) continue;
                            indexes.add(modifiers.indexOf(modifier));
                        }
                        if (!indexes.isEmpty()) {
                            for (Integer index : indexes) {
                                attributeModifiers.remove((Object)class_5134.field_23721, modifiers.get(index));
                            }
                        }
                    }
                    attributeModifiers.put((Object)class_5134.field_23721, (Object)new class_1322(class_1792.field_8006, "Config modifier", configurableItemData.damage - (double)(Combatify.CONFIG.fistDamage() ? 1 : 2), class_1322.class_1323.field_6328));
                }
                if (configurableItemData.speed != null) {
                    if (attributeModifiers.containsKey((Object)class_5134.field_23723)) {
                        indexes = new ArrayList();
                        modifiers = attributeModifiers.get((Object)class_5134.field_23723).stream().toList();
                        for (class_1322 modifier : modifiers) {
                            if (modifier.method_6189() != class_1792.field_8001 && modifier.method_6189() != WeaponType.BASE_ATTACK_SPEED_CTS_UUID) continue;
                            indexes.add(modifiers.indexOf(modifier));
                        }
                        if (!indexes.isEmpty()) {
                            for (Integer index : indexes) {
                                attributeModifiers.remove((Object)class_5134.field_23723, modifiers.get(index));
                            }
                        }
                    }
                    attributeModifiers.put((Object)class_5134.field_23723, (Object)new class_1322(WeaponType.BASE_ATTACK_SPEED_CTS_UUID, "Config modifier", configurableItemData.speed - (double)Combatify.CONFIG.baseHandAttackSpeed(), class_1322.class_1323.field_6328));
                }
                if (configurableItemData.reach != null) {
                    if (attributeModifiers.containsKey((Object)NewAttributes.ATTACK_REACH)) {
                        indexes = new ArrayList();
                        modifiers = attributeModifiers.get((Object)NewAttributes.ATTACK_REACH).stream().toList();
                        for (class_1322 modifier : modifiers) {
                            if (modifier.method_6189() != WeaponType.BASE_ATTACK_REACH_UUID) continue;
                            indexes.add(modifiers.indexOf(modifier));
                        }
                        if (!indexes.isEmpty()) {
                            for (Integer index : indexes) {
                                attributeModifiers.remove((Object)NewAttributes.ATTACK_REACH, modifiers.get(index));
                            }
                        }
                    }
                    attributeModifiers.put((Object)NewAttributes.ATTACK_REACH, (Object)new class_1322(WeaponType.BASE_ATTACK_REACH_UUID, "Config modifier", configurableItemData.reach - 2.5, class_1322.class_1323.field_6328));
                }
            }
        });
        AttackBlockCallback.EVENT.register(Combatify.modDetectionNetworkChannel, (player, world, hand, pos, direction) -> {
            if (Combatify.unmoddedPlayers.contains(player.method_5667()) && Combatify.finalizingAttack.get(player.method_5667()).booleanValue() && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ((ServerPlayerExtensions)serverPlayer).getPresentResult();
                float xRot = serverPlayer.method_36455();
                float yRot = serverPlayer.method_5791();
                class_239 hitResult = ((ServerPlayerExtensions)serverPlayer).getOldHitResults().stream().filter(hitResultRotEntry -> hitResultRotEntry.shouldAccept(xRot, yRot)).min((firstResultRotEntry, secondResultRotEntry) -> firstResultRotEntry.compareTo((HitResultRotationEntry)secondResultRotEntry, xRot, yRot)).map(HitResultRotationEntry::hitResult).orElse(null);
                if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1331) {
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register(Combatify.modDetectionNetworkChannel, (player, world, hand, hitResult) -> {
            if (Combatify.unmoddedPlayers.contains(player.method_5667())) {
                Combatify.isPlayerAttacking.put(player.method_5667(), false);
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register(Combatify.modDetectionNetworkChannel, (player, world, hand, entity, hitResult) -> {
            if (Combatify.unmoddedPlayers.contains(player.method_5667())) {
                Combatify.isPlayerAttacking.put(player.method_5667(), false);
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register(Combatify.modDetectionNetworkChannel, (player, world, hand) -> {
            if (Combatify.unmoddedPlayers.contains(player.method_5667())) {
                Combatify.isPlayerAttacking.put(player.method_5667(), false);
            }
            return class_1271.method_22430((Object)player.method_5998(hand));
        });
        ServerLifecycleEvents.SERVER_STARTED.register(Combatify.modDetectionNetworkChannel, server -> {
            Combatify.ITEMS = new ItemConfig();
            List items = class_7923.field_41178.method_10220().toList();
            for (class_1792 item : items) {
                ((ItemExtensions)item).modifyAttributeModifiers();
            }
            for (class_1792 item : Combatify.ITEMS.configuredItems.keySet()) {
                ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(item);
                if (configurableItemData.stackSize == null) continue;
                ((ItemExtensions)item).setStackSize(configurableItemData.stackSize);
            }
        });
    }

    public record ServerboundMissPacket() implements FabricPacket
    {
        public static final PacketType<ServerboundMissPacket> TYPE = PacketType.create((class_2960)Combatify.id("miss_attack"), ServerboundMissPacket::new);

        public ServerboundMissPacket(class_2540 buf) {
            this();
        }

        public void write(class_2540 buf) {
        }

        public PacketType<?> getType() {
            return TYPE;
        }
    }

    public record ServerboundClientInformationExtensionPacket(boolean useShieldOnCrouch) implements FabricPacket
    {
        public static final PacketType<ServerboundClientInformationExtensionPacket> TYPE = PacketType.create((class_2960)Combatify.id("client_extras"), ServerboundClientInformationExtensionPacket::new);

        public ServerboundClientInformationExtensionPacket(class_2540 buf) {
            this(buf.readBoolean());
        }

        public void write(class_2540 buf) {
            buf.writeBoolean(this.useShieldOnCrouch);
        }

        @NotNull
        public PacketType<?> getType() {
            return TYPE;
        }
    }

    public record AtlasConfigPacket(AtlasConfig config) implements FabricPacket
    {
        public static final PacketType<AtlasConfigPacket> TYPE = PacketType.create((class_2960)Combatify.id("atlas_config"), AtlasConfigPacket::new);

        public AtlasConfigPacket(class_2540 buf) {
            this(AtlasConfig.staticLoadFromNetwork(buf));
        }

        public void write(class_2540 buf) {
            buf.method_10812(this.config.name);
            this.config.saveToNetwork(buf);
        }

        public PacketType<?> getType() {
            return TYPE;
        }
    }

    public record RemainingUseSyncPacket(int id, int ticks) implements FabricPacket
    {
        public static final PacketType<RemainingUseSyncPacket> TYPE = PacketType.create((class_2960)Combatify.id("remaining_use_ticks"), RemainingUseSyncPacket::new);

        public RemainingUseSyncPacket(class_2540 buf) {
            this(buf.method_10816(), buf.readInt());
        }

        public void write(class_2540 buf) {
            buf.method_10804(this.id);
            buf.writeInt(this.ticks);
        }

        public PacketType<?> getType() {
            return TYPE;
        }
    }
}

