/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.util;

import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import java.util.Objects;
import java.util.function.Consumer;
import net.atlas.combatify.Combatify;
import net.atlas.combatify.config.ConfigurableItemData;
import net.atlas.combatify.enchantment.DefendingEnchantment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockingType {
    private final String name;
    private boolean canBeDisabled = true;
    private boolean canCrouchBlock = true;
    private boolean isToolBlocker = false;
    private boolean canBlockHit = false;
    private boolean requiresSwordBlocking = false;
    private boolean requireFullCharge = true;
    private boolean defaultKbMechanics = true;

    public int getDefenderBonus(class_1799 stack) {
        return class_1890.method_8225((class_1887)DefendingEnchantment.DEFENDER, (class_1799)stack);
    }

    public Float getShieldBlockBaseConfig(class_1799 stack) {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(stack.method_7909())) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(stack.method_7909());
            if (configurableItemData.blockBase != null) {
                int extra = 0;
                if (Combatify.CONFIG.defender()) {
                    extra += this.getDefenderBonus(stack);
                }
                return Float.valueOf(configurableItemData.blockBase.floatValue() + (float)extra);
            }
        }
        return null;
    }

    public Float getShieldBlockFactorConfig(class_1799 stack) {
        if (Combatify.ITEMS != null && Combatify.ITEMS.configuredItems.containsKey(stack.method_7909())) {
            ConfigurableItemData configurableItemData = Combatify.ITEMS.configuredItems.get(stack.method_7909());
            if (configurableItemData.blockFactor != null) {
                return Float.valueOf(configurableItemData.blockFactor.floatValue() / 100.0f);
            }
        }
        return null;
    }

    public boolean canCrouchBlock() {
        return this.canCrouchBlock;
    }

    public BlockingType setCrouchable(boolean crouchable) {
        this.canCrouchBlock = crouchable;
        return this;
    }

    public boolean canBlockHit() {
        return this.canBlockHit;
    }

    public BlockingType setBlockHit(boolean blockHit) {
        this.canBlockHit = blockHit;
        return this;
    }

    public boolean isToolBlocker() {
        return this.isToolBlocker;
    }

    public BlockingType setToolBlocker(boolean isTool) {
        this.isToolBlocker = isTool;
        return this;
    }

    public boolean canBeDisabled() {
        return this.canBeDisabled;
    }

    public BlockingType setDisablement(boolean canDisable) {
        this.canBeDisabled = canDisable;
        return this;
    }

    public boolean requireFullCharge() {
        return this.requireFullCharge;
    }

    public BlockingType setRequireFullCharge(boolean needsFullCharge) {
        this.requireFullCharge = needsFullCharge;
        return this;
    }

    public boolean defaultKbMechanics() {
        return this.defaultKbMechanics;
    }

    public BlockingType setKbMechanics(boolean defaultKbMechanics) {
        this.defaultKbMechanics = defaultKbMechanics;
        return this;
    }

    public boolean requiresSwordBlocking() {
        return this.requiresSwordBlocking;
    }

    public BlockingType setSwordBlocking(boolean requiresSwordBlocking) {
        this.requiresSwordBlocking = requiresSwordBlocking;
        return this;
    }

    public BlockingType(String name) {
        this.name = name;
    }

    public boolean isEmpty() {
        return this == Combatify.EMPTY;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockingType)) {
            return false;
        }
        BlockingType that = (BlockingType)o;
        return this.canBeDisabled == that.canBeDisabled && this.canCrouchBlock == that.canCrouchBlock && this.isToolBlocker() == that.isToolBlocker() && this.canBlockHit == that.canBlockHit && this.requiresSwordBlocking == that.requiresSwordBlocking && this.requireFullCharge == that.requireFullCharge && this.defaultKbMechanics == that.defaultKbMechanics && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.canBeDisabled, this.canCrouchBlock, this.isToolBlocker(), this.canBlockHit, this.requiresSwordBlocking, this.requireFullCharge, this.defaultKbMechanics);
    }

    public abstract void block(class_1309 var1, @Nullable class_1297 var2, class_1799 var3, class_1282 var4, LocalFloatRef var5, LocalFloatRef var6, LocalFloatRef var7, LocalBooleanRef var8);

    public abstract float getShieldBlockBase(class_1799 var1);

    public abstract float getShieldBlockFactor(class_1799 var1);

    public abstract double getShieldKnockbackResistanceValue(class_1799 var1);

    @NotNull
    public abstract class_1271<class_1799> use(class_1937 var1, class_1657 var2, class_1268 var3);

    public abstract boolean canUse(class_1937 var1, class_1657 var2, class_1268 var3);

    public void appendTooltips(class_1799 itemStack, Consumer<class_2561> appender) {
        float base = this.getShieldBlockBase(itemStack);
        float factor = this.getShieldBlockFactor(itemStack);
        double knockback = this.getShieldKnockbackResistanceValue(itemStack);
        if ((double)base > 0.0) {
            appender.accept((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.equals." + class_1322.class_1323.field_6328.method_6191()), (Object[])new Object[]{class_1799.field_8029.format(base), this.getProtectionComponent()})).method_27692(class_124.field_1077));
        }
        if ((double)factor > 0.0) {
            appender.accept((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.equals." + class_1322.class_1323.field_6331.method_6191()), (Object[])new Object[]{class_1799.field_8029.format((double)factor * 100.0), this.getReductionComponent()})).method_27692(class_124.field_1077));
        }
        if (knockback > 0.0) {
            appender.accept((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.equals." + class_1322.class_1323.field_6328.method_6191()), (Object[])new Object[]{class_1799.field_8029.format(knockback * 10.0), class_2561.method_43471((String)"attribute.name.generic.knockback_resistance")})).method_27692(class_124.field_1077));
        }
    }

    public class_2561 getProtectionComponent() {
        return class_2561.method_43471((String)"attribute.name.generic.shield_strength");
    }

    public class_2561 getReductionComponent() {
        return class_2561.method_43471((String)"attribute.name.generic.shield_reduction");
    }
}

