/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify;

import com.google.common.base.Suppliers;
import eu.pb4.polymer.core.api.item.PolymerItemUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.ref.Cleaner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.atlas.atlascore.util.ArrayListExtensions;
import net.atlas.atlascore.util.PrefixLogger;
import net.atlas.combatify.component.CustomDataComponents;
import net.atlas.combatify.component.CustomEnchantmentEffectComponents;
import net.atlas.combatify.component.custom.ExtendedBlockingData;
import net.atlas.combatify.component.generators.WeaponStatsGenerator;
import net.atlas.combatify.config.CombatifyGeneralConfig;
import net.atlas.combatify.config.ItemConfig;
import net.atlas.combatify.critereon.DataComponentPredicateInit;
import net.atlas.combatify.item.CombatifyItemTags;
import net.atlas.combatify.item.ItemRegistry;
import net.atlas.combatify.item.TieredShieldItem;
import net.atlas.combatify.item.WeaponType;
import net.atlas.combatify.networking.NetworkingHandler;
import net.atlas.combatify.util.MethodHandler;
import net.atlas.combatify.util.blocking.BlockingType;
import net.atlas.combatify.util.blocking.BlockingTypeInit;
import net.atlas.combatify.util.blocking.condition.BlockingConditions;
import net.atlas.combatify.util.blocking.effect.PostBlockEffects;
import net.atlas.defaulted.DefaultComponentPatchesManager;
import net.atlas.defaulted.fabric.component.DefaultedRegistries;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2315;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2824;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_9285;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.mozilla.javascript.Context;

public class Combatify
implements ModInitializer {
    public static final String MOD_ID = "combatify";
    public static final PrefixLogger LOGGER = new PrefixLogger(LogManager.getLogger((String)"Combatify"));
    public static final PrefixLogger JS_LOGGER = new PrefixLogger(LogManager.getLogger((String)"Combatify|JavaScript"));
    public static final Cleaner CLEANER = Cleaner.create();
    public static CombatifyGeneralConfig CONFIG = new CombatifyGeneralConfig();
    public static ItemConfig ITEMS;
    public static class_2960 modDetectionNetworkChannel;
    public NetworkingHandler networkingHandler;
    private static Supplier<CombatifyState> state;
    public static boolean isLoaded;
    public static boolean mobConfigIsDirty;
    public static final List<class_1792> shields;
    public static final List<UUID> unmoddedPlayers;
    public static final List<UUID> moddedPlayers;
    public static final Map<class_6880<class_1792>, class_9285> originalModifiers;
    public static final Map<UUID, Boolean> isPlayerAttacking;
    public static final Map<String, WeaponType> defaultWeaponTypes;
    public static final Map<class_2960, BlockingType> defaultTypes;
    public static Map<class_2960, BlockingType> registeredTypes;
    public static final class_2960 CHARGED_REACH_ID;

    public static void markState(Supplier<CombatifyState> state) {
        Combatify.state = state;
    }

    public static CombatifyState getState() {
        return state.get();
    }

    public void onInitialize() {
        Event event;
        CLEANER.register(this, Context::exit);
        isLoaded = true;
        BlockingConditions.bootstrap();
        PostBlockEffects.bootstrap();
        WeaponType.init();
        this.networkingHandler = new NetworkingHandler();
        AttackEntityCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand, pos, direction) -> {
            if (unmoddedPlayers.contains(player.method_5667())) {
                isPlayerAttacking.put(player.method_5667(), false);
            }
            return class_1269.field_5811;
        });
        AttackBlockCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand, pos, direction) -> {
            if (unmoddedPlayers.contains(player.method_5667())) {
                isPlayerAttacking.put(player.method_5667(), false);
                class_3965 hitResult = new class_3965(class_243.method_24953((class_2382)pos), direction, pos, false);
                hitResult = MethodHandler.redirectResult(player, (class_239)hitResult);
                if (hitResult.method_17783() == class_239.class_240.field_1331 && player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    serverPlayer.field_13987.method_12062(class_2824.method_34206((class_1297)((class_3966)hitResult).method_17782(), (boolean)player.method_5715()));
                    return class_1269.field_5814;
                }
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand, hitResult) -> {
            if (unmoddedPlayers.contains(player.method_5667())) {
                isPlayerAttacking.put(player.method_5667(), false);
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand, entity, hitResult) -> {
            if (unmoddedPlayers.contains(player.method_5667())) {
                isPlayerAttacking.put(player.method_5667(), false);
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register(modDetectionNetworkChannel, (player, world, hand) -> {
            if (unmoddedPlayers.contains(player.method_5667())) {
                isPlayerAttacking.put(player.method_5667(), false);
            }
            return class_1269.field_5811;
        });
        LOGGER.info("Init started.");
        CustomDataComponents.registerDataComponents();
        CustomEnchantmentEffectComponents.registerEnchantmentEffectComponents();
        DataComponentPredicateInit.init();
        BlockingTypeInit.init();
        if (FabricLoader.getInstance().isModLoaded("polymer-core")) {
            PolymerItemUtils.ITEM_CHECK.register(itemStack -> Combatify.isPatched(itemStack.method_7909()) || itemStack.method_57826(CustomDataComponents.EXTENDED_BLOCKING_DATA) || itemStack.method_57826(CustomDataComponents.CAN_SWEEP) || itemStack.method_57826(CustomDataComponents.PIERCING_LEVEL));
            PolymerItemUtils.ITEM_MODIFICATION_EVENT.register((itemStack, itemStack1, packetContext) -> {
                class_3222 player = packetContext.getPlayer();
                if (player == null || moddedPlayers.contains(player.method_5667())) {
                    return itemStack;
                }
                return itemStack1;
            });
        }
        CombatifyItemTags.init();
        if (CONFIG.dispensableTridents().booleanValue()) {
            class_2315.method_58681((class_1935)class_1802.field_8547);
        }
        DefaultItemComponentEvents.MODIFY.register(modDetectionNetworkChannel, modifyContext -> {
            modifyContext.modify(class_1802.field_8091, builder -> builder.method_57840(CustomDataComponents.BLOCKING_LEVEL, (Object)1));
            modifyContext.modify(class_1802.field_8845, builder -> builder.method_57840(CustomDataComponents.BLOCKING_LEVEL, (Object)1));
            modifyContext.modify(class_1802.field_8528, builder -> builder.method_57840(CustomDataComponents.BLOCKING_LEVEL, (Object)2));
            modifyContext.modify(class_1802.field_8371, builder -> builder.method_57840(CustomDataComponents.BLOCKING_LEVEL, (Object)3));
            modifyContext.modify(class_1802.field_8802, builder -> builder.method_57840(CustomDataComponents.BLOCKING_LEVEL, (Object)4));
            modifyContext.modify(class_1802.field_22022, builder -> builder.method_57840(CustomDataComponents.BLOCKING_LEVEL, (Object)5));
            modifyContext.modify(class_1802.field_8255, builder -> builder.method_57840(CustomDataComponents.EXTENDED_BLOCKING_DATA, (Object)ExtendedBlockingData.VANILLA_SHIELD));
        });
        if (CONFIG.configOnlyWeapons().booleanValue()) {
            ItemRegistry.registerWeapons();
            event = ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202);
            event.register(entries -> entries.addAfter((class_1935)class_1802.field_22022, new class_1935[]{ItemRegistry.WOODEN_KNIFE, ItemRegistry.STONE_KNIFE, ItemRegistry.IRON_KNIFE, ItemRegistry.GOLD_KNIFE, ItemRegistry.DIAMOND_KNIFE, ItemRegistry.NETHERITE_KNIFE, ItemRegistry.WOODEN_LONGSWORD, ItemRegistry.STONE_LONGSWORD, ItemRegistry.IRON_LONGSWORD, ItemRegistry.GOLD_LONGSWORD, ItemRegistry.DIAMOND_LONGSWORD, ItemRegistry.NETHERITE_LONGSWORD}));
        }
        if (CONFIG.tieredShields().booleanValue()) {
            TieredShieldItem.init();
            shields.add(class_1802.field_8255);
            event = ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202);
            event.register(entries -> entries.addAfter((class_1935)class_1802.field_8255, new class_1935[]{TieredShieldItem.IRON_SHIELD, TieredShieldItem.GOLD_SHIELD, TieredShieldItem.DIAMOND_SHIELD, TieredShieldItem.NETHERITE_SHIELD}));
        }
        DefaultedRegistries.registerPatchGenerator((String)"combat_test_weapon_stats", WeaponStatsGenerator.CODEC);
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get();
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("alternate_mace"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.alternate_mace"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("combatify_extras"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.combatify_extras"), (ResourcePackActivationType)(CONFIG.configOnlyWeapons() != false || CONFIG.tieredShields() != false ? ResourcePackActivationType.ALWAYS_ENABLED : ResourcePackActivationType.NORMAL));
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("default_mace"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.default_mace"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("default_shield"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.default_shield"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("default_shield_attacker_kb"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.default_shield_attacker_knockback"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("old_sword_blocking"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.old_sword_blocking"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("percentage_shield"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.percentage_shield"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("shield_no_banner"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.shield_no_banner"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("sword_blocking"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.sword_blocking"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("vanilla_attack_balancing"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.vanilla_attack_balancing"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("weapon_types"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.weapon_types"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Combatify.id("wooden_shield_recipe"), (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"pack.combatify.wooden_shield_recipe"), (ResourcePackActivationType)(CONFIG.tieredShields() != false ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL));
        if (CONFIG.percentageDamageEffects().booleanValue()) {
            ((class_1291)class_1294.field_5910.comp_349()).method_5566(class_5134.field_23721, class_2960.method_60656((String)"effect.strength"), 0.2, class_1322.class_1323.field_6331);
            ((class_1291)class_1294.field_5911.comp_349()).method_5566(class_5134.field_23721, class_2960.method_60656((String)"effect.weakness"), -0.2, class_1322.class_1323.field_6331);
        }
    }

    public static void setDurability(class_9326.class_9327 builder, @NotNull class_1792 item, int value) {
        builder.method_57854(class_9334.field_49629, (Object)0);
        builder.method_57854(class_9334.field_50072, (Object)value);
        builder.method_57854(class_9334.field_50071, (Object)1);
    }

    public static BlockingType registerBlockingType(BlockingType blockingType) {
        registeredTypes.put(blockingType.name(), blockingType);
        return blockingType;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void defineDefaultWeaponType(WeaponType type) {
        defaultWeaponTypes.put(type.name(), type);
    }

    public static BlockingType defineDefaultBlockingType(BlockingType blockingType) {
        defaultTypes.put(blockingType.name(), blockingType);
        return Combatify.registerBlockingType(blockingType);
    }

    public static boolean isPatched(class_1792 item) {
        List patches = DefaultComponentPatchesManager.getCached();
        if (patches == null) {
            return false;
        }
        return patches.stream().anyMatch(itemPatches -> itemPatches.matchItem(item));
    }

    static {
        modDetectionNetworkChannel = Combatify.id("networking");
        state = Suppliers.memoize(() -> CombatifyState.COMBATIFY);
        isLoaded = false;
        mobConfigIsDirty = true;
        shields = new ArrayListExtensions();
        unmoddedPlayers = new ArrayListExtensions();
        moddedPlayers = new ArrayListExtensions();
        originalModifiers = (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), object2ObjectOpenHashMap -> object2ObjectOpenHashMap.defaultReturnValue((Object)class_9285.field_49326));
        isPlayerAttacking = new HashMap<UUID, Boolean>();
        defaultWeaponTypes = new HashMap<String, WeaponType>();
        defaultTypes = new HashMap<class_2960, BlockingType>();
        registeredTypes = new HashMap<class_2960, BlockingType>();
        CHARGED_REACH_ID = Combatify.id("charged_reach");
    }

    public static enum CombatifyState implements class_3542
    {
        VANILLA("Vanilla", "vanilla"),
        COMBATIFY("Combatify", "combatify"),
        CTS_8C("CTS 8C", "combat_test");

        public final String name;
        public final String key;

        private CombatifyState(String name, String key) {
            this.name = name;
            this.key = key;
        }

        @NotNull
        public String method_15434() {
            return this.key;
        }

        public class_2561 getComponent() {
            return class_2561.method_48321((String)("options.combatify_state." + this.key), (String)this.name);
        }

        public String toString() {
            return "CombatifyState{name='" + this.name + "'}";
        }
    }
}

