/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.atlas.combatify.config.item.WeaponStats;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ConfigurableItemData(WeaponStats weaponStats, Optional<Double> optionalUseDuration) {
    public static final ConfigurableItemData EMPTY = new ConfigurableItemData(WeaponStats.EMPTY, (Double)null);
    public static final MapCodec<ConfigurableItemData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeaponStats.CODEC.orElse((Object)WeaponStats.EMPTY).forGetter(ConfigurableItemData::weaponStats), (App)Codec.doubleRange((double)0.05, (double)50.0).optionalFieldOf("use_seconds").forGetter(ConfigurableItemData::optionalUseDuration)).apply((Applicative)instance, ConfigurableItemData::new));
    public static final class_9139<class_9129, ConfigurableItemData> ITEM_DATA_STREAM_CODEC = class_9139.method_56435(WeaponStats.STREAM_CODEC, ConfigurableItemData::weaponStats, (class_9139)class_9135.method_56382((class_9139)class_9135.field_48553), ConfigurableItemData::optionalUseDuration, ConfigurableItemData::new);

    public ConfigurableItemData(WeaponStats weaponStats, Double useDuration) {
        this(weaponStats, Optional.ofNullable(useDuration));
    }

    public Double useDuration() {
        return this.optionalUseDuration.orElse(null);
    }

    public static Optional<Integer> max(Optional<Integer> value, int min) {
        return value.map(integer -> Math.max(integer, min));
    }

    public static Optional<Double> max(Optional<Double> value, double min) {
        return value.map(val -> Math.max(val, min));
    }

    public static Optional<Integer> clamp(Optional<Integer> value, int min, int max) {
        return value.map(integer -> Math.min(Math.max(integer, min), max));
    }

    public static Optional<Double> clamp(Optional<Double> value, double min, double max) {
        return value.map(val -> Math.min(Math.max(val, min), max));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurableItemData)) {
            return false;
        }
        ConfigurableItemData that = (ConfigurableItemData)o;
        return Objects.equals(this.weaponStats, that.weaponStats) && Objects.equals(this.optionalUseDuration, that.optionalUseDuration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.weaponStats, this.optionalUseDuration);
    }
}

