/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.config.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.atlas.combatify.config.ConfigurableItemData;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record WeaponStats(Optional<Double> optionalChargedReach) {
    public static final WeaponStats EMPTY = new WeaponStats((Double)null);
    public static final MapCodec<WeaponStats> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("charged_reach").forGetter(WeaponStats::optionalChargedReach)).apply((Applicative)instance, WeaponStats::new));
    public static final class_9139<class_9129, WeaponStats> STREAM_CODEC = class_9139.method_56437((buf, weaponStats) -> buf.method_52940(weaponStats.optionalChargedReach.orElse(-10.0).doubleValue()), buf -> {
        Double chargedReach = buf.readDouble();
        if (chargedReach == -10.0) {
            chargedReach = null;
        }
        return new WeaponStats(chargedReach);
    });

    public WeaponStats(Double chargedReach) {
        this(Optional.ofNullable(chargedReach));
    }

    public WeaponStats(Optional<Double> optionalChargedReach) {
        this.optionalChargedReach = ConfigurableItemData.clamp(optionalChargedReach, 0.0, 10.0);
    }

    public Double chargedReach() {
        return this.optionalChargedReach.orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WeaponStats)) {
            return false;
        }
        WeaponStats that = (WeaponStats)o;
        return Objects.equals(this.optionalChargedReach, that.optionalChargedReach);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.optionalChargedReach);
    }
}

