/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.combatify.item;

import net.atlas.combatify.Combatify;
import net.atlas.combatify.component.custom.Blocker;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;

public record WeaponType(String name, double damageOffset, double speed, double reach, boolean useHoeDamage, boolean tierable) {
    public static final WeaponType EMPTY = WeaponType.createBasicUntierable("empty", 0.0, 0.0, 0.0);
    public static final WeaponType LONGSWORD = WeaponType.createWithHoeDamageFormula("longsword", 0.0, 0.5, 1.0);
    public static final WeaponType KNIFE = WeaponType.createBasic("knife", 1.0, 1.0, 0.0);
    public static final class_2960 BASE_ATTACK_SPEED_CTS_ID = class_2960.method_60656((String)"base_attack_speed_cts");
    public static final class_2960 BASE_ATTACK_REACH_ID = class_2960.method_60656((String)"base_attack_reach");

    public static WeaponType createUnsynced(String name, double damageOffset, double speed, double reach, boolean useHoeDamage, boolean tierable) {
        WeaponType type = new WeaponType(name, damageOffset, speed, reach, useHoeDamage, tierable);
        return type;
    }

    public static WeaponType createBasic(String name, double damageOffset, double speed, double reach) {
        return WeaponType.createUnsynced(name, damageOffset, speed, reach, false, true);
    }

    public static WeaponType createBasicUntierable(String name, double damageOffset, double speed, double reach) {
        return WeaponType.createUnsynced(name, damageOffset, speed, reach, false, false);
    }

    public static WeaponType createWithHoeDamageFormula(String name, double damageOffset, double speed, double reach) {
        return WeaponType.createUnsynced(name, damageOffset, speed, reach, true, true);
    }

    public void addCombatAttributes(int weaponLevel, class_1832 tier, class_9285.class_9286 attributeModifiers) {
        if (this.isEmpty()) {
            return;
        }
        double speed = this.speedFormula();
        double damage = this.getDamage(weaponLevel, tier.method_8028());
        double reach = this.reach();
        attributeModifiers.method_57487(class_5134.field_23721, new class_1322(class_1792.field_8006, damage, class_1322.class_1323.field_6328), class_9274.field_49217);
        if (!Combatify.CONFIG.instaAttack().booleanValue()) {
            attributeModifiers.method_57487(class_5134.field_23723, new class_1322(BASE_ATTACK_SPEED_CTS_ID, speed, class_1322.class_1323.field_6328), class_9274.field_49217);
        }
        if (reach != 0.0 && Combatify.CONFIG.attackReach().booleanValue()) {
            attributeModifiers.method_57487(class_5134.field_47759, new class_1322(BASE_ATTACK_REACH_ID, reach, class_1322.class_1323.field_6328), class_9274.field_49217);
        }
    }

    public double getDamage(int weaponLevel, float attackDamageBonus) {
        double modifier = 2.0 - Combatify.CONFIG.fistDamage();
        double damageBonus = (double)attackDamageBonus + modifier;
        return this.damageFormula(damageBonus, weaponLevel, modifier);
    }

    public Blocker blocking() {
        return null;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public double damageFormula(double damageBonus, int weaponLevel, double modifier) {
        if (!this.tierable) {
            return modifier + this.damageOffset;
        }
        if (this.useHoeDamage) {
            if (weaponLevel != 2 && weaponLevel != 3) {
                if (weaponLevel >= 4) {
                    return weaponLevel == 4 ? 2.0 + modifier : damageBonus - 1.0;
                }
                return modifier;
            }
            return 1.0 + modifier;
        }
        return damageBonus + this.damageOffset;
    }

    public double speedFormula() {
        return this.speed;
    }

    public static void init() {
        Combatify.defineDefaultWeaponType(LONGSWORD);
        Combatify.defineDefaultWeaponType(KNIFE);
    }
}

