/*
 * Decompiled with CFR 0.152.
 */
package com.gomania.mineschemplugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MineSchemPlugin
extends JavaPlugin
implements CommandExecutor,
Listener {
    private File configFile;
    private Map<UUID, String> playerTokens = new HashMap<UUID, String>();
    private Map<UUID, String> playerIds = new HashMap<UUID, String>();
    private static final int SCHEMATICS_PER_PAGE = 21;
    private Map<UUID, List<JsonObject>> playerSchematics = new HashMap<UUID, List<JsonObject>>();
    private Map<UUID, Integer> playerPage = new HashMap<UUID, Integer>();

    public void onEnable() {
        this.getCommand("msplogin").setExecutor((CommandExecutor)this);
        this.getCommand("msplogout").setExecutor((CommandExecutor)this);
        this.getCommand("msp").setExecutor((CommandExecutor)this);
        this.configFile = new File(this.getDataFolder(), "auth.json");
        this.loadAuth();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("MineSchemPlugin \u0432\u043a\u043b\u044e\u0447\u0451\u043d \u0441 GUI!");
    }

    public void onDisable() {
        this.saveAuth();
        this.getLogger().info("MineSchemPlugin \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "\u041a\u043e\u043c\u0430\u043d\u0434\u044b \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0430\u043c!");
            return true;
        }
        Player player = (Player)sender;
        switch (cmd.getName().toLowerCase()) {
            case "msplogin": {
                if (args.length < 2) {
                    player.sendMessage(ChatColor.RED + "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439: /msplogin <\u043b\u043e\u0433\u0438\u043d> <\u043f\u0430\u0440\u043e\u043b\u044c>");
                    return true;
                }
                this.loginAsync(player, args[0], args[1]);
                return true;
            }
            case "msplogout": {
                this.logout(player);
                return true;
            }
            case "msp": {
                if (args.length == 0) {
                    this.loadSchematicsAsync(player, 1);
                    return true;
                }
                if (args[0].equalsIgnoreCase("download") && args.length == 2) {
                    try {
                        int id = Integer.parseInt(args[1]);
                        this.downloadSchematicAsync(player, id);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ChatColor.RED + "ID \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!");
                    }
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private void openGUI(Player player, int page) {
        List schematics = this.playerSchematics.getOrDefault(player.getUniqueId(), Collections.emptyList());
        int totalPages = (int)Math.ceil((double)schematics.size() / 21.0);
        if (totalPages == 0) {
            totalPages = 1;
        }
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        this.playerPage.put(player.getUniqueId(), page);
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(ChatColor.GOLD + "MineSchem"));
        ItemStack glass = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta gMeta = glass.getItemMeta();
        gMeta.setDisplayName(" ");
        glass.setItemMeta(gMeta);
        for (int i = 0; i < 54; ++i) {
            if (i >= 9 && i < 45 && i % 9 != 0 && i % 9 != 8) continue;
            inv.setItem(i, glass);
        }
        int start = (page - 1) * 21;
        int end = Math.min(start + 21, schematics.size());
        int slot = 10;
        for (int i = start; i < end; ++i) {
            JsonObject s = (JsonObject)schematics.get(i);
            int id = s.get("id1").getAsInt();
            String title = s.get("title").getAsString();
            String ver = s.get("ver").getAsString();
            String schem = s.get("schem").getAsString();
            ItemStack item = new ItemStack(Material.PAPER);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(ChatColor.YELLOW + title);
            meta.setLore(Arrays.asList(ChatColor.GRAY + schem, ChatColor.AQUA + "ID: " + id, ChatColor.GREEN + "\u041a\u043b\u0438\u043a \u2014 \u0441\u043a\u0430\u0447\u0430\u0442\u044c"));
            item.setItemMeta(meta);
            inv.setItem(slot, item);
            if (++slot % 9 != 8) continue;
            slot += 2;
        }
        ItemStack back = new ItemStack(Material.ARROW);
        ItemMeta bMeta = back.getItemMeta();
        bMeta.setDisplayName(page == 1 ? ChatColor.DARK_GRAY + "\u041d\u0430\u0437\u0430\u0434" : ChatColor.AQUA + "\u041d\u0430\u0437\u0430\u0434");
        back.setItemMeta(bMeta);
        inv.setItem(45, back);
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta iMeta = info.getItemMeta();
        iMeta.setDisplayName(ChatColor.GOLD + "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 " + page + " \u0438\u0437 " + totalPages);
        info.setItemMeta(iMeta);
        inv.setItem(49, info);
        ItemStack next = new ItemStack(Material.ARROW);
        ItemMeta nMeta = next.getItemMeta();
        nMeta.setDisplayName(page == totalPages ? ChatColor.DARK_GRAY + "\u0412\u043f\u0435\u0440\u0451\u0434" : ChatColor.AQUA + "\u0412\u043f\u0435\u0440\u0451\u0434");
        next.setItemMeta(nMeta);
        inv.setItem(53, next);
        player.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        if (e.getView().getTitle().contains("MineSchem")) {
            String idLine;
            List lore;
            e.setCancelled(true);
            ItemStack clicked = e.getCurrentItem();
            if (clicked == null || !clicked.hasItemMeta()) {
                return;
            }
            String name = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
            if (name.equalsIgnoreCase("\u041d\u0430\u0437\u0430\u0434")) {
                int page = this.playerPage.getOrDefault(player.getUniqueId(), 1);
                if (page > 1) {
                    this.openGUI(player, page - 1);
                }
            } else if (name.equalsIgnoreCase("\u0412\u043f\u0435\u0440\u0451\u0434")) {
                int page = this.playerPage.getOrDefault(player.getUniqueId(), 1);
                this.openGUI(player, page + 1);
            } else if (clicked.getType() == Material.PAPER && (lore = clicked.getItemMeta().getLore()) != null && lore.size() >= 2 && (idLine = ChatColor.stripColor((String)((String)lore.get(1)))).startsWith("ID:")) {
                int id = Integer.parseInt(idLine.replace("ID:", "").trim());
                player.closeInventory();
                this.downloadSchematicAsync(player, id);
            }
        }
    }

    private void loginAsync(Player player, String username, String password) {
        player.sendMessage(ChatColor.YELLOW + "\u23f3 \u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f...");
        CompletableFuture.runAsync(() -> {
            try {
                JsonObject respJson;
                URL url = new URL("https://mineschem.xyz/api/login");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json; utf-8");
                conn.setDoOutput(true);
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(15000);
                JsonObject json = new JsonObject();
                json.addProperty("username", username);
                json.addProperty("password", password);
                try (OutputStream os = conn.getOutputStream();){
                    os.write(json.toString().getBytes(StandardCharsets.UTF_8));
                }
                int code = conn.getResponseCode();
                InputStream responseStream = code == 200 ? conn.getInputStream() : conn.getErrorStream();
                String response = new String(responseStream.readAllBytes(), StandardCharsets.UTF_8);
                Gson gson = new GsonBuilder().setLenient().create();
                try {
                    respJson = (JsonObject)gson.fromJson(response, JsonObject.class);
                }
                catch (Exception ex) {
                    respJson = new JsonObject();
                }
                if (code == 200 && respJson.has("token") && !respJson.get("token").getAsString().isEmpty() && respJson.has("id") && !respJson.get("id").getAsString().equals("0")) {
                    String token = respJson.get("token").getAsString();
                    String userId = respJson.get("id").getAsString();
                    this.playerTokens.put(player.getUniqueId(), token);
                    this.playerIds.put(player.getUniqueId(), userId);
                    this.saveAuth();
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(ChatColor.GREEN + "\u2705 \u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u0430!"));
                } else {
                    String errMsg = respJson.has("error") ? respJson.get("error").getAsString() : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(ChatColor.RED + "\u274c \u041b\u043e\u0433\u0438\u043d \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439! (" + errMsg + ")"));
                }
            }
            catch (Exception e) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(ChatColor.RED + "\u274c \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438: " + e.getMessage()));
            }
        });
    }

    private void logout(Player player) {
        UUID uuid = player.getUniqueId();
        this.playerTokens.remove(uuid);
        this.playerIds.remove(uuid);
        this.saveAuth();
        player.sendMessage(ChatColor.YELLOW + "\u26a0\ufe0f \u0412\u044b \u0432\u044b\u0448\u043b\u0438 \u0438\u0437 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 MineSchem.");
    }

    private void loadSchematicsAsync(Player player, int page) {
        player.sendMessage(ChatColor.YELLOW + "\u23f3 \u0417\u0430\u0433\u0440\u0443\u0436\u0430\u044e \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u0445\u0435\u043c...");
        CompletableFuture.runAsync(() -> {
            try {
                int code;
                InputStream responseStream;
                String response;
                String trimmed;
                URL url = new URL("https://mineschem.xyz/api/upload");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(30000);
                String token = this.playerTokens.get(player.getUniqueId());
                if (token != null) {
                    conn.setRequestProperty("Authorization", "Bearer " + token);
                }
                if ((trimmed = (response = new String((responseStream = (code = conn.getResponseCode()) == 200 ? conn.getInputStream() : conn.getErrorStream()).readAllBytes(), StandardCharsets.UTF_8)).trim()).isEmpty() || !trimmed.startsWith("{") && !trimmed.startsWith("[")) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(ChatColor.RED + "\u274c \u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u043e\u0442 API."));
                    return;
                }
                Gson gson = new GsonBuilder().setLenient().create();
                JsonElement root = (JsonElement)gson.fromJson(response, JsonElement.class);
                ArrayList<JsonObject> schematics = new ArrayList<JsonObject>();
                if (root.isJsonArray()) {
                    for (JsonElement e : root.getAsJsonArray()) {
                        if (!e.isJsonObject()) continue;
                        schematics.add(e.getAsJsonObject());
                    }
                } else if (root.isJsonObject() && root.getAsJsonObject().has("data")) {
                    for (JsonElement e : root.getAsJsonObject().getAsJsonArray("data")) {
                        if (!e.isJsonObject()) continue;
                        schematics.add(e.getAsJsonObject());
                    }
                }
                this.playerSchematics.put(player.getUniqueId(), schematics);
                Bukkit.getScheduler().runTask((Plugin)this, () -> this.openGUI(player, page));
            }
            catch (Exception e) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(ChatColor.RED + "\u274c \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438: " + e.getMessage()));
            }
        });
    }

    private void downloadSchematicAsync(Player player, int id) {
        player.sendMessage(ChatColor.YELLOW + "\u23f3 \u0421\u043a\u0430\u0447\u0438\u0432\u0430\u044e \u0441\u0445\u0435\u043c\u0443...");
        CompletableFuture.runAsync(() -> {
            try {
                String listResp;
                URL listUrl = new URL("https://mineschem.xyz/api/upload");
                HttpURLConnection listConn = (HttpURLConnection)listUrl.openConnection();
                listConn.setRequestMethod("GET");
                String token = this.playerTokens.get(player.getUniqueId());
                if (token != null) {
                    listConn.setRequestProperty("Authorization", "Bearer " + token);
                }
                try (InputStream listStream = listConn.getInputStream();){
                    listResp = new String(listStream.readAllBytes(), StandardCharsets.UTF_8);
                }
                JsonElement root = (JsonElement)new Gson().fromJson(listResp, JsonElement.class);
                String fileName = null;
                if (root.isJsonArray()) {
                    for (JsonElement e : root.getAsJsonArray()) {
                        if (!e.isJsonObject() || !e.getAsJsonObject().has("id1") || e.getAsJsonObject().get("id1").getAsInt() != id || !e.getAsJsonObject().has("schem")) continue;
                        fileName = e.getAsJsonObject().get("schem").getAsString();
                        break;
                    }
                } else if (root.isJsonObject() && root.getAsJsonObject().has("data")) {
                    for (JsonElement e : root.getAsJsonObject().getAsJsonArray("data")) {
                        if (!e.isJsonObject() || !e.getAsJsonObject().has("id1") || e.getAsJsonObject().get("id1").getAsInt() != id || !e.getAsJsonObject().has("schem")) continue;
                        fileName = e.getAsJsonObject().get("schem").getAsString();
                        break;
                    }
                }
                if (fileName == null) {
                    int finalId = id;
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(ChatColor.RED + "\u274c \u0421\u0445\u0435\u043c\u0430 \u0441 ID " + finalId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!"));
                    return;
                }
                String finalFileName = fileName;
                String downloadUrl = "https://mineschem.xyz/upload/upload/schem/download.php?path=" + finalFileName;
                File folder = new File("plugins/WorldEdit/schematics/");
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                File file = new File(folder, finalFileName);
                HttpURLConnection dl = (HttpURLConnection)new URL(downloadUrl).openConnection();
                dl.setRequestMethod("GET");
                dl.setConnectTimeout(10000);
                dl.setReadTimeout(30000);
                try (InputStream in = dl.getInputStream();
                     FileOutputStream out = new FileOutputStream(file);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                }
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(ChatColor.GREEN + "\u2705 \u0421\u0445\u0435\u043c\u0430 '" + finalFileName + "' \u0441\u043a\u0430\u0447\u0430\u043d\u0430 \u0432 WorldEdit/schematics!"));
            }
            catch (Exception e) {
                String errorMsg = e.getMessage();
                Bukkit.getScheduler().runTask((Plugin)this, () -> player.sendMessage(ChatColor.RED + "\u274c \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u0438: " + errorMsg));
            }
        });
    }

    private void saveAuth() {
        try {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            JsonObject json = new JsonObject();
            for (UUID uuid : this.playerTokens.keySet()) {
                JsonObject playerJson = new JsonObject();
                playerJson.addProperty("token", this.playerTokens.get(uuid));
                playerJson.addProperty("userId", this.playerIds.get(uuid));
                json.add(uuid.toString(), (JsonElement)playerJson);
            }
            try (FileWriter writer = new FileWriter(this.configFile);){
                writer.write(json.toString());
            }
        }
        catch (IOException e) {
            this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c auth.json: " + e.getMessage());
        }
    }

    private void loadAuth() {
        if (!this.configFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            JsonObject json = (JsonObject)new Gson().fromJson(sb.toString(), JsonObject.class);
            for (String key : json.keySet()) {
                try {
                    UUID uuid = UUID.fromString(key);
                    JsonObject playerJson = json.getAsJsonObject(key);
                    if (playerJson.has("token") && playerJson.has("userId")) {
                        this.playerTokens.put(uuid, playerJson.get("token").getAsString());
                        this.playerIds.put(uuid, playerJson.get("userId").getAsString());
                        continue;
                    }
                    this.getLogger().warning("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d \u0438\u0433\u0440\u043e\u043a \u0441 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u043c\u0438 \u0434\u0430\u043d\u043d\u044b\u043c\u0438: " + key);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0432 auth.json: " + key);
                }
            }
        }
        catch (IOException e) {
            this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c auth.json: " + e.getMessage());
        }
    }
}

