/*
 * Decompiled with CFR 0.152.
 */
package com.ameguard.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class AmethystGuardConfig {
    public boolean allowSmallBud = true;
    public boolean allowMediumBud = false;
    public boolean allowLargeBud = false;
    public boolean allowCluster = true;
    public boolean protectBuddingAmethyst = true;
    public boolean showOnScreenMessages = true;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AmethystGuardConfig loadOrCreate() {
        Path cfgDir = FabricLoader.getInstance().getConfigDir();
        Path file = cfgDir.resolve("amethyst_guard.json");
        if (!Files.exists(file, new LinkOption[0])) {
            AmethystGuardConfig def = new AmethystGuardConfig();
            def.save();
            return def;
        }
        try (BufferedReader r = Files.newBufferedReader(file);){
            AmethystGuardConfig loaded222 = (AmethystGuardConfig)GSON.fromJson((Reader)r, AmethystGuardConfig.class);
            if (loaded222 == null) {
                AmethystGuardConfig def = new AmethystGuardConfig();
                def.save();
                AmethystGuardConfig amethystGuardConfig = def;
                return amethystGuardConfig;
            }
            if (!AmethystGuardConfig.hasField(loaded222, "showOnScreenMessages")) {
                loaded222.showOnScreenMessages = true;
            }
            AmethystGuardConfig throwable = loaded222;
            return throwable;
        }
        catch (IOException e) {
            e.printStackTrace();
            AmethystGuardConfig def = new AmethystGuardConfig();
            def.save();
            return def;
        }
    }

    public void save() {
        try {
            Path cfgDir = FabricLoader.getInstance().getConfigDir();
            if (!Files.exists(cfgDir, new LinkOption[0])) {
                Files.createDirectories(cfgDir, new FileAttribute[0]);
            }
            Path file = cfgDir.resolve("amethyst_guard.json");
            try (BufferedWriter w = Files.newBufferedWriter(file, new OpenOption[0]);){
                GSON.toJson((Object)this, (Appendable)w);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean hasField(Object obj, String name) {
        try {
            obj.getClass().getDeclaredField(name);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }
}

