/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.abyssofdestruction.block;

import net.mcreator.abyssofdestruction.procedures.RefinerOnBlockRightClickedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RefinerBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public RefinerBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.ANVIL).strength(7.0f, 40.0f).lightLevel(s -> 4).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)RefinerBlock.box((double)-15.0, (double)0.0, (double)-3.0, (double)31.0, (double)28.0, (double)20.0), (VoxelShape[])new VoxelShape[]{RefinerBlock.box((double)-6.0, (double)1.0, (double)20.0, (double)-2.0, (double)28.0, (double)21.0), RefinerBlock.box((double)17.0, (double)1.0, (double)-4.0, (double)21.0, (double)28.0, (double)-3.0), RefinerBlock.box((double)-5.0, (double)10.0, (double)-3.25, (double)9.0, (double)21.0, (double)-3.0), RefinerBlock.box((double)-5.0, (double)21.0, (double)-4.0, (double)9.0, (double)23.0, (double)-3.0), RefinerBlock.box((double)9.0, (double)10.0, (double)-4.0, (double)11.0, (double)23.0, (double)-3.0), RefinerBlock.box((double)-7.0, (double)10.0, (double)-4.0, (double)-5.0, (double)23.0, (double)-3.0), RefinerBlock.box((double)-16.0, (double)2.0, (double)3.0, (double)-14.0, (double)15.0, (double)14.0), RefinerBlock.box((double)-7.0, (double)8.0, (double)-4.0, (double)11.0, (double)10.0, (double)-3.0), RefinerBlock.box((double)-2.0, (double)2.0, (double)20.0, (double)31.0, (double)6.0, (double)21.0), RefinerBlock.box((double)-16.0, (double)0.0, (double)-3.0, (double)-15.0, (double)1.0, (double)20.0), RefinerBlock.box((double)-16.0, (double)0.0, (double)-4.0, (double)32.0, (double)1.0, (double)-3.0), RefinerBlock.box((double)-16.0, (double)0.0, (double)20.0, (double)32.0, (double)1.0, (double)21.0), RefinerBlock.box((double)31.0, (double)0.0, (double)-3.0, (double)32.0, (double)1.0, (double)20.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)RefinerBlock.box((double)-15.0, (double)0.0, (double)-4.0, (double)31.0, (double)28.0, (double)19.0), (VoxelShape[])new VoxelShape[]{RefinerBlock.box((double)18.0, (double)1.0, (double)-5.0, (double)22.0, (double)28.0, (double)-4.0), RefinerBlock.box((double)-5.0, (double)1.0, (double)19.0, (double)-1.0, (double)28.0, (double)20.0), RefinerBlock.box((double)7.0, (double)10.0, (double)19.0, (double)21.0, (double)21.0, (double)19.25), RefinerBlock.box((double)7.0, (double)21.0, (double)19.0, (double)21.0, (double)23.0, (double)20.0), RefinerBlock.box((double)5.0, (double)10.0, (double)19.0, (double)7.0, (double)23.0, (double)20.0), RefinerBlock.box((double)21.0, (double)10.0, (double)19.0, (double)23.0, (double)23.0, (double)20.0), RefinerBlock.box((double)30.0, (double)2.0, (double)2.0, (double)32.0, (double)15.0, (double)13.0), RefinerBlock.box((double)5.0, (double)8.0, (double)19.0, (double)23.0, (double)10.0, (double)20.0), RefinerBlock.box((double)-15.0, (double)2.0, (double)-5.0, (double)18.0, (double)6.0, (double)-4.0), RefinerBlock.box((double)31.0, (double)0.0, (double)-4.0, (double)32.0, (double)1.0, (double)19.0), RefinerBlock.box((double)-16.0, (double)0.0, (double)19.0, (double)32.0, (double)1.0, (double)20.0), RefinerBlock.box((double)-16.0, (double)0.0, (double)-5.0, (double)32.0, (double)1.0, (double)-4.0), RefinerBlock.box((double)-16.0, (double)0.0, (double)-4.0, (double)-15.0, (double)1.0, (double)19.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)RefinerBlock.box((double)-3.0, (double)0.0, (double)-15.0, (double)20.0, (double)28.0, (double)31.0), (VoxelShape[])new VoxelShape[]{RefinerBlock.box((double)20.0, (double)1.0, (double)18.0, (double)21.0, (double)28.0, (double)22.0), RefinerBlock.box((double)-4.0, (double)1.0, (double)-5.0, (double)-3.0, (double)28.0, (double)-1.0), RefinerBlock.box((double)-3.25, (double)10.0, (double)7.0, (double)-3.0, (double)21.0, (double)21.0), RefinerBlock.box((double)-4.0, (double)21.0, (double)7.0, (double)-3.0, (double)23.0, (double)21.0), RefinerBlock.box((double)-4.0, (double)10.0, (double)5.0, (double)-3.0, (double)23.0, (double)7.0), RefinerBlock.box((double)-4.0, (double)10.0, (double)21.0, (double)-3.0, (double)23.0, (double)23.0), RefinerBlock.box((double)3.0, (double)2.0, (double)30.0, (double)14.0, (double)15.0, (double)32.0), RefinerBlock.box((double)-4.0, (double)8.0, (double)5.0, (double)-3.0, (double)10.0, (double)23.0), RefinerBlock.box((double)20.0, (double)2.0, (double)-15.0, (double)21.0, (double)6.0, (double)18.0), RefinerBlock.box((double)-3.0, (double)0.0, (double)31.0, (double)20.0, (double)1.0, (double)32.0), RefinerBlock.box((double)-4.0, (double)0.0, (double)-16.0, (double)-3.0, (double)1.0, (double)32.0), RefinerBlock.box((double)20.0, (double)0.0, (double)-16.0, (double)21.0, (double)1.0, (double)32.0), RefinerBlock.box((double)-3.0, (double)0.0, (double)-16.0, (double)20.0, (double)1.0, (double)-15.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)RefinerBlock.box((double)-4.0, (double)0.0, (double)-15.0, (double)19.0, (double)28.0, (double)31.0), (VoxelShape[])new VoxelShape[]{RefinerBlock.box((double)-5.0, (double)1.0, (double)-6.0, (double)-4.0, (double)28.0, (double)-2.0), RefinerBlock.box((double)19.0, (double)1.0, (double)17.0, (double)20.0, (double)28.0, (double)21.0), RefinerBlock.box((double)19.0, (double)10.0, (double)-5.0, (double)19.25, (double)21.0, (double)9.0), RefinerBlock.box((double)19.0, (double)21.0, (double)-5.0, (double)20.0, (double)23.0, (double)9.0), RefinerBlock.box((double)19.0, (double)10.0, (double)9.0, (double)20.0, (double)23.0, (double)11.0), RefinerBlock.box((double)19.0, (double)10.0, (double)-7.0, (double)20.0, (double)23.0, (double)-5.0), RefinerBlock.box((double)2.0, (double)2.0, (double)-16.0, (double)13.0, (double)15.0, (double)-14.0), RefinerBlock.box((double)19.0, (double)8.0, (double)-7.0, (double)20.0, (double)10.0, (double)11.0), RefinerBlock.box((double)-5.0, (double)2.0, (double)-2.0, (double)-4.0, (double)6.0, (double)31.0), RefinerBlock.box((double)-4.0, (double)0.0, (double)-16.0, (double)19.0, (double)1.0, (double)-15.0), RefinerBlock.box((double)19.0, (double)0.0, (double)-16.0, (double)20.0, (double)1.0, (double)32.0), RefinerBlock.box((double)-5.0, (double)0.0, (double)-16.0, (double)-4.0, (double)1.0, (double)32.0), RefinerBlock.box((double)-4.0, (double)0.0, (double)31.0, (double)19.0, (double)1.0, (double)32.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        RefinerOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

