/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.abyssofdestruction.network;

import java.util.HashMap;
import net.mcreator.abyssofdestruction.AbyssOfDestructionMod;
import net.mcreator.abyssofdestruction.procedures.ClawerSound1Procedure;
import net.mcreator.abyssofdestruction.procedures.ClawerSound2Procedure;
import net.mcreator.abyssofdestruction.procedures.ClawerSound3Procedure;
import net.mcreator.abyssofdestruction.procedures.SoundBoardMusicProcedure;
import net.mcreator.abyssofdestruction.world.inventory.CrawlerSoundBoardMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CrawlerSoundBoardButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CrawlerSoundBoardButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"abyss_of_destruction", (String)"crawler_sound_board_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrawlerSoundBoardButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new CrawlerSoundBoardButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<CrawlerSoundBoardButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CrawlerSoundBoardButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                CrawlerSoundBoardButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = CrawlerSoundBoardMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ClawerSound2Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            ClawerSound1Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            ClawerSound3Procedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            SoundBoardMusicProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AbyssOfDestructionMod.addNetworkMessage(TYPE, STREAM_CODEC, CrawlerSoundBoardButtonMessage::handleData);
    }
}

