/*
 * Decompiled with CFR 0.152.
 */
package cloud.cloudie.cloudsystem;

import cloud.cloudie.cloudsystem.commands.HomeCommands;
import cloud.cloudie.cloudsystem.commands.PlayerWarpCommands;
import cloud.cloudie.cloudsystem.commands.SpawnCommand;
import cloud.cloudie.cloudsystem.commands.SystemHomesCommand;
import cloud.cloudie.cloudsystem.commands.TpaCommands;
import cloud.cloudie.cloudsystem.commands.WarpCommands;
import cloud.cloudie.cloudsystem.utils.UpdateChecker;
import co.aikar.commands.PaperCommandManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SystemHomes
extends JavaPlugin {
    public static SystemHomes plugin = null;
    PaperCommandManager manager;

    public void onEnable() {
        if (plugin == null) {
            plugin = this;
        }
        this.manager = new PaperCommandManager((Plugin)this);
        this.saveDefaultConfig();
        this.getLogger().info("|---[ SystemHomes ]---------------------------------------|");
        this.getLogger().info("|                                                         |");
        this.registerCommands();
        this.commandCompletions();
        this.getLogger().info("|                                                         |");
        this.getLogger().info("|------------------------------[ ENABLED SUCCESSFULLY ]---|");
        new UpdateChecker((Plugin)this).checkForUpdates();
    }

    void registerCommands() {
        this.manager.registerCommand(new SystemHomesCommand());
        this.manager.registerCommand(new HomeCommands());
        this.manager.registerCommand(new WarpCommands());
        this.manager.registerCommand(new SpawnCommand());
        this.manager.registerCommand(new TpaCommands());
        this.manager.registerCommand(new PlayerWarpCommands());
        this.getLogger().info("|   Enabled commands                                      |");
    }

    void commandCompletions() {
        this.manager.getCommandCompletions().registerAsyncCompletion("homeNames", c -> {
            String playerName = c.getSender().getName();
            List<String> homeNames = HomeCommands.homeNameToString(playerName);
            return ImmutableList.copyOf(homeNames);
        });
        this.manager.getCommandCompletions().registerAsyncCompletion("warpNames", c -> {
            List<String> warpNames = WarpCommands.warpNameToString();
            return ImmutableList.copyOf(warpNames);
        });
        this.manager.getCommandCompletions().registerAsyncCompletion("pwarpNames", c -> {
            List<String> warpNames = PlayerWarpCommands.pwarpNameToString();
            return ImmutableList.copyOf(warpNames);
        });
        this.getLogger().info("|   Enabled command completions                           |");
    }

    public void onDisable() {
        this.getLogger().info("|---[ SystemHomes ]---------------------------------------|");
        this.getLogger().info("|                                                         |");
        this.getLogger().info("|                                                         |");
        this.getLogger().info("|-----------------------------[ DISABLED SUCCESSFULLY ]---|");
    }
}

