/*
 * Decompiled with CFR 0.152.
 */
package cloud.cloudie.cloudsystem.classes;

import cloud.cloudie.cloudsystem.SystemHomes;
import cloud.cloudie.cloudsystem.classes.Location;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Home
extends Location
implements Serializable {
    String name;
    final UUID owningPlayer;
    boolean isPublic = false;

    public Home(String name, UUID owningPlayer, Location location) {
        super(location);
        this.name = name;
        this.owningPlayer = owningPlayer;
    }

    public Home(String name, OfflinePlayer owningPlayer, Location location) {
        super(location);
        this.name = name;
        this.owningPlayer = owningPlayer.getUniqueId();
    }

    public Home(String name, OfflinePlayer owningPlayer, String worldName, float x, float y, float z) {
        super(worldName, x, y, z);
        this.name = name;
        this.owningPlayer = owningPlayer.getUniqueId();
    }

    public Home(String name, UUID owningPlayer, String worldName, float x, float y, float z) {
        super(worldName, x, y, z);
        this.name = name;
        this.owningPlayer = owningPlayer;
    }

    public Home(String name, OfflinePlayer owningPlayer, String worldName, float x, float y, float z, float yaw, float pitch) {
        super(worldName, x, y, z, yaw, pitch);
        this.name = name;
        this.owningPlayer = owningPlayer.getUniqueId();
    }

    public Home(String name, UUID owningPlayer, String worldName, float x, float y, float z, float yaw, float pitch) {
        super(worldName, x, y, z, yaw, pitch);
        this.name = name;
        this.owningPlayer = owningPlayer;
    }

    public String getHomeName() {
        return this.name;
    }

    public void setHomeName(String name) {
        this.name = name;
    }

    public UUID getOwner() {
        return this.owningPlayer;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String toString() {
        return this.name;
    }

    private FileConfiguration toYamlConfiguration() {
        File homesFile = new File(SystemHomes.plugin.getDataFolder(), "homes.yml");
        if (!homesFile.exists()) {
            try {
                if (homesFile.getParentFile().mkdirs()) {
                    SystemHomes.plugin.getLogger().info("Created plugin data directory.");
                }
                if (homesFile.createNewFile()) {
                    SystemHomes.plugin.getLogger().info("Created homes.yml file.");
                }
            }
            catch (IOException e) {
                SystemHomes.plugin.getLogger().severe("Could not create homes.yml file!" + e.getMessage());
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)homesFile);
        String path = "homes." + String.valueOf(this.owningPlayer) + "." + this.name;
        config.set(path + ".world", (Object)this.world);
        config.set(path + ".public", (Object)this.isPublic);
        config.set(path + ".x", (Object)Float.valueOf(this.x));
        config.set(path + ".y", (Object)Float.valueOf(this.y));
        config.set(path + ".z", (Object)Float.valueOf(this.z));
        config.set(path + ".yaw", (Object)Float.valueOf(this.yaw));
        config.set(path + ".pitch", (Object)Float.valueOf(this.pitch));
        return config;
    }

    public String toYamlString() {
        return this.toYamlConfiguration().toString();
    }

    public void uploadHome() {
        File homesFile = new File(SystemHomes.plugin.getDataFolder(), "homes.yml");
        try {
            this.toYamlConfiguration().save(homesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteHome() {
        String path;
        File homesFile = new File(SystemHomes.plugin.getDataFolder(), "homes.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)homesFile);
        if (config.contains(path = "homes." + String.valueOf(this.owningPlayer) + "." + this.name)) {
            config.set(path, null);
            try {
                config.save(homesFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not save updated homes.yml file", e);
            }
        }
    }

    private static Home getHomeFromConfig(FileConfiguration config, String pathPrefix) {
        String[] pathSegments = pathPrefix.split("\\.");
        String owningPlayer = pathSegments[pathSegments.length - 2];
        String name = pathSegments[pathSegments.length - 1];
        Home home = new Home(name, UUID.fromString(owningPlayer), config.getString(pathPrefix + ".world"), Float.parseFloat(config.getString(pathPrefix + ".x")), Float.parseFloat(config.getString(pathPrefix + ".y")), Float.parseFloat(config.getString(pathPrefix + ".z")), Float.parseFloat(config.getString(pathPrefix + ".yaw")), Float.parseFloat(config.getString(pathPrefix + ".pitch")));
        home.setPublic(config.getBoolean(pathPrefix + ".public", false));
        return home;
    }

    public static Home fromYamlString(String yamlString) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new StringReader(yamlString));
        String pathPrefix = "homes.";
        return Home.getHomeFromConfig((FileConfiguration)config, pathPrefix);
    }

    public static Home getHome(UUID owningPlayer) {
        return Home.getHome(owningPlayer, "home");
    }

    public static Home getHome(UUID owningPlayer, String name) {
        String pathPrefix;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(SystemHomes.plugin.getDataFolder(), "homes.yml"));
        if (!config.contains(pathPrefix = "homes." + String.valueOf(owningPlayer) + "." + name)) {
            throw new IllegalArgumentException("Home '" + name + "' does not exist for player '" + String.valueOf(owningPlayer) + "' in the file.");
        }
        return Home.getHomeFromConfig((FileConfiguration)config, pathPrefix);
    }

    public static boolean containsHome(String homePath) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(SystemHomes.plugin.getDataFolder(), "homes.yml"));
        return config.contains(homePath);
    }

    public static List<Home> getPlayerHomes(UUID owningPlayer) {
        String playerPath;
        ArrayList<Home> homes = new ArrayList<Home>();
        File homesFile = new File(SystemHomes.plugin.getDataFolder(), "homes.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)homesFile);
        ConfigurationSection section = config.getConfigurationSection(playerPath = "homes." + owningPlayer.toString());
        if (section == null) {
            return homes;
        }
        Set homeNames = section.getKeys(false);
        for (String homeName : homeNames) {
            String homePath = playerPath + "." + homeName;
            Home home = Home.getHomeFromConfig((FileConfiguration)config, homePath);
            homes.add(home);
        }
        return homes;
    }
}

