/*
 * Decompiled with CFR 0.152.
 */
package cloud.cloudie.cloudsystem.classes;

import java.io.Serializable;
import org.bukkit.Bukkit;

public class Location
implements Serializable {
    public final float x;
    public final float y;
    public final float z;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public final String world;

    public Location(Location location) {
        this.world = location.world;
        this.x = location.x;
        this.y = location.y;
        this.z = location.z;
        if (location.yaw != 0.0f) {
            this.yaw = location.yaw;
        }
        if (location.pitch != 0.0f) {
            this.pitch = location.pitch;
        }
    }

    public Location(org.bukkit.Location location) {
        this.world = location.getWorld().getName();
        this.x = (float)location.getX();
        this.y = (float)location.getY();
        this.z = (float)location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
    }

    public Location(String world, float x, float y, float z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location(String world, float x, float y, float z, float yaw, float pitch) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Location getLocation() {
        return this;
    }

    public org.bukkit.Location toBukkitLocation() {
        return new org.bukkit.Location(Bukkit.getWorld((String)this.world), (double)this.x, (double)this.y, (double)this.z, this.yaw, this.pitch);
    }
}

