/*
 * Decompiled with CFR 0.152.
 */
package cloud.cloudie.cloudsystem.classes;

import cloud.cloudie.cloudsystem.SystemHomes;
import cloud.cloudie.cloudsystem.classes.Location;
import cloud.cloudie.cloudsystem.classes.Warp;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerWarp
extends Warp {
    final UUID owningPlayer;

    public PlayerWarp(String warpName, UUID owningPlayer, org.bukkit.Location location) {
        super(warpName, location);
        this.owningPlayer = owningPlayer;
    }

    public PlayerWarp(String warpName, UUID owningPlayer, Location location) {
        super(warpName, location);
        this.owningPlayer = owningPlayer;
    }

    public PlayerWarp(String warpName, UUID owningPlayer, String world, float x, float y, float z, float yaw, float pitch) {
        super(warpName, world, x, y, z, yaw, pitch);
        this.owningPlayer = owningPlayer;
    }

    public PlayerWarp(String warpName, UUID owningPlayer, String world, float x, float y, float z) {
        super(warpName, world, x, y, z);
        this.owningPlayer = owningPlayer;
    }

    public UUID getOwningPlayer() {
        return this.owningPlayer;
    }

    private FileConfiguration toYamlConfiguration() {
        File warpFile = new File(SystemHomes.plugin.getDataFolder(), "playerwarps.yml");
        if (!warpFile.exists()) {
            try {
                if (warpFile.getParentFile().mkdirs()) {
                    SystemHomes.plugin.getLogger().info("Created plugin data directory.");
                }
                if (warpFile.createNewFile()) {
                    SystemHomes.plugin.getLogger().info("Created playerwarps.yml file.");
                }
            }
            catch (IOException e) {
                SystemHomes.plugin.getLogger().severe("Could not create playerwarps.yml file!" + e.getMessage());
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)warpFile);
        String path = "warps." + this.warpName;
        config.set(path + ".world", (Object)this.world);
        config.set(path + ".player", (Object)this.owningPlayer.toString());
        config.set(path + ".x", (Object)Float.valueOf(this.x));
        config.set(path + ".y", (Object)Float.valueOf(this.y));
        config.set(path + ".z", (Object)Float.valueOf(this.z));
        config.set(path + ".yaw", (Object)Float.valueOf(this.yaw));
        config.set(path + ".pitch", (Object)Float.valueOf(this.pitch));
        return config;
    }

    @Override
    public String toYamlString() {
        return this.toYamlConfiguration().toString();
    }

    public void uploadPlayerWarp() {
        File warpsFile = new File(SystemHomes.plugin.getDataFolder(), "playerwarps.yml");
        try {
            this.toYamlConfiguration().save(warpsFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deletePlayerWarp() {
        String path;
        File warpsFile = new File(SystemHomes.plugin.getDataFolder(), "playerwarps.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)warpsFile);
        if (config.contains(path = "warps." + this.warpName)) {
            config.set(path, null);
            try {
                config.save(warpsFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not save updated playerwarps.yml file", e);
            }
        }
    }

    private static PlayerWarp getPlayerWarpFromConfig(FileConfiguration config, String pathPrefix) {
        String[] pathSegments = pathPrefix.split("\\.");
        String name = pathSegments[pathSegments.length - 1];
        return new PlayerWarp(name, UUID.fromString(config.getString(pathPrefix + ".player")), config.getString(pathPrefix + ".world"), Float.parseFloat(config.getString(pathPrefix + ".x")), Float.parseFloat(config.getString(pathPrefix + ".y")), Float.parseFloat(config.getString(pathPrefix + ".z")), Float.parseFloat(config.getString(pathPrefix + ".yaw")), Float.parseFloat(config.getString(pathPrefix + ".pitch")));
    }

    public static PlayerWarp fromYamlString(String yamlString) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new StringReader(yamlString));
        String pathPrefix = "warps.";
        return PlayerWarp.getPlayerWarpFromConfig((FileConfiguration)config, pathPrefix);
    }

    public static PlayerWarp getPlayerWarp(String name) {
        String pathPrefix;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(SystemHomes.plugin.getDataFolder(), "playerwarps.yml"));
        if (!config.contains(pathPrefix = "warps." + name)) {
            throw new IllegalArgumentException("Warp '" + name + "' does not exist in the file.");
        }
        return PlayerWarp.getPlayerWarpFromConfig((FileConfiguration)config, pathPrefix);
    }

    public static List<PlayerWarp> getPlayerWarps() {
        String path;
        ArrayList<PlayerWarp> warps = new ArrayList<PlayerWarp>();
        File warpsFile = new File(SystemHomes.plugin.getDataFolder(), "playerwarps.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)warpsFile);
        ConfigurationSection section = config.getConfigurationSection(path = "warps.");
        if (section == null) {
            return warps;
        }
        Set warpNames = section.getKeys(false);
        for (String warpName : warpNames) {
            String warpPath = path + warpName;
            PlayerWarp warp = PlayerWarp.getPlayerWarpFromConfig((FileConfiguration)config, warpPath);
            warps.add(warp);
        }
        return warps;
    }

    public static boolean containsPlayerWarp(String warpPath) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(SystemHomes.plugin.getDataFolder(), "playerwarps.yml"));
        return config.contains(warpPath);
    }
}

