/*
 * Decompiled with CFR 0.152.
 */
package cloud.cloudie.cloudsystem.classes;

import cloud.cloudie.cloudsystem.SystemHomes;
import cloud.cloudie.cloudsystem.classes.Location;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Warp
extends Location {
    String warpName;

    public Warp(String warpName, Location location) {
        super(location);
        this.warpName = warpName;
    }

    public Warp(String warpName, org.bukkit.Location location) {
        super(location);
        this.warpName = warpName;
    }

    public Warp(String warpName, String world, float x, float y, float z) {
        super(world, x, y, z);
        this.warpName = warpName;
    }

    public Warp(String warpName, String world, float x, float y, float z, float yaw, float pitch) {
        super(world, x, y, z, yaw, pitch);
        this.warpName = warpName;
    }

    public String getWarpName() {
        return this.warpName;
    }

    public void setWarpName(String warpName) {
        this.warpName = warpName;
    }

    private FileConfiguration toYamlConfiguration() {
        File warpFile = new File(SystemHomes.plugin.getDataFolder(), "warps.yml");
        if (!warpFile.exists()) {
            try {
                if (warpFile.getParentFile().mkdirs()) {
                    SystemHomes.plugin.getLogger().info("Created plugin data directory.");
                }
                if (warpFile.createNewFile()) {
                    SystemHomes.plugin.getLogger().info("Created warps.yml file.");
                }
            }
            catch (IOException e) {
                SystemHomes.plugin.getLogger().severe("Could not create warps.yml file!" + e.getMessage());
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)warpFile);
        String path = "warps." + this.warpName;
        config.set(path + ".world", (Object)this.world);
        config.set(path + ".x", (Object)Float.valueOf(this.x));
        config.set(path + ".y", (Object)Float.valueOf(this.y));
        config.set(path + ".z", (Object)Float.valueOf(this.z));
        config.set(path + ".yaw", (Object)Float.valueOf(this.yaw));
        config.set(path + ".pitch", (Object)Float.valueOf(this.pitch));
        return config;
    }

    public String toYamlString() {
        return this.toYamlConfiguration().toString();
    }

    public void uploadWarp() {
        File warpsFile = new File(SystemHomes.plugin.getDataFolder(), "warps.yml");
        try {
            this.toYamlConfiguration().save(warpsFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteWarp() {
        String path;
        File warpsFile = new File(SystemHomes.plugin.getDataFolder(), "warps.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)warpsFile);
        if (config.contains(path = "warps." + this.warpName)) {
            config.set(path, null);
            try {
                config.save(warpsFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not save updated warps.yml file", e);
            }
        }
    }

    private static Warp getWarpFromConfig(FileConfiguration config, String pathPrefix) {
        String[] pathSegments = pathPrefix.split("\\.");
        String name = pathSegments[pathSegments.length - 1];
        return new Warp(name, config.getString(pathPrefix + ".world"), Float.parseFloat(config.getString(pathPrefix + ".x")), Float.parseFloat(config.getString(pathPrefix + ".y")), Float.parseFloat(config.getString(pathPrefix + ".z")), Float.parseFloat(config.getString(pathPrefix + ".yaw")), Float.parseFloat(config.getString(pathPrefix + ".pitch")));
    }

    public static Warp fromYamlString(String yamlString) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new StringReader(yamlString));
        String pathPrefix = "warps.";
        return Warp.getWarpFromConfig((FileConfiguration)config, pathPrefix);
    }

    public static Warp getWarp(String name) {
        String pathPrefix;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(SystemHomes.plugin.getDataFolder(), "warps.yml"));
        if (!config.contains(pathPrefix = "warps." + name)) {
            throw new IllegalArgumentException("Warp '" + name + "' does not exist in the file.");
        }
        return Warp.getWarpFromConfig((FileConfiguration)config, pathPrefix);
    }

    public static List<Warp> getWarps() {
        String path;
        ArrayList<Warp> warps = new ArrayList<Warp>();
        File warpsFile = new File(SystemHomes.plugin.getDataFolder(), "warps.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)warpsFile);
        ConfigurationSection section = config.getConfigurationSection(path = "warps.");
        if (section == null) {
            return warps;
        }
        Set warpNames = section.getKeys(false);
        for (String warpName : warpNames) {
            String warpPath = path + warpName;
            Warp warp = Warp.getWarpFromConfig((FileConfiguration)config, warpPath);
            warps.add(warp);
        }
        return warps;
    }

    public static boolean containsWarp(String warpPath) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(SystemHomes.plugin.getDataFolder(), "warps.yml"));
        return config.contains(warpPath);
    }
}

