/*
 * Decompiled with CFR 0.152.
 */
package cloud.cloudie.cloudsystem.commands;

import cloud.cloudie.cloudsystem.SystemHomes;
import cloud.cloudie.cloudsystem.classes.Home;
import cloud.cloudie.cloudsystem.classes.Location;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@CommandPermission(value="systemhomes.player.home")
public class HomeCommands
extends BaseCommand {
    private final Map<UUID, String> pendingConfirmations = new HashMap<UUID, String>();

    @CommandAlias(value="sethome")
    @CommandCompletion(value="@nothing")
    public void setHome(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        String homeName = args.length < 1 ? "home" : args[0].toLowerCase();
        String playerPath = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        Home home = new Home(homeName, player.getUniqueId(), new Location(player.getLocation()));
        if (Home.containsHome(playerPath)) {
            if (this.pendingConfirmations.containsKey(player.getUniqueId()) && this.pendingConfirmations.get(player.getUniqueId()).equals(homeName)) {
                this.pendingConfirmations.remove(player.getUniqueId());
                home.uploadHome();
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Home ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)homeName).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" has been overridden!").color(TextColor.fromHexString((String)"#55FF55"))));
                return;
            }
            this.pendingConfirmations.put(player.getUniqueId(), homeName);
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Home ").color(TextColor.fromHexString((String)"#FF5555"))).append(Component.text((String)homeName).color(TextColor.fromHexString((String)"#AA0000")))).append(Component.text((String)" already exists! Use: ").color(TextColor.fromHexString((String)"#FF5555")))).append(((TextComponent)((TextComponent)Component.text((String)("/sethome " + homeName)).color(TextColor.fromHexString((String)"#AA0000"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click this to override your home!").color(TextColor.fromHexString((String)"#FF5555"))))).clickEvent(ClickEvent.runCommand((String)("/sethome " + homeName))))).append(Component.text((String)" again to override it!").color(TextColor.fromHexString((String)"#FF5555"))));
            return;
        }
        home.uploadHome();
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Home ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)homeName).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" has been set to this location!").color(TextColor.fromHexString((String)"#55FF55"))));
    }

    @CommandAlias(value="delhome")
    @CommandCompletion(value="@homeNames")
    public void delHome(CommandSender sender, String[] args) {
        Home home;
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Please put in your home which you want to delete").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        String homeName = args[0].toLowerCase();
        try {
            home = Home.getHome(player.getUniqueId(), homeName);
        }
        catch (RuntimeException e) {
            player.sendMessage(Component.text((String)"This home does not exist.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        try {
            home.deleteHome();
        }
        catch (RuntimeException e) {
            player.sendMessage(Component.text((String)"This home could not be deleted, please try again later.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Home ").color(TextColor.fromHexString((String)"#FF5555"))).append(Component.text((String)homeName).color(TextColor.fromHexString((String)"#AA0000")))).append(Component.text((String)" has been deleted!").color(TextColor.fromHexString((String)"#FF5555"))));
    }

    @CommandAlias(value="home")
    @CommandCompletion(value="@homeNames")
    public void home(CommandSender sender, String[] args) {
        Home home;
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        String homeName = args.length < 1 ? "home" : args[0].toLowerCase();
        int delayInSeconds = SystemHomes.plugin.getConfig().getInt("home.teleport_delay", 2);
        try {
            home = Home.getHome(player.getUniqueId(), homeName);
        }
        catch (RuntimeException e) {
            player.sendMessage(Component.text((String)"This home does not exist.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        org.bukkit.Location location = home.getLocation().toBukkitLocation();
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Teleporting you to home: ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)home.getHomeName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)(" in " + delayInSeconds + " seconds.")).color(TextColor.fromHexString((String)"#55FF55"))));
        Bukkit.getScheduler().runTaskLater((Plugin)SystemHomes.plugin, () -> {
            player.teleport(location);
            player.sendMessage(((TextComponent)Component.text((String)"Teleported you to your home: ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)homeName).color(TextColor.fromHexString((String)"#00AA00"))));
        }, (long)delayInSeconds * 20L);
    }

    @CommandAlias(value="homes")
    public void homeList(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        List<Home> homes = Home.getPlayerHomes(player.getUniqueId());
        Component component = Component.text((String)("Your Homes (" + homes.size() + "):\n")).color(TextColor.fromHexString((String)"#FFAA00"));
        for (Home home : homes) {
            component = component.append(((TextComponent)((TextComponent)Component.text((String)home.getHomeName()).color(TextColor.fromHexString((String)"#FFAA00"))).clickEvent(ClickEvent.runCommand((String)("/home " + home.getHomeName())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Teleport to home: " + home.getHomeName())).color(TextColor.fromHexString((String)"#FFAA00")))));
            component = component.append(Component.text((String)" - ").color(TextColor.fromHexString((String)"#AAAAAA")));
            String worldName = switch (home.world) {
                case "world" -> "Overworld";
                case "world_nether" -> "Nether";
                case "world_the_end" -> "The End";
                default -> home.world;
            };
            component = component.append(((TextComponent)((TextComponent)Component.text((String)("(" + worldName + "; " + (int)home.x + ", " + (int)home.y + ", " + (int)home.z + ")\n")).color(TextColor.fromHexString((String)"#55FFFF"))).clickEvent(ClickEvent.runCommand((String)("/home " + home.getHomeName())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Teleport to home: " + home.getHomeName())).color(TextColor.fromHexString((String)"#FFAA00")))));
        }
        player.sendMessage(component);
    }

    public static List<String> homeNameToString(String playerName) {
        ArrayList<String> homeNameList = new ArrayList<String>();
        List<Home> homes = Home.getPlayerHomes(Bukkit.getOfflinePlayer((String)playerName).getUniqueId());
        for (Home h : homes) {
            homeNameList.add(h.getHomeName());
        }
        return homeNameList;
    }
}

