/*
 * Decompiled with CFR 0.152.
 */
package cloud.cloudie.cloudsystem.commands;

import cloud.cloudie.cloudsystem.SystemHomes;
import cloud.cloudie.cloudsystem.classes.Location;
import cloud.cloudie.cloudsystem.classes.PlayerWarp;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@CommandPermission(value="systemhomes.player.pwarp")
public class PlayerWarpCommands
extends BaseCommand {
    final List<String> pendingOverwrittenConfirmations = new ArrayList<String>();

    @CommandAlias(value="setplayerwarp|setpwarp")
    @CommandCompletion(value="@nothing")
    public void setPlayerWarp(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Please give a name to this PlayerWarp.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        String warpName = args[0].toLowerCase();
        String warpPath = "warps." + warpName;
        PlayerWarp warp = new PlayerWarp(warpName, player.getUniqueId(), new Location(player.getLocation()));
        if (PlayerWarp.containsPlayerWarp(warpPath)) {
            PlayerWarp pwarp = PlayerWarp.getPlayerWarp(warpName);
            if (!pwarp.getOwningPlayer().equals(player.getUniqueId()) || !player.hasPermission("systemhomes.admin.pwarp")) {
                player.sendMessage(Component.text((String)"You may not modify someone else's PlayerWarp!").color(TextColor.fromHexString((String)"#FF5555")));
                return;
            }
            if (this.pendingOverwrittenConfirmations.contains(warpName)) {
                try {
                    warp.uploadPlayerWarp();
                    this.pendingOverwrittenConfirmations.remove(warpName);
                }
                catch (Exception e) {
                    player.sendMessage(Component.text((String)"Failed to upload PlayerWarp, please try again later.").color(TextColor.fromHexString((String)"#FF5555")));
                    return;
                }
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"PlayerWarp ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)warp.getWarpName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" has been overridden!").color(TextColor.fromHexString((String)"#55FF55"))));
                return;
            }
            this.pendingOverwrittenConfirmations.add(warpName);
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"PlayerWarp ").color(TextColor.fromHexString((String)"#FF5555"))).append(Component.text((String)warp.getWarpName()).color(TextColor.fromHexString((String)"#AA0000")))).append(Component.text((String)" already exists! Use: ").color(TextColor.fromHexString((String)"#FF5555")))).append(((TextComponent)((TextComponent)Component.text((String)("/setpwarp " + warp.getWarpName())).color(TextColor.fromHexString((String)"#AA0000"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click this to override this warp!").color(TextColor.fromHexString((String)"#FF5555"))))).clickEvent(ClickEvent.runCommand((String)("/setpwarp " + warp.getWarpName()))))).append(Component.text((String)" again to override it!").color(TextColor.fromHexString((String)"#FF5555"))));
            return;
        }
        int warpsMade = 0;
        int maxWarps = SystemHomes.plugin.getConfig().getInt("pwarp.max_warps", 3);
        for (PlayerWarp w : PlayerWarp.getPlayerWarps()) {
            if (!w.getOwningPlayer().equals(player.getUniqueId()) || ++warpsMade < maxWarps) continue;
            player.sendMessage(Component.text((String)"You already have the maximum amount of player warps set.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        try {
            warp.uploadPlayerWarp();
        }
        catch (Exception e) {
            player.sendMessage(Component.text((String)"Failed to upload PlayerWarp, please try again later.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"PlayerWarp ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)warp.getWarpName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" has been set to this location!").color(TextColor.fromHexString((String)"#55FF55"))));
    }

    @CommandAlias(value="delplayerwarp|delpwarp|remplayerwarp|rempwarp")
    @CommandCompletion(value="@pwarpNames")
    public void delPlayerWarp(CommandSender sender, String[] args) {
        PlayerWarp warp;
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Please put in the warp which you want to delete").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        String warpName = args[0].toLowerCase();
        try {
            warp = PlayerWarp.getPlayerWarp(warpName);
        }
        catch (RuntimeException e) {
            player.sendMessage(Component.text((String)"This warp does not exist.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        if (!warp.getOwningPlayer().equals(player.getUniqueId()) && !player.hasPermission("systemhomes.admin.pwarp")) {
            player.sendMessage(Component.text((String)"You can not delete this PlayerWarp as it does not belong to you!").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        try {
            warp.deletePlayerWarp();
        }
        catch (RuntimeException e) {
            player.sendMessage(Component.text((String)"This warp could not be deleted, please try again later.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"PlayerWarp ").color(TextColor.fromHexString((String)"#FF5555"))).append(Component.text((String)warpName).color(TextColor.fromHexString((String)"#AA0000")))).append(Component.text((String)" has been deleted!").color(TextColor.fromHexString((String)"#FF5555"))));
    }

    @CommandAlias(value="playerwarp|pwarp")
    @CommandCompletion(value="@pwarpNames")
    public void playerWarp(CommandSender sender, String[] args) {
        PlayerWarp warp;
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Please input to which warp you want to teleport.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        int delayInSeconds = SystemHomes.plugin.getConfig().getInt("pwarp.teleport_delay", 2);
        try {
            warp = PlayerWarp.getPlayerWarp(args[0].toLowerCase());
        }
        catch (RuntimeException e) {
            player.sendMessage(Component.text((String)"This warp does not exist.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        org.bukkit.Location location = warp.getLocation().toBukkitLocation();
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Teleporting you to PlayerWarp: ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)warp.getWarpName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)(" in " + delayInSeconds + " seconds.")).color(TextColor.fromHexString((String)"#55FF55"))));
        Bukkit.getScheduler().runTaskLater((Plugin)SystemHomes.plugin, () -> {
            player.teleport(location);
            player.sendMessage(((TextComponent)Component.text((String)"Teleported you to PlayerWarp: ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)warp.getWarpName()).color(TextColor.fromHexString((String)"#00AA00"))));
        }, (long)delayInSeconds * 20L);
    }

    @CommandAlias(value="playerwarps|pwarps")
    public void getPlayerWarps(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        List<PlayerWarp> warps = PlayerWarp.getPlayerWarps();
        Component component = Component.text((String)("The servers PlayerWarps (" + warps.size() + "):\n")).color(TextColor.fromHexString((String)"#FFAA00"));
        for (PlayerWarp warp : warps) {
            component = component.append(((TextComponent)((TextComponent)Component.text((String)warp.getWarpName()).color(TextColor.fromHexString((String)"#FFAA00"))).clickEvent(ClickEvent.runCommand((String)("/pwarp " + warp.getWarpName())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Teleport to PlayerWarp: " + warp.getWarpName())).color(TextColor.fromHexString((String)"#FFAA00")))));
            component = component.append(Component.text((String)" - ").color(TextColor.fromHexString((String)"#AAAAAA")));
            String worldName = switch (warp.world) {
                case "world" -> "Overworld";
                case "world_nether" -> "Nether";
                case "world_the_end" -> "The End";
                default -> warp.world;
            };
            component = component.append(((TextComponent)((TextComponent)Component.text((String)("(" + Bukkit.getOfflinePlayer((UUID)warp.getOwningPlayer()).getName() + "; " + worldName + "; " + (int)warp.x + ", " + (int)warp.y + ", " + (int)warp.z + ")\n")).color(TextColor.fromHexString((String)"#55FFFF"))).clickEvent(ClickEvent.runCommand((String)("/pwarp " + warp.getWarpName())))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Teleport to PlayerWarp: " + warp.getWarpName())).color(TextColor.fromHexString((String)"#FFAA00")))));
        }
        player.sendMessage(component);
    }

    public static List<String> pwarpNameToString() {
        ArrayList<String> warpNameList = new ArrayList<String>();
        List<PlayerWarp> warps = PlayerWarp.getPlayerWarps();
        for (PlayerWarp w : warps) {
            warpNameList.add(w.getWarpName());
        }
        return warpNameList;
    }
}

