/*
 * Decompiled with CFR 0.152.
 */
package cloud.cloudie.cloudsystem.commands;

import cloud.cloudie.cloudsystem.SystemHomes;
import cloud.cloudie.cloudsystem.classes.TpaRequest;
import cloud.cloudie.cloudsystem.enums.TpaType;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@CommandPermission(value="systemhomes.player.tpa")
public class TpaCommands
extends BaseCommand {
    final List<TpaRequest> tpaRequests = new ArrayList<TpaRequest>();

    @CommandAlias(value="tpa")
    @CommandCompletion(value="@players")
    public void tpa(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Please mention a player you'd want to teleport to.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(Component.text((String)"You can not teleport to an offline player.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage(Component.text((String)"You can not teleport to yourself.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        for (TpaRequest r : this.tpaRequests) {
            if (!r.getRequester().equals(player.getUniqueId())) continue;
            player.sendMessage(Component.text((String)"You already have an outgoing TPA request to this player").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        TpaRequest tpaRequest = new TpaRequest(player.getUniqueId(), target.getUniqueId());
        this.tpaRequests.add(tpaRequest);
        int timeoutTime = SystemHomes.plugin.getConfig().getInt("warp.request_timeout", 30);
        this.deleteTpaAfterDelay(player, target, timeoutTime, tpaRequest);
        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Teleport request sent to ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)target.getName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)".\nRequest will time out in ").color(TextColor.fromHexString((String)"#55FF55")))).append(Component.text((int)timeoutTime).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" seconds.").color(TextColor.fromHexString((String)"#55FF55"))));
        target.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)player.getName()).color(TextColor.fromHexString((String)"#00AA00"))).append(Component.text((String)" has requested to teleport to you.").color(TextColor.fromHexString((String)"#55FF55")))).append(((TextComponent)((TextComponent)Component.text((String)"\nWrite /tpaccept to accept this request.").color(TextColor.fromHexString((String)"#55FF55"))).clickEvent(ClickEvent.runCommand((String)"/tpaccept"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Accepts the TPA request").color(TextColor.fromHexString((String)"#55FF55")))))).append(((TextComponent)((TextComponent)Component.text((String)"\nWrite /tpdeny to deny this request.").color(TextColor.fromHexString((String)"#FF5555"))).clickEvent(ClickEvent.runCommand((String)"/tpdeny"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Denies the TPA request").color(TextColor.fromHexString((String)"#FF5555"))))));
    }

    @CommandAlias(value="tpahere")
    @CommandCompletion(value="@players")
    public void tpahere(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Please mention a player you'd want to teleport to.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(Component.text((String)"You can not teleport to an offline player.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage(Component.text((String)"You can not teleport to yourself.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        TpaRequest tpaRequest = new TpaRequest(player.getUniqueId(), target.getUniqueId(), TpaType.TPA_HERE);
        this.tpaRequests.add(tpaRequest);
        int timeoutTime = SystemHomes.plugin.getConfig().getInt("tpa.request_timeout", 30);
        this.deleteTpaAfterDelay(player, target, timeoutTime, tpaRequest);
        player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"Teleport request sent to ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)target.getName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)".\nRequest will time out in ").color(TextColor.fromHexString((String)"#55FF55")))).append(Component.text((int)timeoutTime).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" seconds.").color(TextColor.fromHexString((String)"#55FF55"))));
        target.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)player.getName()).color(TextColor.fromHexString((String)"#00AA00"))).append(Component.text((String)" has requested you to teleport to them.").color(TextColor.fromHexString((String)"#55FF55")))).append(((TextComponent)((TextComponent)Component.text((String)"\nWrite /tpaccept to accept this request.").color(TextColor.fromHexString((String)"#55FF55"))).clickEvent(ClickEvent.runCommand((String)"/tpaccept"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Accepts the TPA request").color(TextColor.fromHexString((String)"#55FF55")))))).append(((TextComponent)((TextComponent)Component.text((String)"\nWrite /tpdeny to deny this request.").color(TextColor.fromHexString((String)"#FF5555"))).clickEvent(ClickEvent.runCommand((String)"/tpdeny"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Denies the TPA request").color(TextColor.fromHexString((String)"#FF5555"))))));
    }

    @CommandAlias(value="tpaccept|tpyes")
    public void tpaccept(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        TpaRequest tpaRequest = null;
        for (TpaRequest r : this.tpaRequests) {
            if (!r.getTarget().equals(player.getUniqueId())) continue;
            tpaRequest = r;
            break;
        }
        if (tpaRequest == null) {
            player.sendMessage(Component.text((String)"You don't have any outgoing TPA requests.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player target = Bukkit.getPlayer((UUID)tpaRequest.getRequester());
        if (target == null) {
            player.sendMessage(Component.text((String)"Player is no longer online.").color(TextColor.fromHexString((String)"#FF5555")));
            this.tpaRequests.remove(tpaRequest);
            return;
        }
        int tpTime = SystemHomes.plugin.getConfig().getInt("tpa.teleport_delay", 2);
        this.tpaRequests.remove(tpaRequest);
        if (tpaRequest.getType() == TpaType.TPA_HERE) {
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"TPA request to ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)target.getName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" has been accepted.\nYou will be teleported in ").color(TextColor.fromHexString((String)"#55FF55")))).append(Component.text((int)tpTime).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" seconds.").color(TextColor.fromHexString((String)"#55FF55"))));
            target.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"The TPA request from ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)player.getName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" has been accepted.\nThey will be teleported to you in ").color(TextColor.fromHexString((String)"#55FF55")))).append(Component.text((int)tpTime).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" seconds.").color(TextColor.fromHexString((String)"#55FF55"))));
            Bukkit.getScheduler().runTaskLater((Plugin)SystemHomes.plugin, () -> player.teleport((Entity)target), (long)tpTime * 20L);
        } else if (tpaRequest.getType() == TpaType.TPA_THERE) {
            target.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"TPA request to ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)player.getName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" has been accepted.\nYou will be teleported in ").color(TextColor.fromHexString((String)"#55FF55")))).append(Component.text((int)tpTime).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" seconds.").color(TextColor.fromHexString((String)"#55FF55"))));
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"The TPA request from ").color(TextColor.fromHexString((String)"#55FF55"))).append(Component.text((String)target.getName()).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" has been accepted.\nThey will be teleported to you in ").color(TextColor.fromHexString((String)"#55FF55")))).append(Component.text((int)tpTime).color(TextColor.fromHexString((String)"#00AA00")))).append(Component.text((String)" seconds.").color(TextColor.fromHexString((String)"#55FF55"))));
            Bukkit.getScheduler().runTaskLater((Plugin)SystemHomes.plugin, () -> target.teleport((Entity)player), (long)tpTime * 20L);
        }
    }

    @CommandAlias(value="tpdeny|tpno")
    public void tpdeny(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only a player can run this command.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player player = (Player)sender;
        TpaRequest tpaRequest = null;
        for (TpaRequest r : this.tpaRequests) {
            if (!r.getTarget().equals(player.getUniqueId())) continue;
            tpaRequest = r;
            break;
        }
        if (tpaRequest == null) {
            player.sendMessage(Component.text((String)"You don't have any outgoing TPA requests.").color(TextColor.fromHexString((String)"#FF5555")));
            return;
        }
        Player target = Bukkit.getPlayer((UUID)tpaRequest.getRequester());
        OfflinePlayer targetOffline = Bukkit.getOfflinePlayer((UUID)tpaRequest.getRequester());
        this.tpaRequests.remove(tpaRequest);
        player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Declined ").color(TextColor.fromHexString((String)"#FF5555"))).append(Component.text((String)(targetOffline.getName() == null ? "Unknown" : targetOffline.getName())).color(TextColor.fromHexString((String)"#AA0000")))).append(Component.text((String)"'s TPA request.").color(TextColor.fromHexString((String)"#FF5555"))));
        if (target != null) {
            target.sendMessage(((TextComponent)Component.text((String)player.getName()).color(TextColor.fromHexString((String)"#AA0000"))).append(Component.text((String)" declined your TPA request.").color(TextColor.fromHexString((String)"#FF5555"))));
        }
    }

    private void deleteTpaAfterDelay(Player player, Player target, int requestTimeout, TpaRequest tpaRequest) {
        Bukkit.getScheduler().runTaskLater((Plugin)SystemHomes.plugin, () -> {
            if (this.tpaRequests.remove(tpaRequest)) {
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"TPA Request to ").color(TextColor.fromHexString((String)"#FF5555"))).append(Component.text((String)target.getName()).color(TextColor.fromHexString((String)"#AA0000")))).append(Component.text((String)" has timed out.").color(TextColor.fromHexString((String)"#FF5555"))));
                target.sendMessage(((TextComponent)((TextComponent)Component.text((String)"TPA Request from ").color(TextColor.fromHexString((String)"#FF5555"))).append(Component.text((String)player.getName()).color(TextColor.fromHexString((String)"#AA0000")))).append(Component.text((String)" has timed out.").color(TextColor.fromHexString((String)"#FF5555"))));
            }
        }, (long)requestTimeout * 20L);
    }
}

