/*
 * Decompiled with CFR 0.152.
 */
package com.example.coppergolemshulker;

import com.example.coppergolemshulker.config.CopperGolemConfig;
import com.example.coppergolemshulker.config.CopperGolemConfigScreen;
import com.example.coppergolemshulker.mixin.CopperGolemChestSearchMixin;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3708;
import net.minecraft.class_437;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopperGolemShulkerExtension
implements ModInitializer {
    public static final String MOD_ID = "copper_golem_shulker_extension";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"copper_golem_shulker_extension");
    private static CopperGolemConfig config = new CopperGolemConfig();
    private static final File CONFIG_FILE = new File("config/copper_golem_extension.json");
    private static final Map<Integer, Integer> lastUpdate = new HashMap<Integer, Integer>();
    private static boolean commandsEnabled = true;
    private static final Map<UUID, Integer> playerDepositRange = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> playerVerticalRange = new HashMap<UUID, Integer>();
    private static final Set<class_2338> knownContainers = new HashSet<class_2338>();
    private static int lastContainerScan = 0;

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Gson gson = new Gson();
                config = (CopperGolemConfig)gson.fromJson((Reader)reader, CopperGolemConfig.class);
                LOGGER.info("Config loaded from file");
            }
            catch (Exception e) {
                LOGGER.error("Failed to load config, using defaults", (Throwable)e);
                config = new CopperGolemConfig();
            }
        } else {
            config = new CopperGolemConfig();
            CopperGolemShulkerExtension.saveConfig();
        }
    }

    public void onInitialize() {
        LOGGER.info("Initializing Copper Golem Container Extension");
        CopperGolemShulkerExtension.loadConfig();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"coppergolem").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"admin").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"enable").executes(context -> {
            CopperGolemShulkerExtension.setCommandsEnabled(true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aCopperGolem commands enabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"disable").executes(context -> {
            CopperGolemShulkerExtension.setCommandsEnabled(false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cCopperGolem commands disabled"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"status").executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a76Commands: " + (commandsEnabled ? "\u00a7aENABLED" : "\u00a7cDISABLED"))), false);
            return 1;
        })))).then(class_2170.method_9247((String)"range").executes(context -> {
            if (!commandsEnabled) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            int currentRange = CopperGolemShulkerExtension.getPlayerDepositRange(player.method_5667());
            int verticalRange = CopperGolemShulkerExtension.getPlayerVerticalRange(player.method_5667());
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76=== Range Status ==="));
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a77Deposit Range: \u00a7e" + currentRange + " blocks")));
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a77Vertical Range: \u00a7e\u00b1" + verticalRange + " blocks")));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setrange").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"small").then(class_2170.method_9247((String)"1").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 1)))).then(class_2170.method_9247((String)"2").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 2)))).then(class_2170.method_9247((String)"3").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 3)))).then(class_2170.method_9247((String)"4").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 4))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"medium").then(class_2170.method_9247((String)"5").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 5)))).then(class_2170.method_9247((String)"6").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 6)))).then(class_2170.method_9247((String)"7").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 7)))).then(class_2170.method_9247((String)"8").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 8))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"large").then(class_2170.method_9247((String)"9").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 9)))).then(class_2170.method_9247((String)"10").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 10)))).then(class_2170.method_9247((String)"11").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 11)))).then(class_2170.method_9247((String)"12").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 12))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"huge").then(class_2170.method_9247((String)"13").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 13)))).then(class_2170.method_9247((String)"14").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 14)))).then(class_2170.method_9247((String)"15").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 15)))).then(class_2170.method_9247((String)"16").executes(context -> CopperGolemShulkerExtension.setRangeCommand((CommandContext<class_2168>)context, 16)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setheight").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"low").then(class_2170.method_9247((String)"1").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 1)))).then(class_2170.method_9247((String)"2").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 2)))).then(class_2170.method_9247((String)"3").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 3)))).then(class_2170.method_9247((String)"4").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 4))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"normal").then(class_2170.method_9247((String)"5").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 5)))).then(class_2170.method_9247((String)"6").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 6)))).then(class_2170.method_9247((String)"7").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 7)))).then(class_2170.method_9247((String)"8").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 8))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"high").then(class_2170.method_9247((String)"9").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 9)))).then(class_2170.method_9247((String)"10").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 10)))).then(class_2170.method_9247((String)"11").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 11)))).then(class_2170.method_9247((String)"12").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 12))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"extreme").then(class_2170.method_9247((String)"13").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 13)))).then(class_2170.method_9247((String)"14").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 14)))).then(class_2170.method_9247((String)"15").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 15)))).then(class_2170.method_9247((String)"16").executes(context -> CopperGolemShulkerExtension.setHeightCommand((CommandContext<class_2168>)context, 16)))))).then(class_2170.method_9247((String)"config").executes(context -> {
            if (!commandsEnabled) {
                return 0;
            }
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                class_3222 player = ((class_2168)context.getSource()).method_9207();
                CopperGolemShulkerExtension.openConfigGui(player);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cConfig GUI only available on client side"));
            return 0;
        }))).then(class_2170.method_9247((String)"vanilla").executes(context -> {
            if (!commandsEnabled) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CopperGolemChestSearchMixin.removePlayerPreference(player.method_5667());
            playerDepositRange.remove(player.method_5667());
            playerVerticalRange.remove(player.method_5667());
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Restored to vanilla behavior!"));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"prefer").then(class_2170.method_9247((String)"shulker").executes(context -> {
            if (!commandsEnabled) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CopperGolemChestSearchMixin.setPlayerPreference(player.method_5667(), "shulker");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Now preferring Shulker Boxes!"));
            return 1;
        }))).then(class_2170.method_9247((String)"barrel").executes(context -> {
            if (!commandsEnabled) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CopperGolemChestSearchMixin.setPlayerPreference(player.method_5667(), "barrel");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Now preferring Barrels!"));
            return 1;
        }))).then(class_2170.method_9247((String)"chest").executes(context -> {
            if (!commandsEnabled) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CopperGolemChestSearchMixin.setPlayerPreference(player.method_5667(), "chest");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Now preferring Chests!"));
            return 1;
        }))).then(class_2170.method_9247((String)"any").executes(context -> {
            if (!commandsEnabled) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            CopperGolemChestSearchMixin.setPlayerPreference(player.method_5667(), "any");
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Now using smart search!"));
            return 1;
        }))).then(class_2170.method_9247((String)"status").executes(context -> {
            boolean isVanilla;
            if (!commandsEnabled) {
                return 0;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            String preference = CopperGolemShulkerExtension.getEffectivePlayerPreference(player.method_5667());
            boolean bl = isVanilla = !CopperGolemChestSearchMixin.hasPlayerPreference(player.method_5667()) && config.getDefaultPreference().equals("any");
            if (isVanilla) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a76Mode: \u00a7eVanilla"));
            } else {
                String source = CopperGolemChestSearchMixin.hasPlayerPreference(player.method_5667()) ? "Personal" : "Config Default";
                player.method_64398((class_2561)class_2561.method_43470((String)("\u00a76Preference: \u00a7e" + preference + " \u00a77(" + source + ")")));
            }
            return 1;
        })))));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            int currentTick = server.method_3780();
            if (currentTick - lastContainerScan > 100) {
                this.cleanupInvalidContainers(server);
                lastContainerScan = currentTick;
            }
            for (class_3218 world : server.method_3738()) {
                for (class_1297 entity : world.method_27909()) {
                    if (!entity.getClass().getSimpleName().equals("class_11573")) continue;
                    this.enhanceGolemNavigation((class_1308)entity, (class_1937)world, currentTick);
                }
            }
            lastUpdate.entrySet().removeIf(entry -> currentTick - (Integer)entry.getValue() > 1200);
        });
    }

    private static int setRangeCommand(CommandContext<class_2168> context, int range) {
        if (!commandsEnabled) {
            return 0;
        }
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            int oldRange = CopperGolemShulkerExtension.getPlayerDepositRange(player.method_5667());
            CopperGolemShulkerExtension.setPlayerDepositRange(player.method_5667(), range);
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a76Range: \u00a7e" + oldRange + " \u00a76\u2192 \u00a7e" + range)));
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int setHeightCommand(CommandContext<class_2168> context, int height) {
        if (!commandsEnabled) {
            return 0;
        }
        try {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            int oldHeight = CopperGolemShulkerExtension.getPlayerVerticalRange(player.method_5667());
            CopperGolemShulkerExtension.setPlayerVerticalRange(player.method_5667(), height);
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a76Height: \u00a7e\u00b1" + oldHeight + " \u00a76\u2192 \u00a7e\u00b1" + height)));
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getEffectivePlayerPreference(UUID playerId) {
        if (CopperGolemChestSearchMixin.hasPlayerPreference(playerId)) {
            return CopperGolemChestSearchMixin.getPlayerPreference(playerId);
        }
        return config.getDefaultPreference();
    }

    public static void applyConfigDefaults(class_3222 player) {
        UUID playerId = player.method_5667();
        if (!CopperGolemChestSearchMixin.hasPlayerPreference(playerId) && !config.getDefaultPreference().equals("any")) {
            LOGGER.info("Applied config default preference '{}' to player {}", (Object)config.getDefaultPreference(), (Object)player.method_5477().getString());
        }
        if (!playerDepositRange.containsKey(playerId)) {
            CopperGolemShulkerExtension.setPlayerDepositRange(playerId, config.getDefaultDepositRange());
        }
        if (!playerVerticalRange.containsKey(playerId)) {
            CopperGolemShulkerExtension.setPlayerVerticalRange(playerId, config.getDefaultVerticalRange());
        }
    }

    public static int getPlayerDepositRange(UUID playerId) {
        return playerDepositRange.getOrDefault(playerId, config.getDefaultDepositRange());
    }

    public static void setPlayerDepositRange(UUID playerId, int range) {
        playerDepositRange.put(playerId, Math.min(Math.max(range, 1), 16));
    }

    public static int getPlayerVerticalRange(UUID playerId) {
        return playerVerticalRange.getOrDefault(playerId, config.getDefaultVerticalRange());
    }

    public static void setPlayerVerticalRange(UUID playerId, int range) {
        playerVerticalRange.put(playerId, Math.min(Math.max(range, 1), 16));
    }

    public static void setCommandsEnabled(boolean enabled) {
        commandsEnabled = enabled;
    }

    private void cleanupInvalidContainers(MinecraftServer server) {
        knownContainers.removeIf(pos -> {
            for (class_3218 world : server.method_3738()) {
                class_2680 state = world.method_8320(pos);
                class_2586 entity = world.method_8321(pos);
                if (entity instanceof class_2621 || state.method_26204() instanceof class_2281 || state.method_26204() instanceof class_2480 || state.method_26204() instanceof class_3708) continue;
                return true;
            }
            return false;
        });
    }

    private void enhanceGolemNavigation(class_1308 copperGolem, class_1937 world, int currentTick) {
        int entityId = copperGolem.method_5628();
        class_1799 heldItem = copperGolem.method_6047();
        if (heldItem.method_7960()) {
            return;
        }
        if (lastUpdate.containsKey(entityId) && currentTick - lastUpdate.get(entityId) < 20) {
            return;
        }
        class_3222 owner = this.findNearestPlayer(copperGolem, world);
        if (owner == null) {
            return;
        }
        CopperGolemShulkerExtension.applyConfigDefaults(owner);
        String preference = CopperGolemShulkerExtension.getEffectivePlayerPreference(owner.method_5667());
        if (preference.equals("any") && !CopperGolemChestSearchMixin.hasPlayerPreference(owner.method_5667()) && config.getDefaultPreference().equals("any")) {
            return;
        }
        copperGolem.method_5942().method_6340();
        int depositRange = CopperGolemShulkerExtension.getPlayerDepositRange(owner.method_5667());
        int verticalRange = CopperGolemShulkerExtension.getPlayerVerticalRange(owner.method_5667());
        class_2338 target = this.findBestAccessibleContainer(copperGolem.method_24515(), world, preference, depositRange, verticalRange, heldItem);
        if (target != null) {
            double distance = copperGolem.method_24515().method_10262((class_2382)target);
            if (!this.hasAvailableSpaceForItem(world, target, heldItem)) {
                LOGGER.warn("Container at {} no longer has space, searching new container", (Object)target);
                target = null;
            }
            if (target != null && distance <= (double)(depositRange * depositRange)) {
                if (this.trySmartDeposit(copperGolem, target, world, heldItem)) {
                    LOGGER.info("Deposited {} at {} (distance: {})", new Object[]{heldItem.method_7909().toString(), target, Math.sqrt(distance)});
                    lastUpdate.put(entityId, currentTick);
                    return;
                }
            } else if (target != null && this.canPathToContainer(copperGolem, target)) {
                copperGolem.method_5942().method_6337((double)target.method_10263() + 0.5, (double)target.method_10264(), (double)target.method_10260() + 0.5, 1.0);
                LOGGER.info("Navigating to {} at {} (distance: {})", new Object[]{this.getContainerTypeName(world.method_8320(target)), target, Math.sqrt(distance)});
            }
        } else {
            LOGGER.debug("No suitable container found for {}", (Object)heldItem.method_7909().toString());
        }
        lastUpdate.put(entityId, currentTick);
    }

    private class_2338 findBestAccessibleContainer(class_2338 golemPos, class_1937 world, String preference, int range, int verticalRange, class_1799 heldItem) {
        class_2338 bestContainer = null;
        double bestScore = Double.MAX_VALUE;
        int searchRange = Math.max(range * 2, 16);
        for (int x = -searchRange; x <= searchRange; ++x) {
            for (int y = -verticalRange; y <= verticalRange; ++y) {
                for (int z = -searchRange; z <= searchRange; ++z) {
                    class_2338 pos = golemPos.method_10069(x, y, z);
                    double distance = golemPos.method_10262((class_2382)pos);
                    if (distance > (double)(searchRange * searchRange)) continue;
                    class_2680 state = world.method_8320(pos);
                    boolean isTargetType = false;
                    double priorityMultiplier = 1.0;
                    switch (preference) {
                        case "shulker": {
                            isTargetType = state.method_26204() instanceof class_2480;
                            break;
                        }
                        case "barrel": {
                            isTargetType = state.method_26204() instanceof class_3708;
                            break;
                        }
                        case "chest": {
                            isTargetType = state.method_26204() instanceof class_2281 && !this.isCopperChest(state, world, pos);
                            break;
                        }
                        case "any": {
                            if (state.method_26204() instanceof class_2480) {
                                isTargetType = true;
                                priorityMultiplier = 0.8;
                                break;
                            }
                            if (state.method_26204() instanceof class_3708) {
                                isTargetType = true;
                                priorityMultiplier = 0.9;
                                break;
                            }
                            if (!(state.method_26204() instanceof class_2281) || this.isCopperChest(state, world, pos)) break;
                            isTargetType = true;
                        }
                    }
                    if (!isTargetType || !this.hasAvailableSpaceForItem(world, pos, heldItem)) continue;
                    double score = distance * priorityMultiplier;
                    int heightDiff = pos.method_10264() - golemPos.method_10264();
                    if (heightDiff > 0) {
                        score += (double)heightDiff * 0.2;
                    } else if (heightDiff < -1) {
                        score += (double)Math.abs(heightDiff) * 0.3;
                    }
                    if (distance < 25.0) {
                        LOGGER.info("Container: {} at {} - Distance: {}, Score: {}, HeightDiff: {}", new Object[]{this.getContainerTypeName(state), pos, Math.sqrt(distance), score, heightDiff});
                    }
                    if (!(score < bestScore)) continue;
                    bestContainer = pos;
                    bestScore = score;
                }
            }
        }
        return bestContainer;
    }

    private String getContainerTypeName(class_2680 state) {
        if (state.method_26204() instanceof class_2480) {
            return "shulker";
        }
        if (state.method_26204() instanceof class_3708) {
            return "barrel";
        }
        if (state.method_26204() instanceof class_2281) {
            return "chest";
        }
        return "container";
    }

    private boolean canPathToContainer(class_1308 copperGolem, class_2338 target) {
        try {
            class_11 path = copperGolem.method_5942().method_6348(target, 0);
            return path != null && path.method_21655();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean trySmartDeposit(class_1308 copperGolem, class_2338 containerPos, class_1937 world, class_1799 heldItem) {
        class_2586 blockEntity = world.method_8321(containerPos);
        if (blockEntity instanceof class_2621) {
            class_1799 slotStack;
            int i;
            class_2621 container = (class_2621)blockEntity;
            for (i = 0; i < container.method_5439(); ++i) {
                int spaceLeft;
                slotStack = container.method_5438(i);
                if (slotStack.method_7960() || !this.canStackItemsDirect(slotStack, heldItem) || (spaceLeft = slotStack.method_7914() - slotStack.method_7947()) <= 0) continue;
                int amountToAdd = Math.min(spaceLeft, heldItem.method_7947());
                slotStack.method_7933(amountToAdd);
                heldItem.method_7934(amountToAdd);
                if (heldItem.method_7960()) {
                    copperGolem.method_6122(class_1268.field_5808, class_1799.field_8037);
                }
                container.method_5431();
                if (config.isEnableSounds()) {
                    copperGolem.method_5783(class_3417.field_15197, 0.8f, 1.0f);
                }
                LOGGER.info("Stacked {} onto existing stack in slot {} at {}", new Object[]{heldItem.method_7909().toString(), i, containerPos});
                return true;
            }
            for (i = 0; i < container.method_5439(); ++i) {
                slotStack = container.method_5438(i);
                if (!slotStack.method_7960()) continue;
                container.method_5447(i, heldItem.method_7972());
                copperGolem.method_6122(class_1268.field_5808, class_1799.field_8037);
                container.method_5431();
                if (config.isEnableSounds()) {
                    copperGolem.method_5783(class_3417.field_15197, 0.8f, 1.0f);
                }
                LOGGER.info("Deposited {} in EMPTY slot {} at {}", new Object[]{heldItem.method_7909().toString(), i, containerPos});
                return true;
            }
        }
        return false;
    }

    private boolean hasAvailableSpaceForItem(class_1937 world, class_2338 pos, class_1799 heldItem) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2621)) {
            return false;
        }
        class_2621 container = (class_2621)blockEntity;
        for (int i = 0; i < container.method_5439(); ++i) {
            int spaceLeft;
            class_1799 slotStack = container.method_5438(i);
            if (slotStack.method_7960()) {
                return true;
            }
            if (!this.canStackItemsDirect(slotStack, heldItem) || (spaceLeft = slotStack.method_7914() - slotStack.method_7947()) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isCopperChest(class_2680 state, class_1937 world, class_2338 pos) {
        String className;
        String blockName = state.method_26204().method_63499().toLowerCase();
        if (blockName.contains("copper") && blockName.contains("chest")) {
            return true;
        }
        class_2586 entity = world.method_8321(pos);
        return entity != null && (className = entity.getClass().getSimpleName().toLowerCase()).contains("copper");
    }

    private boolean canStackItemsDirect(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7909() == stack2.method_7909();
    }

    private class_3222 findNearestPlayer(class_1308 copperGolem, class_1937 world) {
        class_3222 nearestPlayer = null;
        double nearestDistance = Double.MAX_VALUE;
        for (class_3222 player : ((class_3218)world).method_18456()) {
            double distance = player.method_5858((class_1297)copperGolem);
            if (!(distance < nearestDistance) || !(distance < 4096.0)) continue;
            nearestDistance = distance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    @Environment(value=EnvType.CLIENT)
    private static void openConfigGui(class_3222 player) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            class_310.method_1551().execute(() -> {
                class_437 currentScreen = class_310.method_1551().field_1755;
                class_437 configScreen = CopperGolemConfigScreen.create(currentScreen, config, () -> {
                    CopperGolemShulkerExtension.saveConfig();
                    LOGGER.info("Config saved by player: " + player.method_5477().getString());
                });
                class_310.method_1551().method_1507(configScreen);
            });
        }
    }

    public static CopperGolemConfig getConfig() {
        return config;
    }

    private static void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                gson.toJson((Object)config, (Appendable)writer);
            }
            LOGGER.info("Config saved to file: " + CONFIG_FILE.getAbsolutePath());
            LOGGER.info("Config values: Range=" + config.getDefaultDepositRange() + ", VerticalRange=" + config.getDefaultVerticalRange() + ", Sounds=" + config.isEnableSounds() + ", DefaultPreference=" + config.getDefaultPreference());
            Map<UUID, String> allPrefs = CopperGolemChestSearchMixin.getAllPreferences();
            LOGGER.info("Current player preferences: " + allPrefs.size() + " players have custom settings");
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }
}

